/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.BindingUtil;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.dom.Document;

public class SwingBinding
extends DefaultBinding {
    public SwingBinding(Document document, String sourceId, String sourceAttr, String targetId, String targetAttr) {
        super(document, sourceId, sourceAttr, targetId, targetAttr);
    }

    public SwingBinding(Document document, Object source, String sourceAttr, String targetId, String targetAttr) {
        super(document, source, sourceAttr, targetId, targetAttr);
    }

    public SwingBinding(Document document, String sourceId, String sourceAttr, Object target, String targetAttr) {
        super(document, sourceId, sourceAttr, target, targetAttr);
    }

    public SwingBinding(Object source, String sourceAttr, Object target, String targetAttr) {
        super(source, sourceAttr, target, targetAttr);
    }

    protected PropertyChangeListener setupBinding(Reference a, final String va, final Reference b, String vb, final BindingConvertor.Direction dir) {
        if (a.get() == null || va == null) {
            this.handleException(new BindingException("source bean or property is null"));
        }
        if (!(a.get() instanceof XulEventSource)) {
            this.handleException(new BindingException("Binding error, source object " + a.get() + " not a XulEventSource instance"));
        }
        if (b.get() == null || vb == null) {
            this.handleException(new BindingException("target bean or property is null"));
        }
        Method sourceGetMethod = BindingUtil.findGetMethod(a.get(), (String)va);
        Class getterClazz = BindingUtil.getMethodReturnType((Method)sourceGetMethod, a.get());
        this.getterMethods.push(sourceGetMethod);
        final Method targetSetMethod = BindingUtil.findSetMethod(b.get(), (String)vb, (Class)getterClazz);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                1 cThis = this;
                if (evt.getPropertyName().equalsIgnoreCase(va)) {
                    try {
                        Object targetObject;
                        Object value = SwingBinding.this.doConversions(evt.getNewValue(), dir);
                        value = SwingBinding.this.evaluateExpressions(value);
                        if (value != null && targetSetMethod.getParameterTypes()[0] == String.class && !targetSetMethod.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                            value = value.toString();
                        }
                        final Object finalVal = value;
                        if (!EventQueue.isDispatchThread() && b.get() instanceof XulComponent) {
                            logger.error((Object)("Binding Error! Update to XulComponenet (" + SwingBinding.this.target.get() + "," + SwingBinding.this.targetAttr + ") outside of event thread!"));
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Object targetObject = b.get();
                                        if (targetObject == null) {
                                            logger.error((Object)"Binding target was Garbage Collected, removing propListener");
                                            SwingBinding.this.destroyBindings();
                                            return;
                                        }
                                        targetSetMethod.invoke(targetObject, finalVal);
                                    }
                                    catch (InvocationTargetException e) {
                                        SwingBinding.this.handleException(new BindingException("Error invoking setter method [" + targetSetMethod.getName() + "] on target: " + SwingBinding.this.target, (Throwable)e));
                                    }
                                    catch (IllegalAccessException e) {
                                        SwingBinding.this.handleException(new BindingException("Error invoking setter method [" + targetSetMethod.getName() + "] on target: " + SwingBinding.this.target, (Throwable)e));
                                    }
                                }
                            });
                        }
                        if ((targetObject = b.get()) == null) {
                            logger.debug((Object)"Binding target was Garbage Collected, removing propListener");
                            SwingBinding.this.destroyBindings();
                            return;
                        }
                        logger.info((Object)("Setting val: " + finalVal + " on: " + targetObject));
                        targetSetMethod.invoke(targetObject, finalVal);
                    }
                    catch (Exception e) {
                        SwingBinding.this.handleException(new BindingException("Error invoking setter method [" + targetSetMethod.getName() + "] on target: " + SwingBinding.this.target.get(), (Throwable)e));
                    }
                }
            }
        };
        ((XulEventSource)a.get()).addPropertyChangeListener(listener);
        return listener;
    }
}

