/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.Illustrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionOperator
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(ExpressionOperator.class);
    private static final long serialVersionUID = 1L;

    public ExpressionOperator(OperatorKey k) {
        this(k, -1);
    }

    public ExpressionOperator(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        return new Result();
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    @Override
    public ExpressionOperator clone() throws CloneNotSupportedException {
        String s = "This expression operator does not implement clone.";
        log.error((Object)s);
        throw new CloneNotSupportedException(s);
    }

    protected abstract List<ExpressionOperator> getChildExpressions();

    public boolean containUDF() {
        if (this instanceof POUserFunc) {
            return true;
        }
        List<ExpressionOperator> l = this.getChildExpressions();
        if (l != null) {
            for (ExpressionOperator e : l) {
                if (!e.containUDF()) continue;
                return true;
            }
        }
        return false;
    }

    protected Result accumChild(List<ExpressionOperator> child, byte dataType) throws ExecException {
        try {
            if (this.isAccumStarted()) {
                if (child == null) {
                    child = this.getChildExpressions();
                }
                Result res = null;
                if (child != null) {
                    for (ExpressionOperator e : child) {
                        if (!e.containUDF()) continue;
                        res = e.getNext(dataType);
                        if (res.returnStatus == 5) continue;
                        return res;
                    }
                }
                res = new Result();
                res.returnStatus = (byte)5;
                return res;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw new ExecException("Exception while executing " + this.toString() + ": " + e.toString(), e);
        }
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + " " + super.toString() + " children: " + this.getChildExpressions() + " at " + this.getOriginalLocations() + "]";
    }
}

