/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.joda.time.DateTime;
import org.joda.time.Months;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonthsBetween
extends EvalFunc<Long> {
    @Override
    public Long exec(Tuple input) throws IOException {
        if (input == null || input.size() < 2 || input.get(0) == null || input.get(1) == null) {
            return null;
        }
        DateTime startDate = (DateTime)input.get(0);
        DateTime endDate = (DateTime)input.get(1);
        Months m = Months.monthsBetween(endDate, startDate);
        return m.getMonths();
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 15));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 30));
        s.add(new Schema.FieldSchema(null, 30));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }
}

