/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigServer;
import org.apache.pig.impl.PigContext;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.ScriptPigContext;
import org.apache.pig.scripting.SyncProgressNotificationAdaptor;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.PigProgressNotificationListener;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.PigStatsUtil;
import org.apache.pig.tools.pigstats.ScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundScript {
    private static final Log LOG = LogFactory.getLog(BoundScript.class);
    private List<String> queries = new ArrayList<String>();
    private String name = null;
    private ScriptPigContext scriptContext = null;

    BoundScript(String query, ScriptPigContext scriptContext, String name) {
        this.queries.add(query);
        this.scriptContext = scriptContext;
        this.name = name;
    }

    BoundScript(List<String> queries, ScriptPigContext scriptContext, String name) {
        this.queries.addAll(queries);
        this.scriptContext = ScriptPigContext.get();
        this.name = name;
    }

    public PigStats runSingle() throws IOException {
        return this.runSingle((Properties)null);
    }

    public PigStats runSingle(Properties prop) throws IOException {
        if (this.queries.size() > 1) {
            throw new IOException("This pipeline contains multiple queries. Use run() method instead");
        }
        if (this.queries.isEmpty()) {
            LOG.info((Object)"No bound query to run");
            return null;
        }
        if (prop != null) {
            this.scriptContext.getPigContext().getProperties().putAll((Map<?, ?>)prop);
        }
        PigStats ret = this.exec(this.queries.get(0));
        this.setPigStats(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PigStats runSingle(String propfile) throws IOException {
        Properties props = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propfile);
            props.load(fin);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return this.runSingle(props);
    }

    public List<PigStats> run() throws IOException {
        return this.run((Properties)null);
    }

    public List<PigStats> run(Properties prop) throws IOException {
        ArrayList<PigStats> stats = new ArrayList<PigStats>();
        if (this.queries.isEmpty()) {
            LOG.info((Object)"No bound query to run.");
            return stats;
        }
        if (this.queries.size() == 1) {
            PigStats ps = this.runSingle();
            stats.add(ps);
            return stats;
        }
        if (prop != null) {
            this.scriptContext.getPigContext().getProperties().putAll((Map<?, ?>)prop);
        }
        List<PigProgressNotificationListener> listeners = ScriptState.get().getAllListeners();
        SyncProgressNotificationAdaptor adaptor = new SyncProgressNotificationAdaptor(listeners);
        ArrayList<Future<PigStats>> futures = new ArrayList<Future<PigStats>>();
        ExecutorService executor = Executors.newFixedThreadPool(this.queries.size());
        for (int i = 0; i < this.queries.size(); ++i) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.scriptContext.getPigContext().getProperties());
            PigContext ctx = new PigContext(this.scriptContext.getPigContext().getExecType(), properties);
            MyCallable worker = new MyCallable(this.queries.get(i), ctx, adaptor);
            Future<PigStats> submit = executor.submit(worker);
            futures.add(submit);
        }
        for (Future future : futures) {
            PigStats failed;
            try {
                stats.add((PigStats)future.get());
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Pig pipeline failed to complete", (Throwable)e);
                PigStatsUtil.getEmptyPigStats();
                PigStatsUtil.setErrorMessage(e.getMessage());
                failed = PigStatsUtil.getPigStats(2);
                stats.add(failed);
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Pig pipeline failed to complete", (Throwable)e);
                PigStatsUtil.getEmptyPigStats();
                PigStatsUtil.setErrorMessage(e.getMessage());
                failed = PigStatsUtil.getPigStats(2);
                stats.add(failed);
            }
        }
        if (!stats.isEmpty()) {
            this.setPigStats(stats);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PigStats> run(String propfile) throws IOException {
        Properties prop = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(propfile);
            prop.load(fin);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return this.run(prop);
    }

    public void illustrate() throws IOException {
        if (this.queries.isEmpty()) {
            LOG.info((Object)"No bound query to illustrate");
            return;
        }
        PigServer pigServer = new PigServer(this.scriptContext.getPigContext(), false);
        this.registerQuery(pigServer, this.queries.get(0));
        pigServer.getExamples(null);
    }

    public void explain() throws IOException {
        if (this.queries.isEmpty()) {
            LOG.info((Object)"No bound query to explain");
            return;
        }
        PigServer pigServer = new PigServer(this.scriptContext.getPigContext(), false);
        this.registerQuery(pigServer, this.queries.get(0));
        pigServer.explain(null, System.out);
    }

    public void describe(String alias) throws IOException {
        if (this.queries.isEmpty()) {
            LOG.info((Object)"No bound query to describe");
            return;
        }
        PigServer pigServer = new PigServer(this.scriptContext.getPigContext(), false);
        this.registerQuery(pigServer, this.queries.get(0));
        pigServer.dumpSchema(alias);
    }

    private PigStats exec(String query) throws IOException {
        LOG.info((Object)("Query to run:\n" + query));
        List<PigProgressNotificationListener> listeners = ScriptState.get().getAllListeners();
        PigContext pc = this.scriptContext.getPigContext();
        ScriptState scriptState = pc.getExecutionEngine().instantiateScriptState();
        ScriptState.start(scriptState);
        ScriptState.get().setScript(query);
        for (PigProgressNotificationListener listener : listeners) {
            ScriptState.get().registerListener(listener);
        }
        PigServer pigServer = new PigServer(this.scriptContext.getPigContext(), false);
        pigServer.setBatchOn();
        GruntParser grunt = new GruntParser(new StringReader(query), pigServer);
        grunt.setInteractive(false);
        try {
            grunt.parseStopOnError(true);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse script " + e.getMessage(), e);
        }
        pigServer.executeBatch();
        return PigStats.get();
    }

    private void registerQuery(PigServer pigServer, String pl) throws IOException {
        GruntParser grunt = new GruntParser(new StringReader(pl), pigServer);
        grunt.setInteractive(false);
        pigServer.setBatchOn();
        try {
            grunt.parseStopOnError(true);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse query: " + pl, e);
        }
    }

    private void setPigStats(PigStats stats) {
        ScriptEngine engine = this.scriptContext.getScriptEngine();
        if (this.name != null) {
            engine.setPigStats(this.name, stats);
        } else {
            engine.setPigStats(stats.getScriptId(), stats);
        }
    }

    private void setPigStats(List<PigStats> lst) {
        if (lst == null || lst.isEmpty()) {
            return;
        }
        String key = this.name != null ? this.name : this.toString();
        ScriptEngine engine = this.scriptContext.getScriptEngine();
        for (PigStats stats : lst) {
            engine.setPigStats(key, stats);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyCallable
    implements Callable<PigStats> {
        private String query = null;
        private PigContext ctx = null;
        private PigProgressNotificationListener adaptor;

        public MyCallable(String pl, PigContext ctx, PigProgressNotificationListener adaptor) {
            this.query = pl;
            this.ctx = ctx;
            this.adaptor = adaptor;
        }

        @Override
        public PigStats call() throws Exception {
            LOG.info((Object)("Query to run:\n" + this.query));
            PigContext pc = BoundScript.this.scriptContext.getPigContext();
            ScriptState scriptState = pc.getExecutionEngine().instantiateScriptState();
            ScriptState.start(scriptState);
            ScriptState.get().setScript(this.query);
            ScriptState.get().registerListener(this.adaptor);
            PigServer pigServer = new PigServer(this.ctx, true);
            pigServer.setBatchOn();
            GruntParser grunt = new GruntParser(new StringReader(this.query), pigServer);
            grunt.setInteractive(false);
            try {
                grunt.parseStopOnError(true);
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse script", e);
            }
            pigServer.executeBatch();
            return PigStats.get();
        }
    }
}

