/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

public class CachableTableModel
extends AbstractTableModel
implements MetaTableModel {
    private GenericObjectTable<DefaultDataAttributes> cellAttributes;
    private GenericObjectTable<Object> cellValues;
    private ArrayList<DataAttributes> columnAttributes;
    private DataAttributes tableAttributes;
    private DataAttributeContext dataAttributeContext = new DefaultDataAttributeContext();

    public CachableTableModel(TableModel model) {
        DefaultDataAttributes attributes;
        this.columnAttributes = new ArrayList();
        if (model instanceof MetaTableModel) {
            MetaTableModel metaTableModel = (MetaTableModel)model;
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String columnName = model.getColumnName(i);
                Class<?> columnType = model.getColumnClass(i);
                DefaultDataAttributes attributes2 = new DefaultDataAttributes();
                attributes2.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "name", new DefaultConceptQueryMapper(), columnName);
                attributes2.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", new DefaultConceptQueryMapper(), columnType);
                attributes2.merge(metaTableModel.getColumnAttributes(i), this.dataAttributeContext);
                this.columnAttributes.add(attributes2);
            }
            if (metaTableModel.isCellDataAttributesSupported()) {
                this.cellAttributes = new GenericObjectTable(model.getRowCount(), model.getColumnCount());
                for (int row = 0; row < model.getRowCount(); ++row) {
                    for (int columns = 0; columns < model.getColumnCount(); ++columns) {
                        attributes = new DefaultDataAttributes();
                        attributes.merge(metaTableModel.getCellDataAttributes(row, columns), this.dataAttributeContext);
                        this.cellAttributes.setObject(row, columns, (Object)attributes);
                    }
                }
            }
            DefaultDataAttributes attributes3 = new DefaultDataAttributes();
            attributes3.merge(metaTableModel.getTableAttributes(), this.dataAttributeContext);
            this.tableAttributes = attributes3;
        } else {
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String columnName = model.getColumnName(i);
                Class<?> columnType = model.getColumnClass(i);
                attributes = new DefaultDataAttributes();
                attributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "name", new DefaultConceptQueryMapper(), columnName);
                attributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", new DefaultConceptQueryMapper(), columnType);
                this.columnAttributes.add(attributes);
            }
            this.tableAttributes = EmptyDataAttributes.INSTANCE;
        }
        this.cellValues = new GenericObjectTable(Math.max(1, model.getRowCount()), Math.max(1, model.getColumnCount()));
        for (int row = 0; row < model.getRowCount(); ++row) {
            for (int columns = 0; columns < model.getColumnCount(); ++columns) {
                this.cellValues.setObject(row, columns, model.getValueAt(row, columns));
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        DataAttributes attributes = this.columnAttributes.get(column);
        return (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "name", String.class, this.dataAttributeContext);
    }

    public Class getColumnClass(int columnIndex) {
        DataAttributes attributes = this.columnAttributes.get(columnIndex);
        return (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, this.dataAttributeContext);
    }

    @Override
    public DataAttributes getCellDataAttributes(int row, int column) {
        if (this.cellAttributes == null) {
            throw new IllegalStateException();
        }
        return (DataAttributes)this.cellAttributes.getObject(row, column);
    }

    @Override
    public boolean isCellDataAttributesSupported() {
        return this.cellAttributes != null;
    }

    @Override
    public DataAttributes getColumnAttributes(int column) {
        return this.columnAttributes.get(column);
    }

    @Override
    public DataAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    @Override
    public int getRowCount() {
        return this.cellValues.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.columnAttributes.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.cellValues.getObject(rowIndex, columnIndex);
    }

    public static boolean isSafeToCache(TableModel model) {
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Class<?> columnClass = model.getColumnClass(i);
            while (columnClass.isArray()) {
                columnClass = columnClass.getComponentType();
            }
            if (String.class.equals(columnClass) || Number.class.isAssignableFrom(columnClass) || Date.class.isAssignableFrom(columnClass) || columnClass.isPrimitive() || Paint.class.isAssignableFrom(columnClass) || Shape.class.isAssignableFrom(columnClass) || Stroke.class.isAssignableFrom(columnClass) || columnClass.isEnum()) continue;
            return false;
        }
        return true;
    }
}

