/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.AbstractElementType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ResourceLabelType
extends AbstractElementType {
    private static final Log logger = LogFactory.getLog(ResourceLabelType.class);
    public static final ResourceLabelType INSTANCE = new ResourceLabelType();

    public ResourceLabelType() {
        super("resource-label");
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object resourceKeyRaw = ElementTypeUtils.queryStaticValue(element);
        if (resourceKeyRaw == null) {
            return "<null>";
        }
        return resourceKeyRaw.toString();
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object resourceKeyRaw = ElementTypeUtils.queryStaticValue(element);
        if (resourceKeyRaw == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        String resourceKey = String.valueOf(resourceKeyRaw);
        String resourceId = ElementTypeUtils.queryResourceId(runtime, element);
        if (resourceId == null) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        try {
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (bundle != null) {
                return bundle.getString(resourceKey);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to retrieve the value for resource-bundle " + resourceId + " with key " + resourceKey));
        }
        return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
    }
}

