/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.linebreak;

import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.linebreak.ParagraphLinebreaker;
import org.pentaho.reporting.libraries.base.util.FastStack;

public final class FullLinebreaker
implements ParagraphLinebreaker {
    private RenderBox insertationPoint;
    private ParagraphRenderBox paragraphRenderBox;
    private Object suspendItem;
    private boolean breakRequested;

    public FullLinebreaker(ParagraphRenderBox paragraphRenderBox) {
        this.paragraphRenderBox = paragraphRenderBox;
        RenderBox pool = (RenderBox)paragraphRenderBox.getPool().deriveFrozen(false);
        RenderBox lineboxContainer = this.paragraphRenderBox.createLineboxContainer();
        lineboxContainer.clear();
        lineboxContainer.addGeneratedChild(pool);
        this.paragraphRenderBox.setLineBoxAge(0L);
        this.insertationPoint = pool;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void startBlockBox(RenderBox child) {
        RenderBox derived = (RenderBox)child.deriveFrozen(false);
        this.insertationPoint.addGeneratedChild(derived);
        this.insertationPoint = derived;
        if (this.suspendItem != null) {
            this.suspendItem = derived.getInstanceId();
        }
    }

    @Override
    public void finishBlockBox(RenderBox box) {
        this.insertationPoint = this.insertationPoint.getParent();
        if (this.suspendItem == box.getInstanceId()) {
            this.suspendItem = null;
        }
    }

    @Override
    public ParagraphLinebreaker startParagraphBox(ParagraphRenderBox box) {
        this.startBlockBox(box);
        return new FullLinebreaker((ParagraphRenderBox)this.insertationPoint);
    }

    @Override
    public void finishParagraphBox(ParagraphRenderBox box) {
        this.finishBlockBox(box);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    @Override
    public FullLinebreaker startComplexLayout() {
        return this;
    }

    @Override
    public void finish() {
        this.paragraphRenderBox.setLineBoxAge(this.paragraphRenderBox.getPool().getChangeTracker());
    }

    @Override
    public void startInlineBox(InlineRenderBox box) {
        RenderBox child = (RenderBox)box.deriveFrozen(false);
        this.insertationPoint.addGeneratedChild(child);
        this.insertationPoint = child;
    }

    @Override
    public void finishInlineBox(InlineRenderBox box) {
        this.insertationPoint = this.insertationPoint.getParent();
    }

    @Override
    public void addNode(RenderNode node) {
        this.insertationPoint.addGeneratedChild(node.deriveFrozen(true));
    }

    public void performBreak() {
        FastStack contexts = new FastStack();
        RenderBox lines = this.paragraphRenderBox.getLineboxContainer();
        for (RenderBox context = this.insertationPoint; context != lines; context = context.getParent()) {
            if ((context.getLayoutNodeType() & 0x42) != 66) {
                throw new IllegalStateException("Confused: I expect InlineBoxes ..");
            }
            InlineRenderBox inline = (InlineRenderBox)context;
            contexts.push((Object)inline.split(0));
        }
        this.insertationPoint = lines;
        while (!contexts.isEmpty()) {
            RenderBox box = (RenderBox)contexts.pop();
            this.insertationPoint.addGeneratedChild(box);
            this.insertationPoint = box;
        }
        this.breakRequested = false;
    }

    @Override
    public boolean isBreakRequested() {
        return this.breakRequested;
    }

    @Override
    public void setBreakRequested(boolean breakRequested) {
        this.breakRequested = breakRequested;
    }
}

