/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.text.LineBreakIteratorState;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class LineBreakIterator
implements Iterator<LineBreakIteratorState> {
    private final boolean justifiedLayout;
    private final LineBreakMeasurer lineBreakMeasurer;
    private final AttributedCharacterIterator ci;
    private final float wrappingWidth;

    public LineBreakIterator(ParagraphRenderBox box, FontRenderContext fontRenderContext, AttributedCharacterIterator ci) {
        this.wrappingWidth = (float)StrictGeomUtility.toExternalValue(box.getCachedWidth());
        this.justifiedLayout = ElementAlignment.JUSTIFY.equals(box.getStyleSheet().getStyleProperty(ElementStyleKeys.ALIGNMENT));
        this.ci = ci;
        this.lineBreakMeasurer = new LineBreakMeasurer(ci, fontRenderContext);
        this.lineBreakMeasurer.setPosition(ci.getBeginIndex());
    }

    @Override
    public boolean hasNext() {
        return this.lineBreakMeasurer.getPosition() < this.ci.getEndIndex();
    }

    @Override
    public LineBreakIteratorState next() {
        int start = this.lineBreakMeasurer.getPosition();
        TextLayout textLayout = this.lineBreakMeasurer.nextLayout(this.wrappingWidth + 0.5f, this.ci.getEndIndex(), false);
        textLayout = this.postProcess(start, textLayout, this.lineBreakMeasurer);
        int end = this.lineBreakMeasurer.getPosition();
        return new LineBreakIteratorState(textLayout, start, end);
    }

    protected TextLayout postProcess(int start, TextLayout textLayout, LineBreakMeasurer lineBreakMeasurer) {
        if (this.justifiedLayout) {
            return textLayout.getJustifiedLayout(this.wrappingWidth);
        }
        return textLayout;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

