/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.connections;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceMgmtService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceMgmtServiceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DuplicateDatasourceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.NonExistingDatasourceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.SerializedConnection;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.parser.DatabaseConnectionCollection;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.writer.DataSourceMgmtWriter;
import org.pentaho.reporting.engine.classic.core.util.ConfigurationPropertyLookupParser;
import org.pentaho.reporting.libraries.base.boot.SingletonHint;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

@SingletonHint
public class FileDataSourceMgmtService
implements DataSourceMgmtService {
    private static final Log logger = LogFactory.getLog(FileDataSourceMgmtService.class);
    private HashMap<String, SerializedConnection> connectionsByName;
    private HashMap<String, SerializedConnection> connectionsById = new HashMap();
    private File target;
    private long lastModifiedDate = -1L;

    public FileDataSourceMgmtService() {
        this.connectionsByName = new HashMap();
    }

    protected File createTargetFile() {
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        ConfigurationPropertyLookupParser parser = new ConfigurationPropertyLookupParser(globalConfig);
        String fileName = parser.translateAndLookup(globalConfig.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.connections.file-data.targetLocation"));
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        return file;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    @Override
    public synchronized String createDatasource(IDatabaseConnection databaseConnection) throws DuplicateDatasourceException, DatasourceMgmtServiceException {
        this.load();
        String name = databaseConnection.getName();
        if (name == null) {
            name = this.generateName();
        }
        if (this.connectionsByName.containsKey(name)) {
            throw new DuplicateDatasourceException();
        }
        String id = UUID.randomUUID().toString();
        databaseConnection.setId(id);
        databaseConnection.setName(name);
        SerializedConnection serializedConnection = new SerializedConnection(databaseConnection);
        this.connectionsById.put(id, serializedConnection);
        this.connectionsByName.put(name, serializedConnection);
        this.writeChanges();
        return id;
    }

    private String generateName() {
        return UUID.randomUUID().toString();
    }

    @Override
    public synchronized void deleteDatasourceById(String id) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        this.load();
        SerializedConnection connection = this.connectionsById.get(id);
        if (connection == null) {
            throw new NonExistingDatasourceException();
        }
        IDatabaseConnection databaseConnection = connection.getConnection();
        this.connectionsByName.remove(databaseConnection.getName());
        this.connectionsById.remove(databaseConnection.getId());
        this.writeChanges();
    }

    @Override
    public IDatabaseConnection getDatasourceByName(String name) throws DatasourceMgmtServiceException {
        this.load();
        SerializedConnection connection = this.connectionsByName.get(name);
        if (connection == null) {
            throw new NonExistingDatasourceException();
        }
        return connection.getConnection();
    }

    @Override
    public IDatabaseConnection getDatasourceById(String id) throws DatasourceMgmtServiceException {
        this.load();
        SerializedConnection connection = this.connectionsById.get(id);
        if (connection == null) {
            throw new NonExistingDatasourceException();
        }
        return connection.getConnection();
    }

    @Override
    public List<IDatabaseConnection> getDatasources() throws DatasourceMgmtServiceException {
        this.load();
        ArrayList<IDatabaseConnection> connections = new ArrayList<IDatabaseConnection>();
        Collection<SerializedConnection> values = this.connectionsById.values();
        for (SerializedConnection co : values) {
            connections.add(co.getConnection());
        }
        return connections;
    }

    @Override
    public List<String> getDatasourceIds() throws DatasourceMgmtServiceException {
        this.load();
        ArrayList<String> connections = new ArrayList<String>();
        Collection<SerializedConnection> values = this.connectionsById.values();
        for (SerializedConnection co : values) {
            connections.add(co.getConnection().getId());
        }
        return connections;
    }

    @Override
    public String updateDatasourceById(String id, IDatabaseConnection databaseConnection) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        this.load();
        SerializedConnection connection = this.connectionsById.get(id);
        if (connection == null) {
            throw new NonExistingDatasourceException();
        }
        String name = connection.getConnection().getName();
        databaseConnection.setId(id);
        SerializedConnection serializedConnection = new SerializedConnection(databaseConnection);
        this.connectionsById.put(id, serializedConnection);
        this.connectionsByName.remove(name);
        this.connectionsByName.put(serializedConnection.getConnection().getName(), serializedConnection);
        this.writeChanges();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        if (this.target == null) {
            this.target = this.createTargetFile();
        }
        if (this.target == null) {
            return;
        }
        if (this.target.lastModified() == this.lastModifiedDate) {
            return;
        }
        if (!this.target.exists()) {
            return;
        }
        FileDataSourceMgmtService fileDataSourceMgmtService = this;
        synchronized (fileDataSourceMgmtService) {
            try {
                ResourceManager mgr = new ResourceManager();
                mgr.registerDefaults();
                ResourceKey key = mgr.createKey((Object)this.target);
                Resource resource = mgr.create(key, null, DatabaseConnectionCollection.class);
                DatabaseConnectionCollection collection = (DatabaseConnectionCollection)resource.getResource();
                for (IDatabaseConnection connection : collection.getConnections()) {
                    String id = connection.getId();
                    String name = connection.getName();
                    if (name == null) {
                        logger.warn((Object)"Skipping invalid connection definition, name is empty.");
                        continue;
                    }
                    if (id == null) {
                        logger.warn((Object)"Skipping invalid connection definition, id is empty.");
                        continue;
                    }
                    SerializedConnection value = new SerializedConnection(connection);
                    this.connectionsById.put(id, value);
                    this.connectionsByName.put(name, value);
                }
            }
            catch (ResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)"Unable to parse datasource declaration.", (Throwable)e);
                } else {
                    logger.error((Object)("Unable to parse datasource declaration: " + (Object)((Object)e)));
                }
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)"Unable to parse datasource declaration.", (Throwable)e);
                } else {
                    logger.error((Object)("Unable to parse datasource declaration: " + e));
                }
            }
            finally {
                this.lastModifiedDate = this.target.lastModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeChanges() {
        List<IDatabaseConnection> datasources = this.getDatasources();
        IDatabaseConnection[] connections = datasources.toArray(new IDatabaseConnection[datasources.size()]);
        DataSourceMgmtWriter writer = (DataSourceMgmtWriter)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceMgmtWriter.class);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            writer.write(connections, bout);
            if (this.target == null) {
                this.target = this.createTargetFile();
            }
            if (this.target == null) {
                return;
            }
            FileOutputStream fout = new FileOutputStream(this.target);
            try {
                fout.write(bout.toByteArray());
            }
            finally {
                fout.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Unable to write datasource declaration.", (Throwable)e);
        }
    }
}

