/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sequence;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SequenceReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private Sequence data;
    private ArrayList<PropertyReadHandler> properties = new ArrayList();

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Required attribute 'name' is not defined.", this.getLocator());
        }
        String sequenceClass = attrs.getValue(this.getUri(), "class");
        Sequence sequence = (Sequence)ObjectUtilities.loadAndInstantiate((String)sequenceClass, SequenceReadHandler.class, Sequence.class);
        if (sequence == null) {
            throw new ParseException("Required attribute 'class' is invalid.", this.getLocator());
        }
        this.data = sequence;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            PropertyReadHandler definitionReadHandler = new PropertyReadHandler();
            this.properties.add(definitionReadHandler);
            return definitionReadHandler;
        }
        return null;
    }

    public Sequence getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    protected void doneParsing() throws SAXException {
        SequenceDescription sequenceDescription = this.data.getSequenceDescription();
        for (PropertyReadHandler propertyReadHandler : this.properties) {
            String propertyName = propertyReadHandler.getName();
            String propertyValue = propertyReadHandler.getResult();
            int pos = this.getPropertyLocation(sequenceDescription, propertyName);
            if (pos == -1) {
                throw new ParseException("Unable to set property " + propertyName + ". There is no such property.", this.getLocator());
            }
            Class ptype = sequenceDescription.getParameterType(pos);
            try {
                Object o = ConverterRegistry.toPropertyValue(propertyValue, ptype);
                this.data.setParameter(propertyName, o);
            }
            catch (BeanException e) {
                throw new ParseException("Unable to set property " + propertyName + ". Conversion error.", (Exception)e, this.getLocator());
            }
        }
    }

    private int getPropertyLocation(SequenceDescription sequenceDescription, String name) {
        int parameterCount = sequenceDescription.getParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            if (!name.equals(sequenceDescription.getParameterName(i))) continue;
            return i;
        }
        return -1;
    }

    public Object getObject() throws SAXException {
        return this.data;
    }
}

