/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.engine.classic.core.util.beans.ArrayValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BasicStrokeValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BigDecimalValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BigIntegerValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BooleanValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BorderStyleValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.BoxSizingValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ByteValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.CharacterValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ClassValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.DateValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.DoubleValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ElementAlignmentValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.EnumValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.FloatValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.FontSmoothValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.FontValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ImageMapValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.IntegerValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.LocaleValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.LongValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.SQLDateValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.SQLTimeValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.SQLTimestampValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ShortValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.StagingModeValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.StringValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.TextDirectionValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.TextWrapValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.TimeZoneValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.VerticalTextAlignValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.WhitespaceCollapseValueConverter;

public final class ConverterRegistry {
    private static ConverterRegistry instance;
    private HashMap<Class, ValueConverter> registeredClasses = new HashMap();

    public static synchronized ConverterRegistry getInstance() {
        if (instance == null) {
            instance = new ConverterRegistry();
        }
        return instance;
    }

    private ConverterRegistry() {
        this.registeredClasses.put(BigDecimal.class, new BigDecimalValueConverter());
        this.registeredClasses.put(BigInteger.class, new BigIntegerValueConverter());
        this.registeredClasses.put(Boolean.class, new BooleanValueConverter());
        this.registeredClasses.put(Boolean.TYPE, new BooleanValueConverter());
        this.registeredClasses.put(Byte.class, new ByteValueConverter());
        this.registeredClasses.put(Byte.TYPE, new ByteValueConverter());
        this.registeredClasses.put(Character.class, new CharacterValueConverter());
        this.registeredClasses.put(Character.TYPE, new CharacterValueConverter());
        this.registeredClasses.put(Color.class, new ColorValueConverter());
        this.registeredClasses.put(Double.class, new DoubleValueConverter());
        this.registeredClasses.put(Double.TYPE, new DoubleValueConverter());
        this.registeredClasses.put(Float.class, new FloatValueConverter());
        this.registeredClasses.put(Float.TYPE, new FloatValueConverter());
        this.registeredClasses.put(Integer.class, new IntegerValueConverter());
        this.registeredClasses.put(Integer.TYPE, new IntegerValueConverter());
        this.registeredClasses.put(ImageMap.class, new ImageMapValueConverter());
        this.registeredClasses.put(Long.class, new LongValueConverter());
        this.registeredClasses.put(Long.TYPE, new LongValueConverter());
        this.registeredClasses.put(Short.class, new ShortValueConverter());
        this.registeredClasses.put(Short.TYPE, new ShortValueConverter());
        this.registeredClasses.put(String.class, new StringValueConverter());
        this.registeredClasses.put(Number.class, new BigDecimalValueConverter());
        this.registeredClasses.put(Class.class, new ClassValueConverter());
        this.registeredClasses.put(Locale.class, new LocaleValueConverter());
        this.registeredClasses.put(TimeZone.class, new TimeZoneValueConverter());
        this.registeredClasses.put(java.util.Date.class, new DateValueConverter());
        this.registeredClasses.put(Font.class, new FontValueConverter());
        this.registeredClasses.put(ElementAlignment.class, new ElementAlignmentValueConverter());
        this.registeredClasses.put(WhitespaceCollapse.class, new WhitespaceCollapseValueConverter());
        this.registeredClasses.put(VerticalTextAlign.class, new VerticalTextAlignValueConverter());
        this.registeredClasses.put(BoxSizing.class, new BoxSizingValueConverter());
        this.registeredClasses.put(BorderStyle.class, new BorderStyleValueConverter());
        this.registeredClasses.put(FontSmooth.class, new FontSmoothValueConverter());
        this.registeredClasses.put(TextWrap.class, new TextWrapValueConverter());
        this.registeredClasses.put(TextDirection.class, new TextDirectionValueConverter());
        this.registeredClasses.put(Date.class, new SQLDateValueConverter());
        this.registeredClasses.put(Time.class, new SQLTimeValueConverter());
        this.registeredClasses.put(Timestamp.class, new SQLTimestampValueConverter());
        this.registeredClasses.put(StagingMode.class, new StagingModeValueConverter());
        this.registeredClasses.put(BasicStroke.class, new BasicStrokeValueConverter());
    }

    public ValueConverter getValueConverter(Class c) {
        Class<?> componentType;
        ValueConverter componentConverter;
        ValueConverter plain = this.registeredClasses.get(c);
        if (plain != null) {
            return plain;
        }
        if (c.isArray() && (componentConverter = this.getValueConverter(componentType = c.getComponentType())) != null) {
            return new ArrayValueConverter(componentType, componentConverter);
        }
        if (c.isEnum()) {
            return new EnumValueConverter(c);
        }
        return null;
    }

    public static String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            return null;
        }
        ValueConverter vc = ConverterRegistry.getInstance().getValueConverter(o.getClass());
        if (vc == null) {
            return null;
        }
        return vc.toAttributeValue(o);
    }

    public static Object toPropertyValue(String s, Class c) throws BeanException {
        if (s == null) {
            return null;
        }
        if (c == null) {
            return null;
        }
        ValueConverter vc = ConverterRegistry.getInstance().getValueConverter(c);
        if (vc == null) {
            return null;
        }
        return vc.toPropertyValue(s);
    }

    public static Object convert(Object o, Class c, Object defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (c.isInstance(o)) {
            return o;
        }
        try {
            String s = String.valueOf(o);
            return ConverterRegistry.toPropertyValue(s, c);
        }
        catch (BeanException e) {
            return defaultValue;
        }
    }
}

