/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.model;

import java.util.LinkedList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;

public class RepositoryTreeModel
implements TreeModel {
    private static final Log logger = LogFactory.getLog(RepositoryTreeModel.class);
    private String[] filters;
    private EventListenerList listenerList = new EventListenerList();
    private boolean showFoldersOnly = true;
    private boolean showHiddenFiles;
    private RepositoryTreeRoot root;
    private static final String[] EMPTY_FILTER = new String[0];

    public RepositoryTreeModel() {
        this.filters = EMPTY_FILTER;
        this.root = new RepositoryTreeRoot();
    }

    public RepositoryTreeModel(FileObject repositoryRoot, String[] filters, boolean showFoldersOnly) {
        this();
        this.filters = (String[])filters.clone();
        this.showFoldersOnly = showFoldersOnly;
        this.root.setRoot(repositoryRoot);
    }

    public void setShowFoldersOnly(boolean showFoldersOnly) {
        this.showFoldersOnly = showFoldersOnly;
        this.fireTreeDataChanged();
    }

    public boolean isShowFoldersOnly() {
        return this.showFoldersOnly;
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.fireTreeDataChanged();
    }

    public String[] getFilters() {
        return (String[])this.filters.clone();
    }

    public void setFilters(String[] filters) {
        this.filters = (String[])filters.clone();
        this.fireTreeDataChanged();
    }

    public FileObject getFileSystemRoot() {
        return this.root.getRoot();
    }

    public void setFileSystemRoot(FileObject root) {
        this.root.setRoot(root);
        this.fireTreeDataChanged();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        RepositoryTreeRoot root1;
        if (parent instanceof RepositoryTreeRoot && (parent = (root1 = (RepositoryTreeRoot)parent).getRoot()) == null) {
            return null;
        }
        try {
            FileObject parElement = (FileObject)parent;
            FileObject[] children = parElement.getChildren();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (this.isShowFoldersOnly() && child.getType() != FileType.FOLDER || !this.isShowHiddenFiles() && child.isHidden() || child.getType() != FileType.FOLDER && !PublishUtil.acceptFilter(this.filters, child.getName().getBaseName())) continue;
                if (count == index) {
                    return child;
                }
                ++count;
            }
            return children[index];
        }
        catch (FileSystemException fse) {
            logger.debug((Object)"Failed", (Throwable)fse);
            return null;
        }
    }

    @Override
    public int getChildCount(Object parent) {
        RepositoryTreeRoot root1;
        if (parent instanceof RepositoryTreeRoot && (parent = (root1 = (RepositoryTreeRoot)parent).getRoot()) == null) {
            return 0;
        }
        try {
            FileObject parElement = (FileObject)parent;
            if (parElement.getType() != FileType.FOLDER) {
                return 0;
            }
            FileObject[] children = parElement.getChildren();
            int count = 0;
            for (int i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                if (this.isShowFoldersOnly() && child.getType() != FileType.FOLDER || !this.isShowHiddenFiles() && child.isHidden() || child.getType() != FileType.FOLDER && !PublishUtil.acceptFilter(this.filters, child.getName().getBaseName())) continue;
                ++count;
            }
            return count;
        }
        catch (FileSystemException fse) {
            logger.debug((Object)"Failed", (Throwable)fse);
            return 0;
        }
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof RepositoryTreeRoot) {
            return false;
        }
        try {
            FileObject parElement = (FileObject)node;
            return parElement.getType() != FileType.FOLDER;
        }
        catch (FileSystemException fse) {
            logger.debug((Object)"Failed", (Throwable)fse);
            return false;
        }
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object childNode) {
        RepositoryTreeRoot root1;
        if (parent instanceof RepositoryTreeRoot && (parent = (root1 = (RepositoryTreeRoot)parent).getRoot()) == null) {
            return -1;
        }
        try {
            FileObject parChild = (FileObject)childNode;
            FileObject parElement = (FileObject)parent;
            FileObject[] childs = parElement.getChildren();
            int count = 0;
            for (int i = 0; i < childs.length; ++i) {
                FileObject child = childs[i];
                if (this.isShowFoldersOnly() && child.getType() != FileType.FOLDER || !this.isShowHiddenFiles() && child.isHidden() || child.getType() != FileType.FOLDER && !PublishUtil.acceptFilter(this.filters, child.getName().getBaseName())) continue;
                if (child.getName().equals(parChild.getName())) {
                    return count;
                }
                ++count;
            }
            return -1;
        }
        catch (FileSystemException fse) {
            logger.debug((Object)"Failed", (Throwable)fse);
            return -1;
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public void fireTreeDataChanged() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.root));
        TreeModelListener[] modelListeners = (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
        for (int i = 0; i < modelListeners.length; ++i) {
            TreeModelListener modelListener = modelListeners[i];
            modelListener.treeStructureChanged(event);
        }
    }

    public TreePath getTreePathForSelection(FileObject selectedFolder, String selection) throws FileSystemException {
        if (this.root.getRoot() == null) {
            return null;
        }
        if (this.root.getRoot().equals(selectedFolder)) {
            return new TreePath(this.root);
        }
        LinkedList<Object> list = new LinkedList<Object>();
        while (selectedFolder != null) {
            list.add(0, selectedFolder);
            FileObject parent = selectedFolder.getParent();
            if (selectedFolder.equals(parent) || this.root.getRoot().equals(parent)) break;
            selectedFolder = parent;
        }
        list.add(0, this.root);
        return new TreePath(list.toArray());
    }

    public static FileObject findNodeByName(FileObject node, String name) throws FileSystemException {
        if (node.getType() != FileType.FOLDER) {
            return null;
        }
        FileObject child = node.getChild(name);
        if (child == null) {
            return null;
        }
        return child;
    }

    private class RepositoryTreeRoot {
        private FileObject root;

        private RepositoryTreeRoot() {
        }

        public FileObject getRoot() {
            return this.root;
        }

        public void setRoot(FileObject root) {
            this.root = root;
        }
    }
}

