/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FieldDefinitionSource;
import org.pentaho.openformula.ui.FormulaEditorModel;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.openformula.ui.model2.FormulaElement;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.openformula.ui.util.InlineEditTextField;
import org.pentaho.openformula.ui.util.SelectFieldAction;
import org.pentaho.openformula.ui.util.TooltipLabel;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class DefaultFunctionParameterEditor
extends JPanel
implements FunctionParameterEditor,
FieldDefinitionSource {
    public static final int FIELDS_ADD = 2;
    private static final TextFieldHolderStruct[] EMPTY_FIELDS = new TextFieldHolderStruct[0];
    private static final FieldDefinition[] EMPTY_FIELDDEF = new FieldDefinition[0];
    private FunctionDescription selectedFunction;
    private JPanel parameterPane = new JPanel();
    private FieldDefinition[] fields;
    private TextFieldHolderStruct[] textFields;
    private boolean inSetupUpdate;
    private int parameterUpdatedCount;

    public DefaultFunctionParameterEditor() {
        this.parameterPane.setLayout(new GridBagLayout());
        this.inSetupUpdate = false;
        this.parameterUpdatedCount = -1;
        this.textFields = EMPTY_FIELDS;
        this.fields = EMPTY_FIELDDEF;
        JPanel parameterPaneCarrier = new JPanel();
        parameterPaneCarrier.setLayout(new BorderLayout());
        parameterPaneCarrier.add((Component)this.parameterPane, "North");
        JScrollPane comp = new JScrollPane(parameterPaneCarrier);
        comp.setBorder(new EmptyBorder(0, 0, 0, 0));
        comp.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new CardLayout());
        this.add("2", comp);
        this.add("1", Box.createRigidArea(new Dimension(650, 250)));
    }

    public FunctionDescription getSelectedFunction() {
        return this.selectedFunction;
    }

    @Override
    public void clearSelectedFunction() {
        this.setSelectedFunction(new FunctionParameterContext());
    }

    public boolean isMainFormula(FunctionParameterContext context) {
        FormulaEditorModel editorModel = context.getEditorModel();
        if (editorModel == null || editorModel.getLength() < 1) {
            return true;
        }
        FormulaElement mainFormulaElement = editorModel.getFormulaElementAt(1);
        FunctionInformation currentFunction = editorModel.getCurrentFunction();
        return mainFormulaElement != null && currentFunction != null && currentFunction.getFunctionOffset() == 1 && mainFormulaElement.getText().equals(currentFunction.getCanonicalName());
    }

    private boolean updateCurrentParameterField(FunctionParameterContext context) {
        FunctionDescription selectedFunction = context.getFunction();
        String[] parameterValues = context.getParameterValues();
        for (int i = 0; i < this.textFields.length; ++i) {
            String parameterValue = this.textFields[i].getText();
            if (parameterValue == null || !parameterValue.startsWith(selectedFunction.getCanonicalName())) continue;
            String updatedFormula = selectedFunction.getCanonicalName() + "(";
            for (int paramIndex = 0; paramIndex < parameterValues.length; ++paramIndex) {
                if (parameterValues[paramIndex] == null) continue;
                updatedFormula = updatedFormula + parameterValues[paramIndex];
                updatedFormula = updatedFormula + ";";
            }
            if (updatedFormula.endsWith(";")) {
                updatedFormula = updatedFormula.substring(0, updatedFormula.length() - 1);
            }
            if (parameterValue.endsWith(")")) {
                updatedFormula = updatedFormula + ")";
            }
            this.textFields[i].setText(updatedFormula);
            return true;
        }
        return false;
    }

    private void updateParameterFields(String[] parameterValues) {
        if (parameterValues != null && parameterValues.length <= this.textFields.length) {
            for (int i = 0; i < parameterValues.length; ++i) {
                String string = parameterValues[i];
                if (this.textFields[i] == null) continue;
                this.textFields[i].setText(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedFunction(FunctionParameterContext context) {
        try {
            this.inSetupUpdate = true;
            FunctionDescription fnDesc = context.getFunction();
            if (fnDesc == null) {
                for (int i = 0; i < this.textFields.length; ++i) {
                    this.textFields[i].dispose();
                }
                this.textFields = EMPTY_FIELDS;
                return;
            }
            boolean functionChanged = this.selectedFunction != fnDesc;
            this.selectedFunction = fnDesc;
            String[] parameterValues = context.getParameterValues();
            String[] parameterFieldValues = this.getParametersValues(context.getFunctionInformation(), context.getFunction());
            if (functionChanged) {
                this.parameterPane.removeAll();
                this.textFields = new TextFieldHolderStruct[parameterFieldValues.length];
                int fieldFocus = Math.max(0, this.parameterUpdatedCount);
                for (int i = 0; i < parameterFieldValues.length; ++i) {
                    this.textFields[i] = this.addTextField(parameterFieldValues[i], i, i == fieldFocus);
                }
            } else if (this.textFields.length != parameterFieldValues.length) {
                int i;
                TextFieldHolderStruct[] oldTextFields = this.textFields;
                this.textFields = new TextFieldHolderStruct[parameterFieldValues.length];
                System.arraycopy(oldTextFields, 0, this.textFields, 0, Math.min(oldTextFields.length, this.textFields.length));
                int fieldFocus = Math.max(0, this.parameterUpdatedCount);
                for (i = parameterFieldValues.length; i < oldTextFields.length; ++i) {
                    oldTextFields[i].dispose();
                }
                for (i = oldTextFields.length; i < parameterFieldValues.length; ++i) {
                    this.textFields[i] = this.addTextField(parameterFieldValues[i], i, i == fieldFocus);
                }
            }
            if (this.isMainFormula(context)) {
                this.updateParameterFields(parameterValues);
            } else if (!this.updateCurrentParameterField(context)) {
                this.updateParameterFields(parameterValues);
            }
        }
        finally {
            this.inSetupUpdate = false;
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    private TextFieldHolderStruct addTextField(String parameterValue, int parameterPosition, boolean requestFocus) {
        int paramPos = Math.max(0, Math.min(this.selectedFunction.getParameterCount() - 1, parameterPosition));
        String displayName = this.selectedFunction.getParameterDisplayName(paramPos, Locale.getDefault());
        String description = this.selectedFunction.getParameterDescription(paramPos, Locale.getDefault());
        JLabel paramNameLabel = new JLabel(displayName);
        InlineEditTextField paramTextField = new InlineEditTextField();
        paramTextField.setText(parameterValue);
        if (parameterValue != null) {
            paramTextField.setCaretPosition(parameterValue.length());
        }
        paramTextField.setFont(new Font("Monospaced", paramTextField.getFont().getStyle(), paramTextField.getFont().getSize()));
        FocusListenerHandler handler = new FocusListenerHandler(paramTextField, parameterPosition);
        paramTextField.addFocusListener(handler);
        if (requestFocus) {
            paramTextField.setFocusable(true);
            paramTextField.requestFocusInWindow();
        }
        SelectFieldAction selectFieldAction = new SelectFieldAction(this, new FieldSelectorUpdateHandler(parameterPosition), this);
        selectFieldAction.setFocusReturn(paramTextField);
        BorderlessButton button = new BorderlessButton((Action)selectFieldAction);
        TooltipLabel tooltipLabel = new TooltipLabel(description);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        this.parameterPane.add((Component)paramNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        this.parameterPane.add((Component)paramTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        this.parameterPane.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 5, 3, 5);
        this.parameterPane.add((Component)tooltipLabel, gbc);
        return new TextFieldHolderStruct(paramTextField, selectFieldAction, handler, new Component[]{paramNameLabel, button, tooltipLabel});
    }

    private static int computeFunctionParameterCount(FunctionInformation info, FunctionDescription desc) {
        if (!desc.isInfiniteParameterCount()) {
            return desc.getParameterCount();
        }
        String[] parameters = info.getParameters();
        int lastNonEmpty = 0;
        for (int i = 0; i < parameters.length; ++i) {
            String p = parameters[i];
            if (StringUtils.isEmpty((String)p)) continue;
            lastNonEmpty = i;
        }
        return Math.max(lastNonEmpty + 1, desc.getParameterCount()) + 2;
    }

    public String[] getParametersValues(FunctionInformation fnInfo, FunctionDescription fnDesc) {
        int paramCount = DefaultFunctionParameterEditor.computeFunctionParameterCount(fnInfo, fnDesc);
        String[] parameterValues = new String[paramCount];
        int definedParameterCount = Math.min(fnInfo.getParameterCount(), paramCount);
        for (int i = 0; i < definedParameterCount; ++i) {
            String text;
            parameterValues[i] = text = fnInfo.getParameterText(i);
        }
        if (definedParameterCount > 0 && fnInfo.getParameterCount() > paramCount) {
            int lastParamIdx;
            StringBuilder lastParamEatsAllBuffer = new StringBuilder(100);
            for (int i = lastParamIdx = definedParameterCount - 1; i < fnInfo.getParameterCount(); ++i) {
                if (i > lastParamIdx) {
                    lastParamEatsAllBuffer.append(';');
                }
                lastParamEatsAllBuffer.append(fnInfo.getParameterText(i));
            }
            parameterValues[lastParamIdx] = lastParamEatsAllBuffer.toString();
        }
        return parameterValues;
    }

    protected TextFieldHolderStruct getParameterField(int field) {
        return this.textFields[field];
    }

    public String getParameterValue(int param) {
        return this.textFields[param].getText();
    }

    @Override
    public void addParameterUpdateListener(ParameterUpdateListener listener) {
        if (this.listenerList.getListenerCount(ParameterUpdateListener.class) == 0) {
            this.listenerList.add(ParameterUpdateListener.class, listener);
        }
    }

    @Override
    public void removeParameterUpdateListener(ParameterUpdateListener listener) {
        this.listenerList.remove(ParameterUpdateListener.class, listener);
    }

    protected void fireParameterUpdate(int param, String text) {
        boolean catchAllParameter = this.selectedFunction.isInfiniteParameterCount() && param >= this.selectedFunction.getParameterCount();
        ParameterUpdateListener[] updateListeners = (ParameterUpdateListener[])this.listenerList.getListeners(ParameterUpdateListener.class);
        for (int i = 0; i < updateListeners.length; ++i) {
            ParameterUpdateListener listener = updateListeners[i];
            listener.parameterUpdated(new ParameterUpdateEvent(this, param, text, catchAllParameter));
        }
    }

    @Override
    public void setFields(FieldDefinition[] fields) {
        this.fields = (FieldDefinition[])fields.clone();
    }

    @Override
    public FieldDefinition[] getFields() {
        if (this.fields == null) {
            return new FieldDefinition[0];
        }
        return (FieldDefinition[])this.fields.clone();
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    private static class TextFieldHolderStruct {
        private InlineEditTextField textFields;
        private SelectFieldAction selectFieldAction;
        private FocusListenerHandler focusHandler;
        private Component[] extraComponents;

        protected TextFieldHolderStruct(InlineEditTextField textFields, SelectFieldAction selectFieldAction, FocusListenerHandler focusHandler, Component ... extraComponents) {
            this.textFields = textFields;
            this.selectFieldAction = selectFieldAction;
            this.focusHandler = focusHandler;
            this.extraComponents = extraComponents;
        }

        protected InlineEditTextField getTextFields() {
            return this.textFields;
        }

        public void setText(String text) {
            this.textFields.setText(text);
            if (text != null) {
                this.textFields.setCaretPosition(text.length());
            }
        }

        public String getText() {
            return this.textFields.getText();
        }

        public void dispose() {
            this.selectFieldAction.dispose();
            this.textFields.getParent().remove(this.textFields);
            for (Component c : this.extraComponents) {
                c.getParent().remove(c);
            }
        }
    }

    private class FocusListenerHandler
    extends FocusAdapter {
        private InlineEditTextField paramTextField;
        private int parameterIndex;

        private FocusListenerHandler(InlineEditTextField paramTextField, int parameterIndex) {
            this.paramTextField = paramTextField;
            this.parameterIndex = parameterIndex;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.handleFocusChange();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.handleFocusChange();
        }

        private void handleFocusChange() {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            String s = this.paramTextField.getText();
            DefaultFunctionParameterEditor.this.fireParameterUpdate(this.parameterIndex, s);
        }
    }

    private class FieldSelectorUpdateHandler
    implements PropertyChangeListener {
        private int paramIndex;

        private FieldSelectorUpdateHandler(int paramIndex) {
            this.paramIndex = paramIndex;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FieldDefinition value = (FieldDefinition)evt.getNewValue();
            if (value != null) {
                String text = FormulaUtil.quoteReference((String)value.getName());
                String parameterValue = DefaultFunctionParameterEditor.this.getParameterValue(this.paramIndex);
                TextFieldHolderStruct fieldStruct = DefaultFunctionParameterEditor.this.getParameterField(this.paramIndex);
                InlineEditTextField field = fieldStruct.getTextFields();
                StringBuilder b = new StringBuilder(parameterValue);
                b.delete(field.getSelectionStart(), field.getSelectionEnd());
                int caretPosition = field.getCaretPosition();
                b.insert(caretPosition, text);
                fieldStruct.setText(b.toString());
            }
        }
    }
}

