/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.common;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class DeserializedNumericComparator
extends ByteArrayComparable {
    protected long m_longValue;
    protected double m_doubleValue;
    protected boolean m_isInteger;
    protected boolean m_isLongOrDouble;

    public DeserializedNumericComparator(byte[] raw) {
        super(raw);
    }

    public DeserializedNumericComparator(boolean isInteger, boolean isLongOrDouble, long value) {
        this(Bytes.toBytes((long)value));
        this.m_isInteger = isInteger;
        this.m_isLongOrDouble = isLongOrDouble;
        this.m_longValue = value;
    }

    public DeserializedNumericComparator(boolean isInteger, boolean isLongOrDouble, double value) {
        this(Bytes.toBytes((double)value));
        this.m_isInteger = isInteger;
        this.m_isLongOrDouble = isLongOrDouble;
        this.m_doubleValue = value;
    }

    public byte[] getValue() {
        if (this.m_isInteger) {
            return Bytes.toBytes((long)this.m_longValue);
        }
        return Bytes.toBytes((double)this.m_doubleValue);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        try {
            this.write(output);
            output.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize to byte array.", e);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.m_isInteger = in.readBoolean();
        this.m_isLongOrDouble = in.readBoolean();
        this.m_longValue = in.readLong();
        this.m_doubleValue = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.m_isInteger);
        out.writeBoolean(this.m_isLongOrDouble);
        out.writeLong(this.m_longValue);
        out.writeDouble(this.m_doubleValue);
    }

    public int compareTo(byte[] value) {
        if (this.m_isInteger) {
            long compV = value.length == 8 ? Bytes.toLong((byte[])value) : (value.length == 4 ? (long)Bytes.toInt((byte[])value) : (long)Bytes.toShort((byte[])value));
            Long l = new Long(this.m_longValue);
            return l.compareTo(compV);
        }
        double compV = value.length == 8 ? Bytes.toDouble((byte[])value) : (double)Bytes.toFloat((byte[])value);
        Double d = new Double(this.m_doubleValue);
        return d.compareTo(compV);
    }

    public int compareTo(byte[] value, int offset, int length) {
        return this.compareTo(value);
    }
}

