/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.JavaBaseGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.Util;

public class JavaFunctorBaseGenerator
extends JavaBaseGenerator {
    private final Map functorMap = new HashMap();
    private final StringWriter functorSw = new StringWriter();
    private final PrintWriter functorPw = new PrintWriter(this.functorSw);

    JavaFunctorBaseGenerator(File srcFile, File file, String className, String baseClassName, ResourceDef.ResourceBundle resourceBundle) {
        super(srcFile, file, className, baseClassName, resourceBundle);
    }

    public void generateResource(ResourceDef.Resource resource, PrintWriter pw) {
        String errorClassName;
        if (resource.text == null) {
            throw new BuildException("Resource '" + resource.name + "' has no message");
        }
        String text = resource.text.cdata;
        String comment = ResourceGen.getComment(resource);
        String resourceInitcap = ResourceGen.getResourceInitcap(resource);
        String parameterList = this.getParameterList(text);
        String argumentList = this.getArgumentList(text);
        String propList = this.getPropList(resource);
        if (resource instanceof ResourceDef.Exception) {
            ResourceDef.Exception exception = (ResourceDef.Exception)resource;
            errorClassName = this.getErrorClass(exception);
        } else {
            errorClassName = null;
        }
        String functorType = this.getFunctorType(parameterList, argumentList, errorClassName);
        pw.println();
        Util.generateCommentBlock(pw, resource.name, text, comment);
        pw.println("    public final " + functorType + " " + resourceInitcap + " = new " + functorType + "(" + Util.quoteForJava(resourceInitcap) + ", " + Util.quoteForJava(text) + ", " + propList + ");");
    }

    private String getPropList(ResourceDef.Resource resource) {
        if (resource.properties == null || resource.properties.length == 0) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("new String[] {");
        for (int i = 0; i < resource.properties.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            ResourceDef.Property property = resource.properties[i];
            buf.append(Util.quoteForJava(property.name));
            buf.append(", ");
            buf.append(Util.quoteForJava(property.cdata));
        }
        buf.append("}");
        return buf.toString();
    }

    private String getFunctorType(String parameterList, String argumentList, String errorClassName) {
        List<String> key = Arrays.asList(parameterList, errorClassName);
        String functorType = (String)this.functorMap.get(key);
        if (functorType == null) {
            functorType = "_Def" + this.functorMap.size();
            this.functorMap.put(key, functorType);
            this.genFunctor(functorType, parameterList, argumentList, errorClassName, this.functorPw);
        }
        return functorType;
    }

    private void genFunctor(String functorType, String parameterList, String argumentList, String errorClassName, PrintWriter pw) {
        String definitionClass = "org.eigenbase.resgen.ResourceDefinition";
        String classNameSansPackage = Util.removePackage(this.className);
        String bundleThis = classNameSansPackage + ".this";
        String argumentArray = argumentList.equals("") ? "emptyObjectArray" : "new Object[] {" + argumentList + "}";
        pw.println();
        pw.println("    /**");
        pw.println("     * Definition for resources which");
        if (errorClassName != null) {
            pw.println("     * return a {@link " + errorClassName + "} exception and");
        }
        pw.println("     * take arguments '" + parameterList + "'.");
        pw.println("     */");
        pw.println("    public final class " + functorType + " extends " + definitionClass + " {");
        pw.println("        " + functorType + "(String key, String baseMessage, String[] props) {");
        pw.println("            super(key, baseMessage, props);");
        pw.println("        }");
        pw.println("        public String str(" + parameterList + ") {");
        pw.println("            return instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + ").toString();");
        pw.println("        }");
        if (errorClassName != null) {
            JavaBaseGenerator.ExceptionDescription ed = new JavaBaseGenerator.ExceptionDescription(this, errorClassName);
            if (ed.hasInstCon) {
                pw.println("        public " + errorClassName + " ex(" + parameterList + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + "));");
                pw.println("        }");
            } else if (ed.hasInstThrowCon) {
                pw.println("        public " + errorClassName + " ex(" + parameterList + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + "), null);");
                pw.println("        }");
            } else if (ed.hasStringCon) {
                pw.println("        public " + errorClassName + " ex(" + parameterList + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + ").toString());");
                pw.println("        }");
            } else if (ed.hasStringThrowCon) {
                pw.println("        public " + errorClassName + " ex(" + parameterList + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + ").toString(), null);");
                pw.println("        }");
            }
            if (ed.hasInstThrowCon) {
                pw.println("        public " + errorClassName + " ex(" + JavaFunctorBaseGenerator.addLists(parameterList, "Throwable err") + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + "), err);");
                pw.println("        }");
            } else if (ed.hasStringThrowCon) {
                pw.println("        public " + errorClassName + " ex(" + JavaFunctorBaseGenerator.addLists(parameterList, "Throwable err") + ") {");
                pw.println("            return new " + errorClassName + "(instantiate(" + JavaFunctorBaseGenerator.addLists(bundleThis, argumentArray) + ").toString(), err);");
                pw.println("        }");
            }
        }
        pw.println("    }");
    }

    protected void postModule(PrintWriter pw) {
        this.functorPw.flush();
        pw.println(this.functorSw.toString());
    }
}

