/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class FsActionExecutor
extends ActionExecutor {
    public FsActionExecutor() {
        super("fs");
    }

    Path getPath(Element element, String attribute) {
        String str = element.getAttributeValue(attribute).trim();
        return new Path(str);
    }

    void validatePath(Path path, boolean withScheme) throws ActionExecutorException {
        try {
            String scheme = path.toUri().getScheme();
            if (withScheme) {
                if (scheme == null) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS001", "Missing scheme in path [{0}]", path);
                }
                Services.get().get(HadoopAccessorService.class).checkSupportedFilesystem(path.toUri());
            } else if (scheme != null) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS002", "Scheme [{0}] not allowed in path [{1}]", scheme, path);
            }
        }
        catch (HadoopAccessorException hex) {
            throw this.convertException(hex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Path resolveToFullPath(Path nameNode, Path path, boolean withScheme) throws ActionExecutorException {
        if (nameNode == null) {
            this.validatePath(path, withScheme);
            return path;
        }
        String pathScheme = path.toUri().getScheme();
        String pathAuthority = path.toUri().getAuthority();
        if (pathScheme == null || pathAuthority == null) {
            if (!path.isAbsolute()) throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS011", "Path [{0}] cannot be relative", path);
            String nameNodeSchemeAuthority = nameNode.toUri().getScheme() + "://" + nameNode.toUri().getAuthority();
            return new Path(nameNodeSchemeAuthority + path.toString());
        }
        if (nameNode.toUri().getScheme().equals(pathScheme)) {
            if (nameNode.toUri().getAuthority().equals(pathAuthority)) return path;
        }
        this.validatePath(path, withScheme);
        return path;
    }

    void validateSameNN(Path source, Path dest) throws ActionExecutorException {
        String s;
        Path destPath = new Path(source, dest);
        String t = destPath.toUri().getScheme() + destPath.toUri().getAuthority();
        if (!t.equals(s = source.toUri().getScheme() + source.toUri().getAuthority())) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS007", "move, target NN URI different from that of source", dest);
        }
    }

    void doOperations(ActionExecutor.Context context, Element element) throws ActionExecutorException {
        try {
            String nameNode;
            FileSystem fs = context.getAppFileSystem();
            boolean recovery = fs.exists(this.getRecoveryPath(context));
            if (!recovery) {
                fs.mkdirs(this.getRecoveryPath(context));
            }
            Path nameNodePath = null;
            Element nameNodeElement = element.getChild("name-node", element.getNamespace());
            if (nameNodeElement != null && (nameNode = nameNodeElement.getTextTrim()) != null) {
                nameNodePath = new Path(nameNode);
                this.validatePath(nameNodePath, true);
            }
            XConfiguration fsConf = new XConfiguration();
            Path appPath = new Path(context.getWorkflow().getAppPath());
            if (fs.isFile(appPath)) {
                appPath = appPath.getParent();
            }
            JavaActionExecutor.parseJobXmlAndConfiguration(context, element, appPath, fsConf);
            for (Element commandElement : element.getChildren()) {
                Path path;
                String command = commandElement.getName();
                if (command.equals("mkdir")) {
                    path = this.getPath(commandElement, "path");
                    this.mkdir(context, fsConf, nameNodePath, path);
                    continue;
                }
                if (command.equals("delete")) {
                    path = this.getPath(commandElement, "path");
                    this.delete(context, fsConf, nameNodePath, path);
                    continue;
                }
                if (command.equals("move")) {
                    Path source = this.getPath(commandElement, "source");
                    Path target = this.getPath(commandElement, "target");
                    this.move(context, fsConf, nameNodePath, source, target, recovery);
                    continue;
                }
                if (command.equals("chmod")) {
                    path = this.getPath(commandElement, "path");
                    boolean recursive = commandElement.getChild("recursive", commandElement.getNamespace()) != null;
                    String str = commandElement.getAttributeValue("dir-files");
                    boolean dirFiles = str == null || Boolean.parseBoolean(str);
                    String permissionsMask = commandElement.getAttributeValue("permissions").trim();
                    this.chmod(context, fsConf, nameNodePath, path, permissionsMask, dirFiles, recursive);
                    continue;
                }
                if (command.equals("touchz")) {
                    path = this.getPath(commandElement, "path");
                    this.touchz(context, fsConf, nameNodePath, path);
                    continue;
                }
                if (!command.equals("chgrp")) continue;
                path = this.getPath(commandElement, "path");
                boolean recursive = commandElement.getChild("recursive", commandElement.getNamespace()) != null;
                String group = commandElement.getAttributeValue("group");
                String str = commandElement.getAttributeValue("dir-files");
                boolean dirFiles = str == null || Boolean.parseBoolean(str);
                this.chgrp(context, fsConf, nameNodePath, path, context.getWorkflow().getUser(), group, dirFiles, recursive);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void chgrp(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path, String user, String group, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("user", user);
        argsMap.put("group", group);
        try {
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            this.recursiveFsOperation("chgrp", fs, nameNodePath, path, argsMap, dirFiles, recursive, true);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void recursiveFsOperation(String op, FileSystem fs, Path nameNodePath, Path path, Map<String, String> argsMap, boolean dirFiles, boolean recursive, boolean isRoot) throws ActionExecutorException {
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            if (!fs.exists(path)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS009", op + ", path [{0}] does not exist", path);
            }
            FileStatus pathStatus = fs.getFileStatus(path);
            ArrayList<Path> paths = new ArrayList<Path>();
            if (dirFiles && pathStatus.isDir()) {
                if (isRoot) {
                    paths.add(path);
                }
                FileStatus[] filesStatus = fs.listStatus(path);
                for (int i = 0; i < filesStatus.length; ++i) {
                    Path p = filesStatus[i].getPath();
                    paths.add(p);
                    if (!recursive || !filesStatus[i].isDir()) continue;
                    this.recursiveFsOperation(op, fs, null, p, argsMap, dirFiles, recursive, false);
                }
            } else {
                paths.add(path);
            }
            for (Path p : paths) {
                this.doFsOperation(op, fs, p, argsMap);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void doFsOperation(String op, FileSystem fs, Path p, Map<String, String> argsMap) throws ActionExecutorException, IOException {
        if (op.equals("chmod")) {
            String permissions = argsMap.get("permissions");
            FsPermission newFsPermission = this.createShortPermission(permissions, p);
            fs.setPermission(p, newFsPermission);
        } else if (op.equals("chgrp")) {
            String user = argsMap.get("user");
            String group = argsMap.get("group");
            fs.setOwner(p, user, group);
        }
    }

    private FileSystem getFileSystemFor(Path path, ActionExecutor.Context context, XConfiguration fsConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        JobConf conf = has.createJobConf(path.toUri().getAuthority());
        XConfiguration.copy(context.getProtoActionConf(), (Configuration)conf);
        if (fsConf != null) {
            XConfiguration.copy(fsConf, (Configuration)conf);
        }
        return has.createFileSystem(user, path.toUri(), (Configuration)conf);
    }

    private FileSystem getFileSystemFor(Path path, String user) throws HadoopAccessorException {
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        JobConf jobConf = has.createJobConf(path.toUri().getAuthority());
        return has.createFileSystem(user, path.toUri(), (Configuration)jobConf);
    }

    void mkdir(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.mkdir(context, null, null, path);
    }

    void mkdir(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path) throws ActionExecutorException {
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            if (!fs.exists(path) && !fs.mkdirs(path)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS004", "mkdir, path [{0}] could not create directory", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void delete(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.delete(context, null, null, path);
    }

    public void delete(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path) throws ActionExecutorException {
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void delete(String user, String group, Path path) throws ActionExecutorException {
        try {
            this.validatePath(path, true);
            FileSystem fs = this.getFileSystemFor(path, user);
            if (fs.exists(path) && !fs.delete(path, true)) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS005", "delete, path [{0}] could not delete path", path);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void move(ActionExecutor.Context context, Path source, Path target, boolean recovery) throws ActionExecutorException {
        this.move(context, null, null, source, target, recovery);
    }

    public void move(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path source, Path target, boolean recovery) throws ActionExecutorException {
        try {
            source = this.resolveToFullPath(nameNodePath, source, true);
            this.validateSameNN(source, target);
            FileSystem fs = this.getFileSystemFor(source, context, fsConf);
            if (!fs.exists(source) && !recovery) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS006", "move, source path [{0}] does not exist", source);
            }
            if (!fs.rename(source, target) && !recovery) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS008", "move, could not move [{0}] to [{1}]", source, target);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void chmod(ActionExecutor.Context context, Path path, String permissions, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        this.chmod(context, null, null, path, permissions, dirFiles, recursive);
    }

    void chmod(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path, String permissions, boolean dirFiles, boolean recursive) throws ActionExecutorException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("permissions", permissions);
        try {
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            this.recursiveFsOperation("chmod", fs, nameNodePath, path, argsMap, dirFiles, recursive, true);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    void touchz(ActionExecutor.Context context, Path path) throws ActionExecutorException {
        this.touchz(context, null, null, path);
    }

    void touchz(ActionExecutor.Context context, XConfiguration fsConf, Path nameNodePath, Path path) throws ActionExecutorException {
        try {
            path = this.resolveToFullPath(nameNodePath, path, true);
            FileSystem fs = this.getFileSystemFor(path, context, fsConf);
            if (fs.exists(path)) {
                FileStatus st = fs.getFileStatus(path);
                if (st.isDir()) {
                    throw new Exception(path.toString() + " is a directory");
                }
                if (st.getLen() != 0L) {
                    throw new Exception(path.toString() + " must be a zero-length file");
                }
            }
            FSDataOutputStream out = fs.create(path);
            out.close();
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    FsPermission createShortPermission(String permissions, Path path) throws ActionExecutorException {
        if (permissions.length() == 3) {
            char user = permissions.charAt(0);
            char group = permissions.charAt(1);
            char other = permissions.charAt(2);
            int useri = user - 48;
            int groupi = group - 48;
            int otheri = other - 48;
            int mask = useri * 100 + groupi * 10 + otheri;
            short omask = Short.parseShort(Integer.toString(mask), 8);
            return new FsPermission(omask);
        }
        if (permissions.length() == 10) {
            return FsPermission.valueOf((String)permissions);
        }
        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS010", "chmod, path [{0}] invalid permissions mask [{1}]", path, permissions);
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            context.setStartData("-", "-", "-");
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.doOperations(context, actionXml);
            context.setExecutionData("OK", null);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = externalStatus.equals("OK") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        context.setEndData(status, this.getActionSignal(status));
        if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false)) {
            try {
                FileSystem fs = context.getAppFileSystem();
                fs.delete(context.getActionDir(), true);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    public Path getRecoveryPath(ActionExecutor.Context context) throws HadoopAccessorException, IOException, URISyntaxException {
        return new Path(context.getActionDir(), "fs-" + context.getRecoveryId());
    }
}

