/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.util.XLog;

public class HbaseCredentials
extends Credentials {
    @Override
    public void addtoJobConf(JobConf jobConf, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            this.copyHbaseConfToJobConf(jobConf, props);
            this.obtainToken(jobConf, context);
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in receiving hbase credentials", e);
            throw e;
        }
    }

    void copyHbaseConfToJobConf(JobConf jobConf, CredentialsProperties props) {
        Configuration hbaseConf = HBaseConfiguration.create();
        this.addPropsConf(props, hbaseConf);
        this.injectConf(hbaseConf, (Configuration)jobConf);
    }

    private void obtainToken(JobConf jobConf, ActionExecutor.Context context) throws IOException, InterruptedException {
        String user = context.getWorkflow().getUser();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        User u = User.create((UserGroupInformation)ugi);
        u.obtainAuthTokenForJob(jobConf);
    }

    private void addPropsConf(CredentialsProperties props, Configuration destConf) {
        for (Map.Entry<String, String> entry : props.getProperties().entrySet()) {
            destConf.set(entry.getKey(), entry.getValue());
        }
    }

    private void injectConf(Configuration srcConf, Configuration destConf) {
        for (Map.Entry entry : srcConf) {
            String name = (String)entry.getKey();
            if (destConf.get(name) != null) continue;
            String value = (String)entry.getValue();
            destConf.set(name, value);
        }
    }
}

