/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionForNominalTimeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;
import org.jdom.Element;

public class CoordUtils {
    public static final String HADOOP_USER = "user.name";

    public static String getDoneFlag(Element doneFlagElement) {
        if (doneFlagElement != null) {
            return doneFlagElement.getTextTrim();
        }
        return "_SUCCESS";
    }

    public static Configuration getHadoopConf(Configuration jobConf) {
        Configuration conf = new Configuration();
        ParamChecker.notNull(jobConf, "Configuration to be used for hadoop setup ");
        String user = ParamChecker.notEmpty(jobConf.get(HADOOP_USER), HADOOP_USER);
        conf.set(HADOOP_USER, user);
        return conf;
    }

    public static List<CoordinatorActionBean> getCoordActionsFromDates(String jobId, String scope) throws CommandException {
        String[] list;
        JPAService jpaService = Services.get().get(JPAService.class);
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<CoordinatorActionBean> actionSet = new HashSet<CoordinatorActionBean>();
        for (String s : list = scope.split(",")) {
            if ((s = s.trim()).contains("::")) {
                List<CoordinatorActionBean> listOfActions;
                try {
                    listOfActions = CoordActionsInDateRange.getCoordActionsFromDateRange(jobId, s);
                }
                catch (XException e) {
                    throw new CommandException(e);
                }
                actionSet.addAll(listOfActions);
                continue;
            }
            try {
                Date date = DateUtils.parseDateOozieTZ(s.trim());
                CoordinatorActionBean coordAction = jpaService.execute(new CoordJobGetActionForNominalTimeJPAExecutor(jobId, date));
                if (coordAction == null) {
                    throw new RuntimeException("This should never happen, Coordinator Action shouldn't be null");
                }
                actionSet.add(coordAction);
            }
            catch (ParseException e) {
                throw new CommandException(ErrorCode.E0302, s.trim(), e);
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (CoordinatorActionBean coordAction : actionSet) {
            coordActions.add(coordAction);
        }
        return coordActions;
    }

    public static List<CoordinatorActionBean> getCoordActionsFromIds(String jobId, String scope) throws CommandException {
        String[] list;
        JPAService jpaService = Services.get().get(JPAService.class);
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<String> actions = new HashSet<String>();
        for (String s : list = scope.split(",")) {
            if ((s = s.trim()).contains("-")) {
                int end;
                int start;
                String[] range = s.split("-");
                if (range.length != 2) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "', an example of correct format is 1-5");
                }
                try {
                    start = Integer.parseInt(range[0].trim());
                }
                catch (NumberFormatException ne) {
                    throw new CommandException(ErrorCode.E0302, "could not parse " + range[0].trim() + "into an integer", ne);
                }
                try {
                    end = Integer.parseInt(range[1].trim());
                }
                catch (NumberFormatException ne) {
                    throw new CommandException(ErrorCode.E0302, "could not parse " + range[1].trim() + "into an integer", ne);
                }
                if (start > end) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "', starting action" + "number of the range should be less than ending action number, an example will be 1-4");
                }
                for (int i = start; i <= end; ++i) {
                    actions.add(jobId + "@" + i);
                }
                continue;
            }
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
            }
            actions.add(jobId + "@" + s);
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (String id : actions) {
            CoordinatorActionBean coordAction;
            try {
                coordAction = jpaService.execute(new CoordActionGetJPAExecutor(id));
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            coordActions.add(coordAction);
        }
        return coordActions;
    }
}

