/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oozie.util.MultiFileReader;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;

public class XLogStreamer {
    private static XLog LOG = XLog.getLog(XLogStreamer.class);
    private String logFile;
    private String logPath;
    private Filter logFilter;
    private long logRotation;
    public static final Pattern gzTimePattern = Pattern.compile(".*-(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)-(\\d\\d)\\.gz");

    public XLogStreamer(Filter logFilter, String logPath, String logFile, long logRotationSecs) {
        this.logFilter = logFilter;
        if (logFile == null) {
            logFile = "oozie-app.log";
        }
        this.logFile = logFile;
        this.logPath = logPath;
        this.logRotation = logRotationSecs * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamLog(Writer writer, Date startTime, Date endTime) throws IOException {
        BufferedReader reader = this.makeReader(startTime, endTime);
        try {
            new TimestampedMessageParser(reader, this.logFilter).processRemaining(writer);
        }
        finally {
            reader.close();
        }
        writer.flush();
    }

    public BufferedReader makeReader(Date startTime, Date endTime) throws IOException {
        long startTimeMillis = 0L;
        if (startTime != null) {
            startTimeMillis = startTime.getTime();
        }
        long endTimeMillis = endTime == null ? System.currentTimeMillis() : endTime.getTime();
        File dir = new File(this.logPath);
        ArrayList<File> files = this.getFileList(dir, startTimeMillis, endTimeMillis, this.logRotation, this.logFile);
        return new BufferedReader(new MultiFileReader(files));
    }

    private ArrayList<File> getFileList(File dir, long startTime, long endTime, long logRotationTime, String logFile) {
        String[] children = dir.list();
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        if (children == null) {
            return new ArrayList<File>();
        }
        for (int i = 0; i < children.length; ++i) {
            String fileName = children[i];
            if (!fileName.startsWith(logFile) && !fileName.equals(logFile)) continue;
            File file = new File(dir.getAbsolutePath(), fileName);
            if (fileName.endsWith(".gz")) {
                long gzFileCreationTime = this.getGZFileCreationTime(fileName, startTime, endTime);
                if (gzFileCreationTime == -1L) continue;
                fileList.add(new FileInfo(file, gzFileCreationTime));
                continue;
            }
            long modTime = file.lastModified();
            if (modTime < startTime || modTime / logRotationTime > endTime / logRotationTime + 1L) continue;
            fileList.add(new FileInfo(file, modTime));
        }
        Collections.sort(fileList);
        ArrayList<File> files = new ArrayList<File>(fileList.size());
        for (FileInfo info : fileList) {
            files.add(info.getFile());
        }
        return files;
    }

    private long getGZFileCreationTime(String fileName, long startTime, long endTime) {
        long returnVal = -1L;
        if (fileName.equals("oozie.log.gz")) {
            LOG.warn("oozie.log has been GZipped, which is unexpected");
            returnVal = 0L;
        } else {
            Matcher m = gzTimePattern.matcher(fileName);
            if (m.matches() && m.groupCount() == 4) {
                int year = Integer.parseInt(m.group(1));
                int month = Integer.parseInt(m.group(2));
                int day = Integer.parseInt(m.group(3));
                int hour = Integer.parseInt(m.group(4));
                int minute = 0;
                Calendar calendarEntry = Calendar.getInstance();
                calendarEntry.set(year, month - 1, day, hour, minute);
                long logFileStartTime = calendarEntry.getTimeInMillis();
                long milliSecondsPerHour = 3600000L;
                long logFileEndTime = logFileStartTime + milliSecondsPerHour;
                if (startTime >= logFileStartTime && startTime <= logFileEndTime || endTime >= logFileStartTime && endTime <= logFileEndTime || startTime <= logFileStartTime && endTime >= logFileEndTime) {
                    returnVal = logFileStartTime;
                }
            } else {
                LOG.debug("Filename " + fileName + " does not match the expected format");
                returnVal = -1L;
            }
        }
        return returnVal;
    }

    public class FileInfo
    implements Comparable<FileInfo> {
        File file;
        long modTime;

        public FileInfo(File file, long modTime) {
            this.file = file;
            this.modTime = modTime;
        }

        public File getFile() {
            return this.file;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = this.modTime - fileInfo.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static class Filter {
        private Map<String, Integer> logLevels;
        private final Map<String, String> filterParams = new HashMap<String, String>();
        private static List<String> parameters = new ArrayList<String>();
        private boolean noFilter;
        private Pattern filterPattern;
        private static final String DEFAULT_REGEX = "[^\\]]*";
        public static final String ALLOW_ALL_REGEX = "(.*)";
        private static final String TIMESTAMP_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)";
        private static final String WHITE_SPACE_REGEX = "\\s+";
        private static final String LOG_LEVEL_REGEX = "(\\w+)";
        private static final String PREFIX_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+";
        private static final Pattern SPLITTER_PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+(.*)");

        public Filter() {
            for (int i = 0; i < parameters.size(); ++i) {
                this.filterParams.put(parameters.get(i), DEFAULT_REGEX);
            }
            this.logLevels = null;
            this.noFilter = true;
            this.filterPattern = null;
        }

        public void setLogLevel(String logLevel) {
            if (logLevel != null && logLevel.trim().length() > 0) {
                this.logLevels = new HashMap<String, Integer>();
                String[] levels = logLevel.split("\\|");
                for (int i = 0; i < levels.length; ++i) {
                    String s = levels[i].trim().toUpperCase();
                    try {
                        XLog.Level.valueOf(s);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    this.logLevels.put(levels[i].toUpperCase(), 1);
                }
            }
        }

        public void setParameter(String filterParam, String value) {
            if (this.filterParams.containsKey(filterParam)) {
                this.noFilter = false;
                this.filterParams.put(filterParam, value);
            }
        }

        public static void defineParameter(String filterParam) {
            parameters.add(filterParam);
        }

        public boolean isFilterPresent() {
            return !this.noFilter || this.logLevels != null;
        }

        public boolean matches(ArrayList<String> logParts) {
            String logLevel = logParts.get(1);
            String logMessage = logParts.get(2);
            if (this.logLevels == null || this.logLevels.containsKey(logLevel.toUpperCase())) {
                Matcher logMatcher = this.filterPattern.matcher(logMessage);
                return logMatcher.matches();
            }
            return false;
        }

        public ArrayList<String> splitLogMessage(String logLine) {
            Matcher splitter = SPLITTER_PATTERN.matcher(logLine);
            if (splitter.matches()) {
                ArrayList<String> logParts = new ArrayList<String>();
                logParts.add(splitter.group(1));
                logParts.add(splitter.group(2));
                logParts.add(splitter.group(3));
                return logParts;
            }
            return null;
        }

        public void constructPattern() {
            if (this.noFilter && this.logLevels == null) {
                this.filterPattern = Pattern.compile(ALLOW_ALL_REGEX);
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (this.noFilter) {
                sb.append(ALLOW_ALL_REGEX);
            } else {
                sb.append("(.* ");
                for (int i = 0; i < parameters.size(); ++i) {
                    sb.append(parameters.get(i) + "\\[");
                    sb.append(this.filterParams.get(parameters.get(i)) + "\\] ");
                }
                sb.append(".*)");
            }
            this.filterPattern = Pattern.compile(sb.toString());
        }

        public static void reset() {
            parameters.clear();
        }

        @VisibleForTesting
        public final Map<String, String> getFilterParams() {
            return this.filterParams;
        }
    }
}

