/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.connections;

import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceMgmtService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceMgmtServiceException;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceServiceException;
import org.pentaho.reporting.engine.classic.extensions.modules.connections.DataSourceCache;
import org.pentaho.reporting.engine.classic.extensions.modules.connections.DataSourceCacheManager;
import org.pentaho.reporting.engine.classic.extensions.modules.connections.Messages;
import org.pentaho.reporting.engine.classic.extensions.modules.connections.PooledDatasourceHelper;
import org.pentaho.reporting.libraries.base.boot.ObjectFactory;
import org.pentaho.reporting.libraries.base.boot.SingletonHint;

@SingletonHint
public class PooledDatasourceService
implements DataSourceService {
    private DataSourceCache cacheManager;

    public PooledDatasourceService() {
        ObjectFactory objectFactory = ClassicEngineBoot.getInstance().getObjectFactory();
        DataSourceCacheManager manager = (DataSourceCacheManager)objectFactory.get(DataSourceCacheManager.class);
        this.cacheManager = manager.getDataSourceCache();
    }

    protected DataSource retrieve(String datasource) throws DatasourceServiceException {
        try {
            DataSourceMgmtService datasourceMgmtSvc = (DataSourceMgmtService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceMgmtService.class);
            try {
                IDatabaseConnection databaseConnection = datasourceMgmtSvc.getDatasourceByName(datasource);
                return PooledDatasourceHelper.setupPooledDataSource(databaseConnection);
            }
            catch (DatasourceMgmtServiceException daoe) {
                return this.queryFallback(datasource);
            }
        }
        catch (DatasourceMgmtServiceException daoe) {
            throw new DatasourceServiceException(Messages.getInstance().getString("PooledDataSourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE", datasource), (Throwable)daoe);
        }
    }

    protected DataSource queryFallback(String dataSource) {
        throw new DatasourceServiceException(Messages.getInstance().getString("PooledDataSourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE", dataSource));
    }

    public void clearCache() {
        this.cacheManager.clear();
    }

    public void clearDataSource(String dsName) {
        this.cacheManager.remove(dsName);
    }

    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        if (this.cacheManager != null) {
            DataSource foundDs = this.cacheManager.get(dsName);
            if (foundDs != null) {
                return foundDs;
            }
            return this.retrieve(dsName);
        }
        return null;
    }

    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        return dsName;
    }
}

