/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAuthenticationFilter
extends AuthenticationFilter {
    public static final String AUTH_HANDLER_PROPERTY = "yarn.resourcemanager.authentication-handler";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties properties = super.getConfiguration(configPrefix, filterConfig);
        String yarnAuthHandler = properties.getProperty(AUTH_HANDLER_PROPERTY);
        if ((yarnAuthHandler == null || yarnAuthHandler.isEmpty()) && !properties.getProperty("type").equals("simple")) {
            throw new ServletException("Authentication handler class is empty");
        }
        if (properties.getProperty("type").equalsIgnoreCase("kerberos")) {
            properties.setProperty("type", yarnAuthHandler);
        }
        return properties;
    }
}

