/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.performance.StepPerformanceSnapShot;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class PerformanceLogTable
extends BaseLogTable
implements Cloneable,
LogTableInterface {
    private static Class<?> PKG = PerformanceLogTable.class;
    public static final String XML_TAG = "perf-log-table";
    private String logInterval;

    private PerformanceLogTable(VariableSpace space, HasDatabasesInterface databasesInterface) {
        super(space, databasesInterface, null, null, null);
    }

    @Override
    public Object clone() {
        try {
            PerformanceLogTable table = (PerformanceLogTable)super.clone();
            table.fields = new ArrayList();
            for (LogTableField field : this.fields) {
                table.fields.add((LogTableField)field.clone());
            }
            return table;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(XMLHandler.openTag((String)XML_TAG));
        retval.append(XMLHandler.addTagValue((String)"connection", (String)this.connectionName));
        retval.append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append(XMLHandler.addTagValue((String)"interval", (String)this.logInterval));
        retval.append(XMLHandler.addTagValue((String)"timeout_days", (String)this.timeoutInDays));
        retval.append(super.getFieldsXML());
        retval.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databases, List<StepMeta> steps) {
        this.connectionName = XMLHandler.getTagValue((Node)node, (String)"connection");
        this.schemaName = XMLHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XMLHandler.getTagValue((Node)node, (String)"table");
        this.logInterval = XMLHandler.getTagValue((Node)node, (String)"interval");
        this.timeoutInDays = XMLHandler.getTagValue((Node)node, (String)"timeout_days");
        super.loadFieldsXML(node);
    }

    @Override
    public void saveToRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.saveToRepository(attributeInterface);
        attributeInterface.setAttribute(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL, this.logInterval);
    }

    @Override
    public void loadFromRepository(RepositoryAttributeInterface attributeInterface) throws KettleException {
        super.loadFromRepository(attributeInterface);
        this.logInterval = attributeInterface.getAttributeString(this.getLogTableCode() + PROP_LOG_TABLE_INTERVAL);
    }

    public void replaceMeta(LogTableCoreInterface logTableInterface) {
        if (!(logTableInterface instanceof PerformanceLogTable)) {
            return;
        }
        PerformanceLogTable logTable = (PerformanceLogTable)logTableInterface;
        super.replaceMeta(logTable);
    }

    public static PerformanceLogTable getDefault(VariableSpace space, HasDatabasesInterface databasesInterface) {
        PerformanceLogTable table = new PerformanceLogTable(space, databasesInterface);
        table.fields.add(new LogTableField(ID.ID_BATCH.id, true, false, "ID_BATCH", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.BatchID", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.BatchID", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.SEQ_NR.id, true, false, "SEQ_NR", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.SeqNr", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.SeqNr", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.LOGDATE.id, true, false, "LOGDATE", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LogDate", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LogDate", (String[])new String[0]), 3, -1));
        table.fields.add(new LogTableField(ID.TRANSNAME.id, true, false, "TRANSNAME", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.TransName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.TransName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STEPNAME.id, true, false, "STEPNAME", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.StepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.StepName", (String[])new String[0]), 2, 255));
        table.fields.add(new LogTableField(ID.STEP_COPY.id, true, false, "STEP_COPY", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.StepCopy", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.StepCopy", (String[])new String[0]), 5, 8));
        table.fields.add(new LogTableField(ID.LINES_READ.id, true, false, "LINES_READ", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesRead", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesRead", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_WRITTEN.id, true, false, "LINES_WRITTEN", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesWritten", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesWritten", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_UPDATED.id, true, false, "LINES_UPDATED", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesUpdated", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_INPUT.id, true, false, "LINES_INPUT", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesInput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesInput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_OUTPUT.id, true, false, "LINES_OUTPUT", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesOutput", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesOutput", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.LINES_REJECTED.id, true, false, "LINES_REJECTED", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.LinesRejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.LinesRejected", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.ERRORS.id, true, false, "ERRORS", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.Errors", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.Errors", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.INPUT_BUFFER_ROWS.id, true, false, "INPUT_BUFFER_ROWS", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.InputBufferRows", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.InputBufferRows", (String[])new String[0]), 5, 18));
        table.fields.add(new LogTableField(ID.OUTPUT_BUFFER_ROWS.id, true, false, "OUTPUT_BUFFER_ROWS", BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldName.OutputBufferRows", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PerformanceLogTable.FieldDescription.OutputBufferRows", (String[])new String[0]), 5, 18));
        table.findField(ID.ID_BATCH.id).setKey(true);
        table.findField(ID.LOGDATE.id).setLogDateField(true);
        table.findField(ID.TRANSNAME.id).setNameField(true);
        return table;
    }

    public void setLogInterval(String logInterval) {
        this.logInterval = logInterval;
    }

    public String getLogInterval() {
        return this.logInterval;
    }

    public RowMetaAndData getLogRecord(LogStatus status, Object subject, Object parent) {
        if (subject == null || subject instanceof StepPerformanceSnapShot) {
            StepPerformanceSnapShot snapShot = (StepPerformanceSnapShot)subject;
            RowMetaAndData row = new RowMetaAndData();
            for (LogTableField field : this.fields) {
                if (!field.isEnabled()) continue;
                Object value = null;
                if (subject != null) {
                    switch (ID.valueOf(field.getId())) {
                        case ID_BATCH: {
                            value = new Long(snapShot.getBatchId());
                            break;
                        }
                        case SEQ_NR: {
                            value = new Long(snapShot.getSeqNr());
                            break;
                        }
                        case LOGDATE: {
                            value = snapShot.getDate();
                            break;
                        }
                        case TRANSNAME: {
                            value = snapShot.getTransName();
                            break;
                        }
                        case STEPNAME: {
                            value = snapShot.getStepName();
                            break;
                        }
                        case STEP_COPY: {
                            value = new Long(snapShot.getStepCopy());
                            break;
                        }
                        case LINES_READ: {
                            value = new Long(snapShot.getLinesRead());
                            break;
                        }
                        case LINES_WRITTEN: {
                            value = new Long(snapShot.getLinesWritten());
                            break;
                        }
                        case LINES_INPUT: {
                            value = new Long(snapShot.getLinesInput());
                            break;
                        }
                        case LINES_OUTPUT: {
                            value = new Long(snapShot.getLinesOutput());
                            break;
                        }
                        case LINES_UPDATED: {
                            value = new Long(snapShot.getLinesUpdated());
                            break;
                        }
                        case LINES_REJECTED: {
                            value = new Long(snapShot.getLinesRejected());
                            break;
                        }
                        case ERRORS: {
                            value = new Long(snapShot.getErrors());
                            break;
                        }
                        case INPUT_BUFFER_ROWS: {
                            value = new Long(snapShot.getInputBufferSize());
                            break;
                        }
                        case OUTPUT_BUFFER_ROWS: {
                            value = new Long(snapShot.getOutputBufferSize());
                            break;
                        }
                    }
                }
                row.addValue(field.getFieldName(), field.getDataType(), value);
                row.getRowMeta().getValueMeta(row.size() - 1).setLength(field.getLength());
            }
            return row;
        }
        return null;
    }

    @Override
    public String getLogTableCode() {
        return "PERFORMANCE";
    }

    public String getLogTableType() {
        return BaseMessages.getString(PKG, (String)"PerformanceLogTable.Type.Description", (String[])new String[0]);
    }

    @Override
    public String getConnectionNameVariable() {
        return "KETTLE_TRANS_PERFORMANCE_LOG_DB";
    }

    @Override
    public String getSchemaNameVariable() {
        return "KETTLE_TRANS_PERFORMANCE_LOG_SCHEMA";
    }

    @Override
    public String getTableNameVariable() {
        return "KETTLE_TRANS_PERFORMANCE_LOG_TABLE";
    }

    public List<RowMetaInterface> getRecommendedIndexes() {
        ArrayList<RowMetaInterface> indexes = new ArrayList<RowMetaInterface>();
        return indexes;
    }

    public static enum ID {
        ID_BATCH("ID_BATCH"),
        SEQ_NR("SEQ_NR"),
        LOGDATE("LOGDATE"),
        TRANSNAME("TRANSNAME"),
        STEPNAME("STEPNAME"),
        STEP_COPY("STEP_COPY"),
        LINES_READ("LINES_READ"),
        LINES_WRITTEN("LINES_WRITTEN"),
        LINES_UPDATED("LINES_UPDATED"),
        LINES_INPUT("LINES_INPUT"),
        LINES_OUTPUT("LINES_OUTPUT"),
        LINES_REJECTED("LINES_REJECTED"),
        ERRORS("ERRORS"),
        INPUT_BUFFER_ROWS("INPUT_BUFFER_ROWS"),
        OUTPUT_BUFFER_ROWS("OUTPUT_BUFFER_ROWS");

        private String id;

        private ID(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

