/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefiles;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDeleteFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDeleteFiles.class;
    public boolean argFromPrevious = false;
    public boolean includeSubfolders = false;
    public String[] arguments = null;
    public String[] filemasks;

    public JobEntryDeleteFiles(String n) {
        super(n, "");
    }

    public JobEntryDeleteFiles() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDeleteFiles je = (JobEntryDeleteFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.filemasks = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.filemasks = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.filemasks[a] = rep.getJobEntryAttributeString(id_jobentry, a, "filemask");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includeSubfolders);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "filemask", this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int NrErrFiles = 0;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.argFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String args_previous = resultRow.getString(0, null);
                String fmasks_previous = resultRow.getString(1, null);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingRow", (String[])new String[]{args_previous, fmasks_previous}));
                }
                if (this.ProcessFile(args_previous, fmasks_previous, this.parentJob)) continue;
                ++NrErrFiles;
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                }
                if (this.ProcessFile(this.arguments[i], this.filemasks[i], this.parentJob)) continue;
                ++NrErrFiles;
            }
        }
        if (NrErrFiles == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)NrErrFiles);
            result.setResult(false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ProcessFile(String filename, String wildcard, Job parentJob) {
        boolean rcode = false;
        FileObject filefolder = null;
        String realFilefoldername = this.environmentSubstitute(filename);
        String realwildcard = this.environmentSubstitute(wildcard);
        try {
            filefolder = KettleVFS.getFileObject((String)realFilefoldername, (VariableSpace)this);
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingFolder", (String[])new String[]{realFilefoldername}));
                    }
                    int Nr = filefolder.delete((FileSelector)new TextFileSelector(filefolder.toString(), realwildcard, parentJob));
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.TotalDeleted", (String[])new String[]{String.valueOf(Nr)}));
                    }
                    rcode = true;
                } else {
                    boolean deleted;
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.ProcessingFile", (String[])new String[]{realFilefoldername}));
                    }
                    if (!(deleted = filefolder.delete())) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.CouldNotDeleteFile", (String[])new String[]{realFilefoldername}));
                    } else {
                        if (this.log.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FileDeleted", (String[])new String[]{filename}));
                        }
                        rcode = true;
                    }
                }
            } else {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.FileAlreadyDeleted", (String[])new String[]{realFilefoldername}));
                }
                rcode = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFiles.CouldNotProcess", (String[])new String[]{realFilefoldername, e.getMessage()}), e);
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                }
                catch (IOException ex) {}
            }
        }
        return rcode;
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        Job parentjob;

        public TextFileSelector(String sourcefolderin, String filewildcard, Job parentJob) {
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
            this.parentjob = parentJob;
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder) && !this.parentjob.isStopped()) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (JobEntryDeleteFiles.this.includeSubfolders && info.getFile().getType() == FileType.FILE && JobEntryDeleteFiles.this.GetFileWildcard(short_filename, this.fileWildcard)) {
                            if (JobEntryDeleteFiles.this.log.isDetailed()) {
                                JobEntryDeleteFiles.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                            }
                            returncode = true;
                        }
                    } else if (info.getFile().getType() == FileType.FILE && JobEntryDeleteFiles.this.GetFileWildcard(short_filename, this.fileWildcard)) {
                        if (JobEntryDeleteFiles.this.log.isDetailed()) {
                            JobEntryDeleteFiles.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"JobEntryDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                JobEntryDeleteFiles.this.log.logError(BaseMessages.getString((Class)PKG, (String)"JobDeleteFiles.Error.Exception.DeleteProcessError", (String[])new String[0]), new Object[]{BaseMessages.getString((Class)PKG, (String)"JobDeleteFiles.Error.Exception.DeleteProcess", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

