/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import java.math.BigDecimal;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;

public class PGBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = PGBulkLoaderMeta.class;
    private PGBulkLoaderMeta meta;
    private PGBulkLoaderData data;

    public PGBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String getCopyCommand(RowMetaInterface rm, Object[] r) throws KettleException {
        DatabaseMeta dm = this.meta.getDatabaseMeta();
        String loadAction = this.environmentSubstitute(this.meta.getLoadAction());
        StringBuffer contents = new StringBuffer(500);
        String tableName = dm.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
        if (loadAction.equalsIgnoreCase("truncate")) {
            contents.append("TRUNCATE TABLE ");
            contents.append(tableName + ";");
            contents.append(Const.CR);
        }
        contents.append("COPY ");
        contents.append(tableName);
        contents.append(" ( ");
        String[] streamFields = this.meta.getFieldStream();
        String[] tableFields = this.meta.getFieldTable();
        if (streamFields == null || streamFields.length == 0) {
            throw new KettleException("No fields defined to load to database");
        }
        for (int i = 0; i < streamFields.length; ++i) {
            if (i != 0) {
                contents.append(", ");
            }
            contents.append(dm.quoteField(tableFields[i]));
        }
        contents.append(" ) ");
        contents.append(" FROM STDIN");
        contents.append(" WITH CSV DELIMITER AS '").append(this.environmentSubstitute(this.meta.getDelimiter())).append("' QUOTE AS '").append(this.environmentSubstitute(this.meta.getEnclosure())).append("'");
        contents.append(";").append(Const.CR);
        return contents.toString();
    }

    public String createCommandLine(PGBulkLoaderMeta meta, boolean password) throws KettleException {
        StringBuffer sb = new StringBuffer(300);
        if (meta.getPsqlpath() != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getPsqlpath()), (VariableSpace)this.getTransMeta());
                String psqlexec = Const.optionallyQuoteStringByOS((String)KettleVFS.getFilename((FileObject)fileObject));
                sb.append(psqlexec);
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving sqlldr string", (Throwable)ex);
            }
        } else {
            if (this.isDetailed()) {
                this.logDetailed("psql defaults to system path");
            }
            sb.append("psql");
        }
        DatabaseMeta dm = meta.getDatabaseMeta();
        if (dm != null) {
            String user = Const.NVL((String)dm.getUsername(), (String)"");
            sb.append(" -U ").append(this.environmentSubstitute(user));
            String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
            String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
            sb.append(" -h ");
            sb.append(hostname);
            sb.append(" -p ");
            sb.append(portnum);
            if (meta.isStopOnError()) {
                sb.append(" -v ON_ERROR_STOP=1");
            }
            String dns = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
            sb.append(" ");
            String overrideName = this.environmentSubstitute(meta.getDbNameOverride());
            if (Const.isEmpty((String)Const.rtrim((String)overrideName))) {
                sb.append(this.environmentSubstitute(dns));
            } else {
                sb.append(overrideName);
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    public boolean execute(PGBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            String cmd = this.createCommandLine(meta, true);
            this.logBasic("Executing command: " + cmd);
            this.data.psqlProcess = rt.exec(cmd);
            this.data.errorLogger = new StreamLogger(this.log, this.data.psqlProcess.getErrorStream(), "ERROR {0}");
            this.data.outputLogger = new StreamLogger(this.log, this.data.psqlProcess.getInputStream(), "OUTPUT {0}");
            this.data.pgOutputStream = this.data.psqlProcess.getOutputStream();
            new Thread((Runnable)this.data.errorLogger).start();
            new Thread((Runnable)this.data.outputLogger).start();
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing psql : " + this.createCommandLine(meta, false), (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (this.data != null && this.data.psqlProcess != null) {
                    this.data.pgOutputStream.flush();
                    this.data.pgOutputStream.close();
                    int exitVal = this.data.psqlProcess.waitFor();
                    this.logBasic(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
                    if (this.meta.isStopOnError() && exitVal != 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"PGBulkLoader.Exception.ExitValueNotZero", (Object[])new Object[]{exitVal}));
                    }
                } else {
                    this.logBasic(BaseMessages.getString(PKG, (String)"PGBulkLoader.Log.NullInputAndOrPSQLProcess", (String[])new String[0]));
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
                String copyCmd = this.getCopyCommand(this.getInputRowMeta(), r);
                this.logBasic("Launching command: " + copyCmd);
                this.data.pgOutputStream.write(copyCmd.getBytes());
            }
            this.writeRowToPostgres(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeRowToPostgres(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            int i = 0;
            while (true) {
                if (i >= this.data.keynrs.length) {
                    this.data.pgOutputStream.write(this.data.newline);
                    return;
                }
                if (i > 0) {
                    this.data.pgOutputStream.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData != null) {
                    block1 : switch (valueMeta.getType()) {
                        case 2: {
                            this.data.pgOutputStream.write(this.data.quote);
                            String quoteStr = new String(this.data.quote);
                            String escapedString = valueMeta.getString(valueData).replace(quoteStr, quoteStr + quoteStr);
                            this.data.pgOutputStream.write(escapedString.getBytes());
                            this.data.pgOutputStream.write(this.data.quote);
                            break;
                        }
                        case 5: {
                            if (valueMeta.isStorageBinaryString()) {
                                this.data.pgOutputStream.write((byte[])valueData);
                                break;
                            }
                            this.data.pgOutputStream.write(Long.toString(valueMeta.getInteger(valueData)).getBytes());
                            break;
                        }
                        case 3: {
                            switch (this.data.dateFormatChoices[i]) {
                                case 0: {
                                    if (valueMeta.isStorageBinaryString()) {
                                        this.data.pgOutputStream.write((byte[])valueData);
                                        break block1;
                                    }
                                    String dateString = valueMeta.getString(valueData);
                                    if (dateString == null) break block1;
                                    this.data.pgOutputStream.write(dateString.getBytes());
                                    break block1;
                                }
                                case 1: {
                                    String dateString = this.data.dateMeta.getString((Object)valueMeta.getDate(valueData));
                                    if (dateString == null) break;
                                    this.data.pgOutputStream.write(dateString.getBytes());
                                    break block1;
                                }
                                case 2: {
                                    String dateTimeString = this.data.dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                    if (dateTimeString == null) break;
                                    this.data.pgOutputStream.write(dateTimeString.getBytes());
                                    break block1;
                                }
                            }
                            break;
                        }
                        case 4: {
                            if (valueMeta.isStorageBinaryString()) {
                                this.data.pgOutputStream.write((byte[])valueData);
                                break;
                            }
                            this.data.pgOutputStream.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                            break;
                        }
                        case 1: {
                            if (valueMeta.isStorageBinaryString()) {
                                this.data.pgOutputStream.write((byte[])valueData);
                                break;
                            }
                            this.data.pgOutputStream.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                            break;
                        }
                        case 6: {
                            if (valueMeta.isStorageBinaryString()) {
                                this.data.pgOutputStream.write((byte[])valueData);
                                break;
                            }
                            BigDecimal big = valueMeta.getBigNumber(valueData);
                            if (big == null) break;
                            this.data.pgOutputStream.write(big.toString().getBytes());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the psql command", (Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PGBulkLoaderMeta)smi;
        this.data = (PGBulkLoaderData)sdi;
        String enclosure = this.environmentSubstitute(this.meta.getEnclosure());
        String separator = this.environmentSubstitute(this.meta.getDelimiter());
        if (super.init(smi, sdi)) {
            this.data.quote = enclosure != null ? enclosure.getBytes() : new byte[0];
            this.data.separator = separator != null ? separator.getBytes() : new byte[0];
            this.data.newline = Const.CR.getBytes();
            this.data.dateFormatChoices = new int[this.meta.getFieldStream().length];
            for (int i = 0; i < this.data.dateFormatChoices.length; ++i) {
                this.data.dateFormatChoices[i] = Const.isEmpty((String)this.meta.getDateMask()[i]) ? 0 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATE") ? 1 : (this.meta.getDateMask()[i].equalsIgnoreCase("DATETIME") ? 2 : 0));
            }
            return true;
        }
        return false;
    }
}

