/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableoutput.TableOutput;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TableOutputMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = TableOutputMeta.class;
    private DatabaseMeta databaseMeta;
    private String schemaName;
    private String tableName;
    private String commitSize = "1000";
    private boolean truncateTable;
    private boolean ignoreErrors;
    private boolean useBatchUpdate = true;
    private boolean partitioningEnabled;
    private String partitioningField;
    private boolean partitioningDaily;
    private boolean partitioningMonthly;
    private boolean tableNameInField;
    private String tableNameField;
    private boolean tableNameInTable;
    private boolean returningGeneratedKeys;
    private String generatedKeyField;
    private boolean specifyFields;
    private String[] fieldStream = new String[0];
    private String[] fieldDatabase = new String[0];

    public String getGeneratedKeyField() {
        return this.generatedKeyField;
    }

    public void setGeneratedKeyField(String generatedKeyField) {
        this.generatedKeyField = generatedKeyField;
    }

    public boolean isReturningGeneratedKeys() {
        return this.returningGeneratedKeys;
    }

    public void setReturningGeneratedKeys(boolean returningGeneratedKeys) {
        this.returningGeneratedKeys = returningGeneratedKeys;
    }

    public boolean isTableNameInTable() {
        return this.tableNameInTable;
    }

    public void setTableNameInTable(boolean tableNameInTable) {
        this.tableNameInTable = tableNameInTable;
    }

    public String getTableNameField() {
        return this.tableNameField;
    }

    public void setTableNameField(String tableNameField) {
        this.tableNameField = tableNameField;
    }

    public boolean isTableNameInField() {
        return this.tableNameInField;
    }

    public void setTableNameInField(boolean tableNameInField) {
        this.tableNameInField = tableNameInField;
    }

    public boolean isPartitioningDaily() {
        return this.partitioningDaily;
    }

    public void setPartitioningDaily(boolean partitioningDaily) {
        this.partitioningDaily = partitioningDaily;
    }

    public boolean isPartitioningMonthly() {
        return this.partitioningMonthly;
    }

    public void setPartitioningMonthly(boolean partitioningMontly) {
        this.partitioningMonthly = partitioningMontly;
    }

    public boolean isPartitioningEnabled() {
        return this.partitioningEnabled;
    }

    public void setPartitioningEnabled(boolean partitioningEnabled) {
        this.partitioningEnabled = partitioningEnabled;
    }

    public String getPartitioningField() {
        return this.partitioningField;
    }

    public void setPartitioningField(String partitioningField) {
        this.partitioningField = partitioningField;
    }

    public void allocate(int nrRows) {
        this.fieldStream = new String[nrRows];
        this.fieldDatabase = new String[nrRows];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        int i;
        TableOutputMeta retval = (TableOutputMeta)super.clone();
        int nrStream = this.fieldStream.length;
        int nrDatabase = this.fieldDatabase.length;
        retval.fieldStream = new String[nrStream];
        retval.fieldDatabase = new String[nrDatabase];
        for (i = 0; i < nrStream; ++i) {
            retval.fieldStream[i] = this.fieldStream[i];
        }
        for (i = 0; i < nrDatabase; ++i) {
            retval.fieldDatabase[i] = this.fieldDatabase[i];
        }
        return retval;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSizeInt) {
        this.commitSize = Integer.toString(commitSizeInt);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Deprecated
    public String getTablename() {
        return this.getTableName();
    }

    @Deprecated
    public void setTablename(String tablename) {
        this.setTableName(tablename);
    }

    public boolean truncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public void setSpecifyFields(boolean specifyFields) {
        this.specifyFields = specifyFields;
    }

    public boolean specifyFields() {
        return this.specifyFields;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.commitSize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.truncateTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"truncate"));
            this.ignoreErrors = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"ignore_errors"));
            this.useBatchUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_batch"));
            this.specifyFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"specify_fields"));
            this.partitioningEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"partitioning_enabled"));
            this.partitioningField = XMLHandler.getTagValue((Node)stepnode, (String)"partitioning_field");
            this.partitioningDaily = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"partitioning_daily"));
            this.partitioningMonthly = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"partitioning_monthly"));
            this.tableNameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"tablename_in_field"));
            this.tableNameField = XMLHandler.getTagValue((Node)stepnode, (String)"tablename_field");
            this.tableNameInTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"tablename_in_table"));
            this.returningGeneratedKeys = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"return_keys"));
            this.generatedKeyField = XMLHandler.getTagValue((Node)stepnode, (String)"return_field");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrRows);
            for (int i = 0; i < nrRows; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDatabase[i] = XMLHandler.getTagValue((Node)knode, (String)"column_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.tableName = "";
        this.commitSize = "1000";
        this.partitioningEnabled = false;
        this.partitioningMonthly = true;
        this.partitioningField = "";
        this.tableNameInTable = true;
        this.tableNameField = "";
        this.specifyFields = false;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    " + XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    " + XMLHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    " + XMLHandler.addTagValue((String)"truncate", (boolean)this.truncateTable));
        retval.append("    " + XMLHandler.addTagValue((String)"ignore_errors", (boolean)this.ignoreErrors));
        retval.append("    " + XMLHandler.addTagValue((String)"use_batch", (boolean)this.useBatchUpdate));
        retval.append("    " + XMLHandler.addTagValue((String)"specify_fields", (boolean)this.specifyFields));
        retval.append("    " + XMLHandler.addTagValue((String)"partitioning_enabled", (boolean)this.partitioningEnabled));
        retval.append("    " + XMLHandler.addTagValue((String)"partitioning_field", (String)this.partitioningField));
        retval.append("    " + XMLHandler.addTagValue((String)"partitioning_daily", (boolean)this.partitioningDaily));
        retval.append("    " + XMLHandler.addTagValue((String)"partitioning_monthly", (boolean)this.partitioningMonthly));
        retval.append("    " + XMLHandler.addTagValue((String)"tablename_in_field", (boolean)this.tableNameInField));
        retval.append("    " + XMLHandler.addTagValue((String)"tablename_field", (String)this.tableNameField));
        retval.append("    " + XMLHandler.addTagValue((String)"tablename_in_table", (boolean)this.tableNameInTable));
        retval.append("    " + XMLHandler.addTagValue((String)"return_keys", (boolean)this.returningGeneratedKeys));
        retval.append("    " + XMLHandler.addTagValue((String)"return_field", (String)this.generatedKeyField));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDatabase.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"column_name", (String)this.fieldDatabase[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldStream[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.commitSize = rep.getStepAttributeString(id_step, "commit");
            this.truncateTable = rep.getStepAttributeBoolean(id_step, "truncate");
            this.ignoreErrors = rep.getStepAttributeBoolean(id_step, "ignore_errors");
            this.useBatchUpdate = rep.getStepAttributeBoolean(id_step, "use_batch");
            this.specifyFields = rep.getStepAttributeBoolean(id_step, "specify_fields");
            this.partitioningEnabled = rep.getStepAttributeBoolean(id_step, "partitioning_enabled");
            this.partitioningField = rep.getStepAttributeString(id_step, "partitioning_field");
            this.partitioningDaily = rep.getStepAttributeBoolean(id_step, "partitioning_daily");
            this.partitioningMonthly = rep.getStepAttributeBoolean(id_step, "partitioning_monthly");
            this.tableNameInField = rep.getStepAttributeBoolean(id_step, "tablename_in_field");
            this.tableNameField = rep.getStepAttributeString(id_step, "tablename_field");
            this.tableNameInTable = rep.getStepAttributeBoolean(id_step, "tablename_in_table");
            this.returningGeneratedKeys = rep.getStepAttributeBoolean(id_step, "return_keys");
            this.generatedKeyField = rep.getStepAttributeString(id_step, "return_field");
            int nrCols = rep.countNrStepAttributes(id_step, "column_name");
            int nrStreams = rep.countNrStepAttributes(id_step, "stream_name");
            int nrRows = nrCols < nrStreams ? nrStreams : nrCols;
            this.allocate(nrRows);
            for (int idx = 0; idx < nrRows; ++idx) {
                this.fieldDatabase[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "column_name"), (String)"");
                this.fieldStream[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_name"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "truncate", this.truncateTable);
            rep.saveStepAttribute(id_transformation, id_step, "ignore_errors", this.ignoreErrors);
            rep.saveStepAttribute(id_transformation, id_step, "use_batch", this.useBatchUpdate);
            rep.saveStepAttribute(id_transformation, id_step, "specify_fields", this.specifyFields);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_enabled", this.partitioningEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_field", this.partitioningField);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_daily", this.partitioningDaily);
            rep.saveStepAttribute(id_transformation, id_step, "partitioning_monthly", this.partitioningMonthly);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_in_field", this.tableNameInField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_field", this.tableNameField);
            rep.saveStepAttribute(id_transformation, id_step, "tablename_in_table", this.tableNameInTable);
            rep.saveStepAttribute(id_transformation, id_step, "return_keys", this.returningGeneratedKeys);
            rep.saveStepAttribute(id_transformation, id_step, "return_field", this.generatedKeyField);
            int nrRows = this.fieldDatabase.length < this.fieldStream.length ? this.fieldStream.length : this.fieldDatabase.length;
            for (int idx = 0; idx < nrRows; ++idx) {
                String columnName = idx < this.fieldDatabase.length ? this.fieldDatabase[idx] : "";
                String streamName = idx < this.fieldStream.length ? this.fieldStream[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "column_name", columnName);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_name", streamName);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.returningGeneratedKeys && this.generatedKeyField != null && this.generatedKeyField.length() > 0) {
            ValueMeta key = new ValueMeta(space.environmentSubstitute(this.generatedKeyField), 5);
            key.setOrigin(origin);
            row.addValueMeta((ValueMetaInterface)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ConnectionOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!Const.isEmpty((String)this.tableName)) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(db.environmentSubstitute(this.schemaName), db.environmentSubstitute(this.tableName));
                    if (db.checkTableExists(schemaTable)) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        RowMetaInterface r = db.getTableFields(schemaTable);
                        if (r != null) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            String error_message = "";
                            boolean error_found = false;
                            if (prev != null && prev.size() > 0) {
                                int idx;
                                int i;
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                if (!this.specifyFields()) {
                                    for (i = 0; i < prev.size(); ++i) {
                                        ValueMetaInterface pv = prev.getValueMeta(i);
                                        idx = r.indexOfValue(pv.getName());
                                        if (idx >= 0) continue;
                                        error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{error_message});
                                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                } else {
                                    for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                        int idx2 = r.indexOfValue(this.getFieldDatabase()[i]);
                                        if (idx2 >= 0) continue;
                                        error_message = error_message + "\t\t" + this.getFieldDatabase()[i] + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotInTable", (String[])new String[]{error_message});
                                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    } else {
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                }
                                error_message = "";
                                if (!this.specifyFields()) {
                                    for (i = 0; i < this.getFieldDatabase().length; ++i) {
                                        ValueMetaInterface rv = r.getValueMeta(i);
                                        idx = prev.indexOfValue(rv.getName());
                                        if (idx >= 0) continue;
                                        error_message = error_message + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                        error_found = true;
                                    }
                                    if (error_found) {
                                        error_message = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                                        cr = new CheckResult(3, error_message, (CheckResultSourceInterface)stepMeta);
                                        remarks.add((CheckResultInterface)cr);
                                    }
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                }
                                for (i = 0; i < this.getFieldStream().length; ++i) {
                                    int idx3 = prev.indexOfValue(this.getFieldStream()[i]);
                                    if (idx3 >= 0) continue;
                                    error_message = error_message + "\t\t" + this.getFieldStream()[i] + Const.CR;
                                    error_found = true;
                                }
                                if (error_found) {
                                    error_message = BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.FieldsSpecifiedNotFound", (String[])new String[]{error_message});
                                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr);
                                }
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            }
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoTableName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.NoConnection", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TableOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TableOutputData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) {
        if (this.truncateTable) {
            DatabaseImpact ii = new DatabaseImpact(4, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, "", "", "", "", "Truncate of table");
            impact.add(ii);
        }
        if (prev != null) {
            for (int i = 0; i < prev.size(); ++i) {
                ValueMetaInterface v = prev.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(2, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        return this.getSQLStatements(transMeta, stepMeta, prev, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String tk, boolean use_autoinc, String pk) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Const.isEmpty((String)this.tableName)) {
                    Database db = new Database(loggingObject, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                        String cr_table = db.getDDL(schemaTable, prev, tk, use_autoinc, pk);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (KettleDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"TableOutputMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getDatabaseInterface().supportsErrorHandling();
        }
        return true;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    @Override
    public TableOutputMetaInjection getStepMetaInjectionInterface() {
        return new TableOutputMetaInjection(this);
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return this.getStepMetaInjectionInterface().extractStepMetadataEntries();
    }
}

