/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinput;

import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinput.XMLInputData;
import org.pentaho.di.trans.steps.xmlinput.XMLInputField;
import org.pentaho.di.trans.steps.xmlinput.XMLInputFieldPosition;
import org.pentaho.di.trans.steps.xmlinput.XMLInputMeta;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XMLInputMeta.class;
    private XMLInputMeta meta;
    private XMLInputData data;

    public XMLInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
        }
        if ((outputRowData = this.getRowFromXML()) == null) {
            this.setOutputDone();
            return false;
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"XMLInput.Log.ReadRow", (String[])new String[]{outputRowData.toString()}));
        }
        this.incrementLinesInput();
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.meta.getRowLimit() > 0L && this.data.rownr >= this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getRowFromXML() throws KettleValueException {
        RowMetaInterface irow;
        while (this.data.itemPosition >= this.data.itemCount || this.data.file == null) {
            this.data.file = null;
            if (this.openNextFile()) continue;
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        Node itemNode = this.meta.getInputPosition().length > 1 ? XMLHandler.getSubNodeByNr((Node)this.data.section, (String)this.data.itemElement, (int)this.data.itemPosition) : this.data.section;
        ++this.data.itemPosition;
        for (int i = 0; i < this.meta.getInputFields().length; ++i) {
            Node node = itemNode;
            XMLInputField xmlInputField = this.meta.getInputFields()[i];
            String value = null;
            block12: for (int p = 0; value == null && node != null && p < xmlInputField.getFieldPosition().length; ++p) {
                XMLInputFieldPosition pos = xmlInputField.getFieldPosition()[p];
                switch (pos.getType()) {
                    case 1: {
                        Node subNode;
                        if (pos.getElementNr() <= 1) {
                            subNode = XMLHandler.getSubNode((Node)node, (String)pos.getName());
                            if (subNode != null) {
                                if (p == xmlInputField.getFieldPosition().length - 1) {
                                    value = XMLHandler.getNodeValue((Node)subNode);
                                }
                            } else if (this.log.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"XMLInput.Log.UnableToFindPosition", (String[])new String[]{pos.toString(), node.toString()}));
                            }
                            node = subNode;
                            continue block12;
                        }
                        subNode = XMLHandler.getSubNodeByNr((Node)node, (String)pos.getName(), (int)(pos.getElementNr() - 1), (boolean)false);
                        if (subNode != null) {
                            if (p == xmlInputField.getFieldPosition().length - 1) {
                                value = XMLHandler.getNodeValue((Node)subNode);
                            }
                        } else if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"XMLInput.Log.UnableToFindPosition", (String[])new String[]{pos.toString(), node.toString()}));
                        }
                        node = subNode;
                        continue block12;
                    }
                    case 2: {
                        value = XMLHandler.getTagAttribute((Node)node, (String)pos.getName());
                        continue block12;
                    }
                    case 3: {
                        value = XMLHandler.getNodeValue((Node)node);
                        continue block12;
                    }
                }
            }
            switch (xmlInputField.getTrimType()) {
                case 1: {
                    value = Const.ltrim(value);
                    break;
                }
                case 2: {
                    value = Const.rtrim(value);
                    break;
                }
                case 3: {
                    value = Const.trim(value);
                    break;
                }
            }
            ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
            ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
            outputRowData[i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
            if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)value)) continue;
            outputRowData[i] = this.data.previousRow[i];
        }
        int outputIndex = this.meta.getInputFields().length;
        if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
            outputRowData[outputIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
        }
        if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
            outputRowData[outputIndex++] = new Long(this.data.rownr);
        }
        this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
        ++this.data.rownr;
        NodeList nodeList = itemNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            itemNode.removeChild(nodeList.item(i));
        }
        return outputRowData;
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.size()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"XMLInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            this.data.last_file = this.data.filenr == this.data.files.size() - 1;
            this.data.file = this.data.files.get(this.data.filenr);
            this.logBasic(BaseMessages.getString(PKG, (String)"XMLInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            ++this.data.filenr;
            String baseURI = this.environmentSubstitute(this.meta.getFileBaseURI());
            if (Const.isEmpty((String)baseURI)) {
                baseURI = this.data.file.getParent().getName().getURI();
            }
            this.data.document = XMLHandler.loadXMLFile((FileObject)this.data.file, (String)baseURI, (boolean)this.meta.isIgnoreEntities(), (boolean)this.meta.isNamespaceAware());
            ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment("File was read by an XML input step");
            this.addResultFile(resultFile);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"XMLInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            }
            this.data.section = this.data.document;
            for (int i = 0; i < this.meta.getInputPosition().length - 1; ++i) {
                this.data.section = XMLHandler.getSubNode((Node)this.data.section, (String)this.meta.getInputPosition()[i]);
            }
            this.data.itemElement = this.meta.getInputPosition()[this.meta.getInputPosition().length - 1];
            this.data.itemCount = XMLHandler.countNodes((Node)this.data.section, (String)this.data.itemElement);
            this.data.itemPosition = this.meta.getNrRowsToSkip();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"XMLInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputMeta)smi;
        this.data = (XMLInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getFiles(this).getFiles();
            if (this.data.files == null || this.data.files.size() == 0) {
                this.logError(BaseMessages.getString(PKG, (String)"XMLInput.Log.NoFiles", (String[])new String[0]));
                return false;
            }
            this.data.rownr = 1L;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputMeta)smi;
        this.data = (XMLInputData)sdi;
        super.dispose(smi, sdi);
    }
}

