/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.CartePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;

public class CarteServlet
extends HttpServlet {
    private static final long serialVersionUID = 2434694833497859776L;
    public static final String STRING_CARTE_SERVLET = "Carte Servlet";
    private Map<String, CartePluginInterface> cartePluginRegistry;
    private final LogChannelInterface log = new LogChannel((Object)"Carte Servlet");

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CartePluginInterface plugin;
        String servletPath = req.getPathInfo();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ((plugin = this.cartePluginRegistry.get(servletPath)) != null) {
            try {
                plugin.doGet(req, resp);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            if (this.log.isDebug()) {
                this.log.logDebug("Unable to find CartePlugin for key: /kettle" + req.getPathInfo());
            }
            resp.setStatus(404);
        }
    }

    private String getServletKey(CartePluginInterface servlet) {
        String key = servlet.getContextPath();
        if (key.startsWith("/kettle")) {
            key = key.substring("/kettle".length());
        }
        return key;
    }

    public void init(ServletConfig config) throws ServletException {
        TransformationMap transformationMap = CarteSingleton.getInstance().getTransformationMap();
        JobMap jobMap = CarteSingleton.getInstance().getJobMap();
        List<SlaveServerDetection> detections = Collections.synchronizedList(new ArrayList());
        SocketRepository socketRepository = CarteSingleton.getInstance().getSocketRepository();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(CartePluginType.class);
        HashMap<String, CartePluginInterface> pluginMap = new HashMap<String, CartePluginInterface>();
        for (PluginInterface plugin : plugins) {
            try {
                CartePluginInterface servlet = (CartePluginInterface)pluginRegistry.loadClass(plugin);
                pluginMap.put(this.getServletKey(servlet), servlet);
            }
            catch (KettlePluginException e) {
                this.log.logError("Unable to instantiate plugin for use with CarteServlet " + plugin.getName());
            }
        }
        Enumeration initParameterNames = config.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String paramName = (String)initParameterNames.nextElement();
            String className = config.getInitParameter(paramName);
            try {
                Class<?> clazz = Class.forName(className);
                CartePluginInterface servlet = (CartePluginInterface)clazz.newInstance();
                pluginMap.put(this.getServletKey(servlet), servlet);
            }
            catch (ClassNotFoundException e) {
                this.log.logError("Unable to find configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.logError("Unable to instantiate configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.logError("Unable to access configured " + paramName + " of " + className, (Throwable)e);
            }
            catch (ClassCastException e) {
                this.log.logError("Unable to cast configured " + paramName + " of " + className + " to " + CartePluginInterface.class, (Throwable)e);
            }
        }
        for (CartePluginInterface servlet : pluginMap.values()) {
            servlet.setup(transformationMap, jobMap, socketRepository, detections);
            servlet.setJettyMode(false);
        }
        this.cartePluginRegistry = Collections.unmodifiableMap(pluginMap);
    }
}

