/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.slab;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.slab.Slab;
import org.apache.hadoop.hbase.io.hfile.slab.SlabItemActionWatcher;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@Deprecated
public class SingleSizeCache
implements BlockCache,
HeapSize {
    private final Slab backingStore;
    private final ConcurrentMap<BlockCacheKey, CacheablePair> backingMap;
    private final int numBlocks;
    private final int blockSize;
    private final CacheStats stats;
    private final SlabItemActionWatcher actionWatcher;
    private final AtomicLong size;
    private final AtomicLong timeSinceLastAccess;
    public static final long CACHE_FIXED_OVERHEAD = ClassSize.align((int)(8 + 5 * ClassSize.REFERENCE + ClassSize.OBJECT));
    static final Log LOG = LogFactory.getLog(SingleSizeCache.class);

    public SingleSizeCache(int blockSize, int numBlocks, SlabItemActionWatcher master) {
        this.blockSize = blockSize;
        this.numBlocks = numBlocks;
        this.backingStore = new Slab(blockSize, numBlocks);
        this.stats = new CacheStats();
        this.actionWatcher = master;
        this.size = new AtomicLong(CACHE_FIXED_OVERHEAD + this.backingStore.heapSize());
        this.timeSinceLastAccess = new AtomicLong();
        RemovalListener<BlockCacheKey, CacheablePair> listener = new RemovalListener<BlockCacheKey, CacheablePair>(){

            public void onRemoval(RemovalNotification<BlockCacheKey, CacheablePair> notification) {
                if (!notification.wasEvicted()) {
                    return;
                }
                CacheablePair value = (CacheablePair)notification.getValue();
                SingleSizeCache.this.timeSinceLastAccess.set(System.nanoTime() - value.recentlyAccessed.get());
                SingleSizeCache.this.stats.evict();
                SingleSizeCache.this.doEviction((BlockCacheKey)notification.getKey(), value);
            }
        };
        this.backingMap = CacheBuilder.newBuilder().maximumSize((long)(numBlocks - 1)).removalListener((RemovalListener)listener).build().asMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheBlock(BlockCacheKey blockName, Cacheable toBeCached) {
        ByteBuffer storedBlock;
        try {
            storedBlock = this.backingStore.alloc(toBeCached.getSerializedLength());
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"SlabAllocator was interrupted while waiting for block to become available");
            LOG.warn((Object)e);
            return;
        }
        CacheablePair newEntry = new CacheablePair(toBeCached.getDeserializer(), storedBlock);
        toBeCached.serialize(storedBlock);
        SingleSizeCache singleSizeCache = this;
        synchronized (singleSizeCache) {
            CacheablePair alreadyCached = this.backingMap.putIfAbsent(blockName, newEntry);
            if (alreadyCached != null) {
                this.backingStore.free(storedBlock);
                throw new RuntimeException("already cached " + blockName);
            }
            if (this.actionWatcher != null) {
                this.actionWatcher.onInsertion(blockName, this);
            }
        }
        newEntry.recentlyAccessed.set(System.nanoTime());
        this.size.addAndGet(newEntry.heapSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        CacheablePair contentBlock = (CacheablePair)this.backingMap.get(key);
        if (contentBlock == null) {
            if (!repeat && updateCacheMetrics) {
                this.stats.miss(caching);
            }
            return null;
        }
        if (updateCacheMetrics) {
            this.stats.hit(caching);
        }
        try {
            contentBlock.recentlyAccessed.set(System.nanoTime());
            CacheablePair cacheablePair = contentBlock;
            synchronized (cacheablePair) {
                if (contentBlock.serializedData == null) {
                    LOG.warn((Object)("Concurrent eviction of " + key));
                    return null;
                }
                return contentBlock.deserializer.deserialize(contentBlock.serializedData.asReadOnlyBuffer());
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Deserializer threw an exception. This may indicate a bug.", t);
            return null;
        }
    }

    @Override
    public boolean evictBlock(BlockCacheKey key) {
        this.stats.evict();
        CacheablePair evictedBlock = (CacheablePair)this.backingMap.remove(key);
        if (evictedBlock != null) {
            this.doEviction(key, evictedBlock);
        }
        return evictedBlock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEviction(BlockCacheKey key, CacheablePair evictedBlock) {
        long evictedHeap = 0L;
        CacheablePair cacheablePair = evictedBlock;
        synchronized (cacheablePair) {
            if (evictedBlock.serializedData == null) {
                return;
            }
            evictedHeap = evictedBlock.heapSize();
            ByteBuffer bb = evictedBlock.serializedData;
            evictedBlock.serializedData = null;
            this.backingStore.free(bb);
            if (this.actionWatcher != null) {
                this.actionWatcher.onEviction(key, this);
            }
        }
        this.stats.evicted();
        this.size.addAndGet(-1L * evictedHeap);
    }

    public void logStats() {
        long milliseconds = this.timeSinceLastAccess.get() / 1000000L;
        LOG.info((Object)("For Slab of size " + this.blockSize + ": " + this.getOccupiedSize() / (long)this.blockSize + " occupied, out of a capacity of " + this.numBlocks + " blocks. HeapSize is " + StringUtils.humanReadableInt((long)this.heapSize()) + " bytes." + ", " + "churnTime=" + StringUtils.formatTime((long)milliseconds)));
        LOG.info((Object)("Slab Stats: accesses=" + this.stats.getRequestCount() + ", " + "hits=" + this.stats.getHitCount() + ", " + "hitRatio=" + (this.stats.getHitCount() == 0L ? "0" : StringUtils.formatPercent((double)this.stats.getHitRatio(), (int)2) + "%, ") + "cachingAccesses=" + this.stats.getRequestCachingCount() + ", " + "cachingHits=" + this.stats.getHitCachingCount() + ", " + "cachingHitsRatio=" + (this.stats.getHitCachingCount() == 0L ? "0" : StringUtils.formatPercent((double)this.stats.getHitCachingRatio(), (int)2) + "%, ") + "evictions=" + this.stats.getEvictionCount() + ", " + "evicted=" + this.stats.getEvictedCount() + ", " + "evictedPerRun=" + this.stats.evictedPerEviction()));
    }

    @Override
    public void shutdown() {
        this.backingStore.shutdown();
    }

    public long heapSize() {
        return this.size.get() + this.backingStore.heapSize();
    }

    @Override
    public long size() {
        return (long)this.blockSize * (long)this.numBlocks;
    }

    @Override
    public long getFreeSize() {
        return (long)this.backingStore.getBlocksRemaining() * (long)this.blockSize;
    }

    public long getOccupiedSize() {
        return (long)(this.numBlocks - this.backingStore.getBlocksRemaining()) * (long)this.blockSize;
    }

    public long getEvictedCount() {
        return this.stats.getEvictedCount();
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public long getBlockCount() {
        return this.numBlocks - this.backingStore.getBlocksRemaining();
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.cacheBlock(cacheKey, buf);
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int evictedCount = 0;
        for (BlockCacheKey e : this.backingMap.keySet()) {
            if (!e.getHfileName().equals(hfileName)) continue;
            this.evictBlock(e);
        }
        return evictedCount;
    }

    @Override
    public long getCurrentSize() {
        return 0L;
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        return null;
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return null;
    }

    private static class CacheablePair
    implements HeapSize {
        final CacheableDeserializer<Cacheable> deserializer;
        ByteBuffer serializedData;
        AtomicLong recentlyAccessed = new AtomicLong();

        private CacheablePair(CacheableDeserializer<Cacheable> deserializer, ByteBuffer serializedData) {
            this.deserializer = deserializer;
            this.serializedData = serializedData;
        }

        public long heapSize() {
            return ClassSize.align((int)(ClassSize.OBJECT + ClassSize.REFERENCE * 3 + ClassSize.ATOMIC_LONG));
        }
    }
}

