/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MobZookeeper {
    private static final Log LOG = LogFactory.getLog(MobZookeeper.class);
    private ZooKeeperWatcher zkw;
    private String mobZnode;
    private static final String LOCK_EPHEMERAL = "-lock";
    private static final String SWEEPER_EPHEMERAL = "-sweeper";
    private static final String MAJOR_COMPACTION_EPHEMERAL = "-majorCompaction";

    private MobZookeeper(Configuration conf, String identifier) throws IOException, KeeperException {
        this.zkw = new ZooKeeperWatcher(conf, identifier, (Abortable)new DummyMobAbortable());
        this.mobZnode = ZKUtil.joinZNode((String)this.zkw.baseZNode, (String)"MOB");
        if (ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)this.mobZnode) == -1) {
            ZKUtil.createWithParents((ZooKeeperWatcher)this.zkw, (String)this.mobZnode);
        }
    }

    public static MobZookeeper newInstance(Configuration conf, String identifier) throws IOException, KeeperException {
        return new MobZookeeper(conf, identifier);
    }

    public boolean lockColumnFamily(String tableName, String familyName) {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        boolean locked = false;
        try {
            locked = ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + LOCK_EPHEMERAL)), null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(locked ? "Locked the column family " + znodeName : "Can not lock the column family " + znodeName));
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Fail to lock the column family " + znodeName), (Throwable)e);
        }
        return locked;
    }

    public void unlockColumnFamily(String tableName, String familyName) {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unlocking the column family " + znodeName));
        }
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + LOCK_EPHEMERAL)));
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Fail to unlock the column family " + znodeName), (Throwable)e);
        }
    }

    public boolean addSweeperZNode(String tableName, String familyName, byte[] data) {
        boolean add = false;
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        try {
            add = ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + SWEEPER_EPHEMERAL)), (byte[])data);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(add ? "Added a znode for sweeper " + znodeName : "Cannot add a znode for sweeper " + znodeName));
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("Fail to add a znode for sweeper " + znodeName), (Throwable)e);
        }
        return add;
    }

    public String getSweeperZNodePath(String tableName, String familyName) {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        return ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + SWEEPER_EPHEMERAL));
    }

    public void deleteSweeperZNode(String tableName, String familyName) {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + SWEEPER_EPHEMERAL)));
        }
        catch (KeeperException e) {
            LOG.error((Object)("Fail to delete a znode for sweeper " + znodeName), (Throwable)e);
        }
    }

    public boolean isSweeperZNodeExist(String tableName, String familyName) throws KeeperException {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        return ZKUtil.checkExists((ZooKeeperWatcher)this.zkw, (String)ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + SWEEPER_EPHEMERAL))) >= 0;
    }

    public boolean hasMajorCompactionChildren(String tableName, String familyName) throws KeeperException {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        String mcPath = ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + MAJOR_COMPACTION_EPHEMERAL));
        List children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkw, (String)mcPath);
        return children != null && !children.isEmpty();
    }

    public boolean addMajorCompactionZNode(String tableName, String familyName, String compactionName) throws KeeperException {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        String mcPath = ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + MAJOR_COMPACTION_EPHEMERAL));
        ZKUtil.createNodeIfNotExistsAndWatch((ZooKeeperWatcher)this.zkw, (String)mcPath, null);
        String eachMcPath = ZKUtil.joinZNode((String)mcPath, (String)compactionName);
        return ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.zkw, (String)eachMcPath, null);
    }

    public void deleteMajorCompactionZNode(String tableName, String familyName, String compactionName) throws KeeperException {
        String znodeName = MobUtils.getColumnFamilyZNodeName(tableName, familyName);
        String mcPath = ZKUtil.joinZNode((String)this.mobZnode, (String)(znodeName + MAJOR_COMPACTION_EPHEMERAL));
        String eachMcPath = ZKUtil.joinZNode((String)mcPath, (String)compactionName);
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zkw, (String)eachMcPath);
    }

    public void close() {
        this.zkw.close();
    }

    public static class DummyMobAbortable
    implements Abortable {
        private boolean abort = false;

        public void abort(String why, Throwable e) {
            this.abort = true;
        }

        public boolean isAborted() {
            return this.abort;
        }
    }
}

