/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
public class Sweeper
extends Configured
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sweepFamily(String tableName, String familyName) throws IOException, InterruptedException, ClassNotFoundException, KeeperException, ServiceException {
        Configuration conf = this.getConf();
        HBaseAdmin.checkHBaseAvailable((Configuration)conf);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            TableName tn = TableName.valueOf((String)tableName);
            HTableDescriptor htd = admin.getTableDescriptor(tn);
            HColumnDescriptor family = htd.getFamily(Bytes.toBytes((String)familyName));
            if (family == null || !family.isMobEnabled()) {
                throw new IOException("Column family " + familyName + " is not a MOB column family");
            }
            SweepJob job = new SweepJob(conf, fs);
            job.sweep(tn, family);
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                System.out.println("Fail to close the HBaseAdmin: " + e.getMessage());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ToolRunner.run((Configuration)conf, (Tool)new Sweeper(), (String[])args);
    }

    private void printUsage() {
        System.err.println("Usage:\n--------------------------\n" + Sweeper.class.getName() + " tableName familyName");
        System.err.println(" tableName        The table name");
        System.err.println(" familyName       The column family name");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.printUsage();
            return 1;
        }
        String table = args[0];
        String family = args[1];
        this.sweepFamily(table, family);
        return 0;
    }
}

