/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkewedPartitioner
extends Partitioner<PigNullableWritable, Writable>
implements Configurable {
    Map<Tuple, Pair<Integer, Integer>> reducerMap = new HashMap<Tuple, Pair<Integer, Integer>>();
    static Map<Tuple, Integer> currentIndexMap = new HashMap<Tuple, Integer>();
    Integer totalReducers;
    Configuration conf;

    public int getPartition(PigNullableWritable wrappedKey, Writable value, int numPartitions) {
        if (wrappedKey instanceof NullablePartitionWritable && ((NullablePartitionWritable)wrappedKey).getPartition() != -1) {
            return ((NullablePartitionWritable)wrappedKey).getPartition();
        }
        Integer curIndex = -1;
        Tuple keyTuple = TupleFactory.getInstance().newTuple(1);
        PigNullableWritable key = ((NullablePartitionWritable)wrappedKey).getKey();
        try {
            keyTuple.set(0, key.getValueAsPigType());
        }
        catch (ExecException e) {
            return -1;
        }
        if (key instanceof NullableTuple && key.getValueAsPigType() != null) {
            keyTuple = (Tuple)key.getValueAsPigType();
        }
        this.totalReducers = this.totalReducers > 0 ? this.totalReducers : numPartitions;
        Pair<Integer, Integer> indexes = this.reducerMap.get(keyTuple);
        if (indexes == null) {
            return Math.abs(keyTuple.hashCode() % this.totalReducers);
        }
        if (currentIndexMap.containsKey(keyTuple)) {
            curIndex = currentIndexMap.get(keyTuple);
        }
        if (curIndex >= (Integer)indexes.first + (Integer)indexes.second || curIndex == -1) {
            curIndex = (Integer)indexes.first;
        } else {
            Integer n = curIndex;
            Integer n2 = curIndex = Integer.valueOf(curIndex + 1);
        }
        currentIndexMap.put(keyTuple, curIndex);
        return curIndex % this.totalReducers;
    }

    public void setConf(Configuration job) {
        this.conf = job;
        PigMapReduce.sJobConfInternal.set(this.conf);
        PigMapReduce.sJobConf = this.conf;
        String keyDistFile = job.get("pig.keyDistFile", "");
        if (keyDistFile.length() == 0) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " used but no key distribution found");
        }
        try {
            Integer[] redCnt = new Integer[1];
            this.reducerMap = MapRedUtil.loadPartitionFileFromLocalCache(keyDistFile, redCnt, (byte)110);
            this.totalReducers = redCnt[0] == null ? -1 : redCnt[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }
}

