/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import java.util.Random;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFCross
extends EvalFunc<DataBag> {
    int numInputs;
    int myNumber;
    int numGroupsPerInput;
    BagFactory mBagFactory = BagFactory.getInstance();
    TupleFactory mTupleFactory = TupleFactory.getInstance();
    public static final int DEFAULT_PARALLELISM = 96;

    @Override
    public DataBag exec(Tuple input) throws IOException {
        int i;
        this.numInputs = (Integer)input.get(0);
        this.myNumber = (Integer)input.get(1);
        DataBag output = this.mBagFactory.newDefaultBag();
        this.numGroupsPerInput = (int)Math.ceil(Math.pow(96.0, 1.0 / (double)this.numInputs));
        int numGroupsGoingTo = (int)Math.pow(this.numGroupsPerInput, this.numInputs - 1);
        int[] digits = new int[this.numInputs];
        for (i = 0; i < this.numInputs; ++i) {
            if (i == this.myNumber) {
                Random r = new Random(System.currentTimeMillis());
                digits[i] = r.nextInt(this.numGroupsPerInput);
                continue;
            }
            digits[i] = 0;
        }
        for (i = 0; i < numGroupsGoingTo; ++i) {
            output.add(this.toTuple(digits));
            this.next(digits);
        }
        return output;
    }

    private Tuple toTuple(int[] digits) throws IOException, ExecException {
        Tuple t = this.mTupleFactory.newTuple(this.numInputs);
        for (int i = 0; i < this.numInputs; ++i) {
            t.set(i, digits[i]);
        }
        return t;
    }

    private void next(int[] digits) {
        for (int i = 0; i < this.numInputs; ++i) {
            if (i == this.myNumber) continue;
            if (digits[i] == this.numGroupsPerInput - 1) {
                digits[i] = 0;
                continue;
            }
            int n = i;
            digits[n] = digits[n] + 1;
            break;
        }
    }
}

