/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.PColFilterExtractor;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.optimizer.OptimizerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionFilterOptimizer
extends LogicalTransformer {
    private String[] partitionKeys;
    private LoadMetadata loadMetadata;
    private LoadFunc loadFunc;
    private LOLoad loLoad;
    private LOFilter loFilter;
    private Set<LogicalOperator> alreadyChecked = new HashSet<LogicalOperator>();
    private Map<String, String> colNameMap = new HashMap<String, String>();
    private Map<String, String> reverseColNameMap = new HashMap<String, String>();

    protected PartitionFilterOptimizer(LogicalPlan plan) {
        super(plan);
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        List<LOLoad> sucs;
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        if (nodes.size() != 1 || !(nodes.get(0) instanceof LOLoad)) {
            return false;
        }
        if (!this.alreadyChecked.add(nodes.get(0))) {
            return false;
        }
        if (nodes.get(0) instanceof LOLoad) {
            this.loLoad = (LOLoad)nodes.get(0);
        }
        if ((sucs = ((LogicalPlan)this.mPlan).getSuccessors(this.loLoad)) == null || sucs.size() != 1 || !(sucs.get(0) instanceof LOFilter)) {
            return false;
        }
        this.loFilter = (LOFilter)((Object)sucs.get(0));
        this.loadFunc = this.loLoad.getLoadFunc();
        if (!(this.loadFunc instanceof LoadMetadata)) {
            return false;
        }
        this.loadMetadata = (LoadMetadata)((Object)this.loadFunc);
        try {
            this.partitionKeys = this.loadMetadata.getPartitionKeys(this.loLoad.getInputFile().getFileName(), new Job(this.loLoad.getConfiguration()));
            if (this.partitionKeys == null || this.partitionKeys.length == 0) {
                return false;
            }
        }
        catch (IOException e) {
            int errCode = 2209;
            throw new OptimizerException("Internal error while processing any partition filter conditions in the filter after the load", errCode, 4);
        }
        return true;
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            this.setupColNameMaps();
            PColFilterExtractor pColFilterFinder = new PColFilterExtractor(this.loFilter.getComparisonPlan(), this.getMappedKeys(this.partitionKeys));
            pColFilterFinder.visit();
            Expression partitionFilter = pColFilterFinder.getPColCondition();
            if (partitionFilter != null) {
                this.updateMappedColNames(partitionFilter);
                this.loadMetadata.setPartitionFilter(partitionFilter);
                if (pColFilterFinder.isFilterRemovable()) {
                    ((LogicalPlan)this.mPlan).removeAndReconnect(this.loFilter);
                }
            }
        }
        catch (Exception e) {
            int errCode = 2209;
            throw new OptimizerException("Internal error while processing any partition filter conditions in the filter after the load:", errCode, 4, e);
        }
    }

    private void updateMappedColNames(Expression expr) {
        if (expr instanceof Expression.BinaryExpression) {
            this.updateMappedColNames(((Expression.BinaryExpression)expr).getLhs());
            this.updateMappedColNames(((Expression.BinaryExpression)expr).getRhs());
        } else if (expr instanceof Expression.Column) {
            Expression.Column col = (Expression.Column)expr;
            col.setName(this.reverseColNameMap.get(col.getName()));
        }
    }

    private List<String> getMappedKeys(String[] partitionKeys) {
        ArrayList<String> mappedKeys = new ArrayList<String>(partitionKeys.length);
        for (int i = 0; i < partitionKeys.length; ++i) {
            mappedKeys.add(this.colNameMap.get(partitionKeys[i]));
        }
        return mappedKeys;
    }

    private void setupColNameMaps() throws FrontendException {
        Schema loadFuncSchema = this.loLoad.getDeterminedSchema();
        Schema loLoadSchema = this.loLoad.getSchema();
        for (int i = 0; i < loadFuncSchema.size(); ++i) {
            this.colNameMap.put(loadFuncSchema.getField((int)i).alias, i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias);
            this.reverseColNameMap.put(i < loLoadSchema.size() ? loLoadSchema.getField((int)i).alias : loadFuncSchema.getField((int)i).alias, loadFuncSchema.getField((int)i).alias);
        }
    }
}

