/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.CastFinder;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.UDFFinder;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushDownForeachFlatten
extends LogicalTransformer {
    private boolean mSwap = false;
    private boolean mInsertBetween = false;
    Map<Integer, Integer> mFlattenedColumnReMap = null;

    public PushDownForeachFlatten(LogicalPlan plan) {
        super(plan);
    }

    public boolean getSwap() {
        return this.mSwap;
    }

    public boolean getInsertBetween() {
        return this.mInsertBetween;
    }

    public Map<Integer, Integer> getFlattenedColumnMap() {
        return this.mFlattenedColumnReMap;
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            ArrayList<LogicalOperator> peers;
            ArrayList<LOForEach> successors;
            HashSet flattenedColumnSet;
            LOForEach foreach = (LOForEach)this.getOperator(nodes);
            Pair<Boolean, List<Integer>> flattenResult = foreach.hasFlatten();
            boolean flattened = (Boolean)flattenResult.first;
            List flattenedColumns = (List)flattenResult.second;
            HashSet hashSet = flattenedColumnSet = flattenedColumns == null ? null : new HashSet(flattenedColumns);
            if (!flattened) {
                return false;
            }
            if (flattenedColumns == null || flattenedColumns.size() == 0) {
                return false;
            }
            ProjectionMap foreachProjectionMap = foreach.getProjectionMap();
            if (foreachProjectionMap == null) {
                return false;
            }
            List<Integer> foreachAddedFields = foreachProjectionMap.getAddedFields();
            if (foreachAddedFields != null) {
                HashSet<Integer> foreachAddedFieldsSet = new HashSet<Integer>(foreachAddedFields);
                flattenedColumnSet.removeAll(foreachAddedFieldsSet);
            }
            if (flattenedColumnSet.size() == 0) {
                return false;
            }
            for (LogicalPlan foreachPlan : foreach.getForEachPlans()) {
                UDFFinder udfFinder = new UDFFinder(foreachPlan);
                udfFinder.visit();
                if (udfFinder.foundAnyUDF()) {
                    return false;
                }
                CastFinder castFinder = new CastFinder(foreachPlan);
                castFinder.visit();
                if (!castFinder.foundAnyCast()) continue;
                return false;
            }
            ArrayList<LOForEach> arrayList = successors = ((LogicalPlan)this.mPlan).getSuccessors(foreach) == null ? null : new ArrayList<LOForEach>(((LogicalPlan)this.mPlan).getSuccessors(foreach));
            if (successors == null || successors.size() == 0 || successors.size() > 1) {
                return false;
            }
            LogicalOperator successor = (LogicalOperator)successors.get(0);
            ArrayList<LogicalOperator> arrayList2 = peers = ((LogicalPlan)this.mPlan).getPredecessors(successor) == null ? null : new ArrayList<LogicalOperator>(((LogicalPlan)this.mPlan).getPredecessors(successor));
            if (peers != null) {
                for (LogicalOperator peer : peers) {
                    if (peer.equals(foreach) || !(peer instanceof LOForEach)) continue;
                    LOForEach peerForeach = (LOForEach)peer;
                    if (!((Boolean)peerForeach.hasFlatten().first).booleanValue()) continue;
                    return false;
                }
            }
            OperatorPlan.IndexHelper<LogicalOperator> indexHelper = new OperatorPlan.IndexHelper<LogicalOperator>(peers);
            Integer foreachPosition = indexHelper.getIndex(foreach);
            List<RequiredFields> requiredFieldsList = ((RelationalOperator)successor).getRequiredFields();
            RequiredFields requiredFields = requiredFieldsList.get(foreachPosition);
            MultiMap<Integer, ProjectionMap.Column> foreachMappedFields = foreachProjectionMap.getMappedFields();
            if (requiredFields.getFields() != null) {
                for (Pair<Integer, Integer> pair : requiredFields.getFields()) {
                    Collection<ProjectionMap.Column> columns = foreachMappedFields.get((Integer)pair.second);
                    if (columns == null) continue;
                    for (ProjectionMap.Column column : columns) {
                        Pair<Integer, Integer> foreachInputColumn = column.getInputColumn();
                        if (!foreach.isInputFlattened((Integer)foreachInputColumn.second)) continue;
                        return false;
                    }
                }
            }
            if (successor instanceof LOSort) {
                LOSort sort = (LOSort)successor;
                RequiredFields sortRequiredField = sort.getRequiredFields().get(0);
                if (sortRequiredField.getNeedAllFields()) {
                    return false;
                }
                List<Pair<Integer, Integer>> sortInputs = sortRequiredField.getFields();
                HashSet requiredInputs = new HashSet();
                for (Pair<Integer, Integer> pair : sortInputs) {
                    requiredInputs.add(pair.second);
                }
                requiredInputs.retainAll(flattenedColumnSet);
                if (requiredInputs.size() != 0) {
                    return false;
                }
                this.mSwap = true;
                return true;
            }
            if (successor instanceof LOCross || successor instanceof LOJoin) {
                List<LogicalOperator> children = ((LogicalPlan)this.mPlan).getSuccessors(successor);
                if (children == null || children.size() > 1) {
                    return false;
                }
                ProjectionMap succProjectionMap = successor.getProjectionMap();
                if (succProjectionMap == null) {
                    return false;
                }
                MultiMap<Integer, ProjectionMap.Column> mappedFields = succProjectionMap.getMappedFields();
                if (mappedFields == null) {
                    return false;
                }
                if (this.mFlattenedColumnReMap == null) {
                    this.mFlattenedColumnReMap = new HashMap<Integer, Integer>();
                }
                for (Integer key : flattenedColumnSet) {
                    this.mFlattenedColumnReMap.put(key, Integer.MAX_VALUE);
                }
                for (Integer key : mappedFields.keySet()) {
                    List columns = (List)mappedFields.get(key);
                    for (ProjectionMap.Column column : columns) {
                        Pair<Integer, Integer> inputColumn = column.getInputColumn();
                        if (!foreachPosition.equals(inputColumn.first) || !flattenedColumnSet.contains(inputColumn.second) || key >= this.mFlattenedColumnReMap.get(inputColumn.second)) continue;
                        this.mFlattenedColumnReMap.put((Integer)inputColumn.second, key);
                    }
                }
                for (Integer key : this.mFlattenedColumnReMap.keySet()) {
                    if (!this.mFlattenedColumnReMap.get(key).equals(Integer.MAX_VALUE)) continue;
                    return false;
                }
                this.mInsertBetween = true;
                return true;
            }
            return false;
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2152;
            String msg = "Internal error while trying to check if foreach with flatten can be pushed down.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    private LogicalOperator getOperator(List<LogicalOperator> nodes) throws FrontendException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        LogicalOperator lo = nodes.get(0);
        if (lo == null || !(lo instanceof LOForEach)) {
            int errCode = 2005;
            String msg = "Expected " + LOForEach.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
            throw new OptimizerException(msg, errCode, 2);
        }
        return lo;
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            LOForEach foreach = (LOForEach)this.getOperator(nodes);
            LogicalOperator successor = ((LogicalPlan)this.mPlan).getSuccessors(foreach).get(0);
            if (this.mSwap) {
                ((LogicalPlan)this.mPlan).swap(successor, foreach);
            } else if (this.mInsertBetween) {
                if (this.mFlattenedColumnReMap == null) {
                    int errCode = 2153;
                    String msg = "Internal error. The mapping for the flattened columns is empty";
                    throw new OptimizerException(msg, errCode, 4);
                }
                ArrayList<Boolean> flattenList = (ArrayList<Boolean>)foreach.getFlatten();
                for (Integer key : this.mFlattenedColumnReMap.keySet()) {
                    flattenList.set(key, false);
                }
                foreach.regenerateSchema();
                successor.regenerateSchema();
                Schema successorSchema = successor.getSchema();
                if (successorSchema == null) {
                    int errCode = 2154;
                    String msg = "Internal error. Schema of successor cannot be null for pushing down foreach with flatten.";
                    throw new OptimizerException(msg, errCode, 4);
                }
                flattenList = new ArrayList<Boolean>();
                ArrayList<LogicalPlan> foreachInnerPlans = new ArrayList<LogicalPlan>();
                for (int i = 0; i < successorSchema.size(); ++i) {
                    LogicalPlan innerPlan = new LogicalPlan();
                    LOProject project = new LOProject(innerPlan, OperatorKey.genOpKey(foreach.getOperatorKey().scope), successor, i);
                    innerPlan.add(project);
                    foreachInnerPlans.add(innerPlan);
                    flattenList.add(false);
                }
                for (Integer key : this.mFlattenedColumnReMap.keySet()) {
                    Integer value = this.mFlattenedColumnReMap.get(key);
                    flattenList.set(value, true);
                }
                LOForEach newForeach = new LOForEach((LogicalPlan)this.mPlan, OperatorKey.genOpKey(foreach.getOperatorKey().scope), foreachInnerPlans, flattenList);
                ((LogicalPlan)this.mPlan).add(newForeach);
                ((LogicalPlan)this.mPlan).insertBetween(successor, newForeach, (Operator)((LogicalPlan)this.mPlan).getSuccessors(successor).get(0));
            }
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2155;
            String msg = "Internal error while pushing foreach with flatten down.";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    @Override
    public void reset() {
        this.mInsertBetween = false;
        this.mSwap = false;
        this.mFlattenedColumnReMap = null;
    }
}

