/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.optimizer.LogicalTransformer;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.streaming.StreamingCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCastInserter
extends LogicalTransformer {
    private String operatorClassName;

    public TypeCastInserter(LogicalPlan plan, String operatorClassName) {
        super(plan);
        this.operatorClassName = operatorClassName;
    }

    @Override
    public boolean check(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            LogicalOperator op = this.getOperator(nodes);
            Schema s = op.getSchema();
            if (s == null) {
                return false;
            }
            boolean sawOne = false;
            List<Schema.FieldSchema> fss = s.getFields();
            ArrayList<Byte> types = new ArrayList<Byte>(s.size());
            Schema determinedSchema = null;
            if (LOLoad.class.getName().equals(this.operatorClassName)) {
                determinedSchema = ((LOLoad)op).getDeterminedSchema();
            }
            for (int i = 0; i < fss.size(); ++i) {
                if (fss.get((int)i).type != 50 && (determinedSchema == null || fss.get((int)i).type != determinedSchema.getField((int)i).type)) {
                    sawOne = true;
                }
                types.add(fss.get((int)i).type);
            }
            return sawOne;
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2004;
            String msg = "Internal error while trying to check if type casts are needed";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }

    private LogicalOperator getOperator(List<LogicalOperator> nodes) throws FrontendException {
        if (nodes == null || nodes.size() <= 0) {
            int errCode = 2052;
            String msg = "Internal error. Cannot retrieve operator from null or empty list.";
            throw new OptimizerException(msg, errCode, 4);
        }
        LogicalOperator lo = nodes.get(0);
        if (LOLoad.class.getName().equals(this.operatorClassName)) {
            if (lo == null || !(lo instanceof LOLoad)) {
                int errCode = 2005;
                String msg = "Expected " + LOLoad.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
                throw new OptimizerException(msg, errCode, 4);
            }
            return lo;
        }
        if (LOStream.class.getName().equals(this.operatorClassName)) {
            if (lo == null || !(lo instanceof LOStream)) {
                int errCode = 2005;
                String msg = "Expected " + LOStream.class.getSimpleName() + ", got " + (lo == null ? lo : lo.getClass().getSimpleName());
                throw new OptimizerException(msg, errCode, 4);
            }
            return lo;
        }
        int errCode = 1034;
        String msg = "TypeCastInserter invoked with an invalid operator class name:" + this.operatorClassName;
        throw new OptimizerException(msg, errCode, 2);
    }

    @Override
    public void transform(List<LogicalOperator> nodes) throws OptimizerException {
        try {
            LogicalOperator lo = this.getOperator(nodes);
            Schema s = lo.getSchema();
            String scope = lo.getOperatorKey().scope;
            ArrayList<LogicalPlan> genPlans = new ArrayList<LogicalPlan>(s.size());
            ArrayList<Boolean> flattens = new ArrayList<Boolean>(s.size());
            HashMap<String, Byte> typeChanges = new HashMap<String, Byte>();
            Schema determinedSchema = null;
            if (LOLoad.class.getName().equals(this.operatorClassName)) {
                determinedSchema = ((LOLoad)lo).getDeterminedSchema();
            }
            for (int i = 0; i < s.size(); ++i) {
                LogicalPlan p = new LogicalPlan();
                genPlans.add(p);
                flattens.add(false);
                ArrayList<Integer> toProject = new ArrayList<Integer>(1);
                toProject.add(i);
                LOProject proj = new LOProject(p, OperatorKey.genOpKey(scope), lo, toProject);
                p.add(proj);
                Schema.FieldSchema fs = s.getField(i);
                if (fs.type == 50 || determinedSchema != null && fs.type == determinedSchema.getField((int)i).type) continue;
                LOCast cast = new LOCast(p, OperatorKey.genOpKey(scope), fs.type);
                cast.setFieldSchema(fs);
                p.add(cast);
                p.connect(proj, cast);
                cast.setFieldSchema(fs.clone());
                FuncSpec loadFuncSpec = null;
                if (lo instanceof LOLoad) {
                    loadFuncSpec = ((LOLoad)lo).getInputFile().getFuncSpec();
                } else if (lo instanceof LOStream) {
                    StreamingCommand command = ((LOStream)lo).getStreamingCommand();
                    StreamingCommand.HandleSpec streamOutputSpec = command.getOutputSpec();
                    loadFuncSpec = new FuncSpec(streamOutputSpec.getSpec());
                } else {
                    int errCode = 2006;
                    String msg = "TypeCastInserter invoked with an invalid operator class name: " + lo.getClass().getSimpleName();
                    throw new OptimizerException(msg, errCode, 4);
                }
                cast.setLoadFuncSpec(loadFuncSpec);
                typeChanges.put(fs.canonicalName, fs.type);
                fs.type = determinedSchema == null ? (byte)50 : determinedSchema.getField((int)i).type;
            }
            LOForEach foreach = new LOForEach((LogicalPlan)this.mPlan, OperatorKey.genOpKey(scope), genPlans, flattens);
            foreach.setAlias(lo.getAlias());
            this.insertAfter(lo, foreach, null);
            this.rebuildSchemas();
        }
        catch (OptimizerException oe) {
            throw oe;
        }
        catch (Exception e) {
            int errCode = 2007;
            String msg = "Unable to insert type casts into plan";
            throw new OptimizerException(msg, errCode, 4, e);
        }
    }
}

