/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.UnaryExpression;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class CastExpression
extends UnaryExpression {
    private FuncSpec castFunc;
    private LogicalSchema.LogicalFieldSchema castSchema;

    public CastExpression(OperatorPlan plan, LogicalExpression exp, LogicalSchema.LogicalFieldSchema fs) {
        super("Cast", plan, exp);
        this.castSchema = fs;
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public void setFuncSpec(FuncSpec spec) {
        this.castFunc = spec;
    }

    public FuncSpec getFuncSpec() {
        return this.castFunc;
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof CastExpression) {
            CastExpression of = (CastExpression)other;
            return this.getExpression().isEqual(of.getExpression());
        }
        return false;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, this.castSchema.schema, this.castSchema.type);
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        LogicalExpression exp = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        if (exp.getFieldSchema() != null) {
            this.fieldSchema.uid = exp.getFieldSchema().uid;
            this.fieldSchema.alias = exp.getFieldSchema().alias;
        }
        return this.fieldSchema;
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        CastExpression copy = new CastExpression(lgExpPlan, this.getExpression().deepCopy(lgExpPlan), this.getFieldSchema().deepCopy());
        try {
            FuncSpec origFuncSpec = this.getFuncSpec();
            if (origFuncSpec != null) {
                copy.setFuncSpec(origFuncSpec.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return copy;
    }
}

