/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jython;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class JythonUtils {
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private static BagFactory bagFactory = DefaultBagFactory.getInstance();

    public static Object pythonToPig(PyObject pyObject) throws ExecException {
        try {
            Object javaObj = null;
            if (pyObject instanceof PyTuple) {
                PyTuple pyTuple = (PyTuple)pyObject;
                Object[] tuple = new Object[pyTuple.size()];
                int i = 0;
                for (PyObject tupleObject : pyTuple.getArray()) {
                    tuple[i++] = JythonUtils.pythonToPig(tupleObject);
                }
                javaObj = tupleFactory.newTuple(Arrays.asList(tuple));
            } else if (pyObject instanceof PyList) {
                DataBag list = bagFactory.newDefaultBag();
                for (PyObject bagTuple : ((PyList)pyObject).asIterable()) {
                    list.add((Tuple)JythonUtils.pythonToPig(bagTuple));
                }
                javaObj = list;
            } else if (pyObject instanceof PyDictionary) {
                Map map = (Map)Py.tojava((PyObject)pyObject, Map.class);
                HashMap newMap = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    newMap.put(entry.getKey(), JythonUtils.pythonToPig((PyObject)entry.getValue()));
                }
                javaObj = newMap;
            } else if (pyObject instanceof PyLong) {
                javaObj = pyObject.__tojava__(Long.class);
            } else if (pyObject instanceof PyInteger) {
                javaObj = pyObject.__tojava__(Integer.class);
            } else if (pyObject instanceof PyFloat) {
                javaObj = pyObject.__tojava__(Double.class);
            } else if (pyObject instanceof PyString) {
                javaObj = pyObject.__tojava__(String.class);
            } else {
                if (pyObject instanceof PyNone) {
                    return null;
                }
                javaObj = pyObject.__tojava__(byte[].class);
                if (javaObj instanceof byte[]) {
                    javaObj = new DataByteArray((byte[])javaObj);
                } else {
                    throw new ExecException("Non supported pig datatype found, cast failed");
                }
            }
            if (javaObj.equals(Py.NoConversion)) {
                throw new ExecException("Cannot cast into any pig supported type");
            }
            return javaObj;
        }
        catch (Exception e) {
            throw new ExecException("Cannot convert jython type to pig datatype " + e);
        }
    }

    public static PyObject pigToPython(Object object) {
        if (object instanceof Tuple) {
            return JythonUtils.pigTupleToPyTuple((Tuple)object);
        }
        if (object instanceof DataBag) {
            PyList list = new PyList();
            for (Tuple bagTuple : (DataBag)object) {
                list.add((Object)JythonUtils.pigTupleToPyTuple(bagTuple));
            }
            return list;
        }
        if (object instanceof Map) {
            PyDictionary newMap = new PyDictionary();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                newMap.put(entry.getKey(), (Object)JythonUtils.pigToPython(entry.getValue()));
            }
            return newMap;
        }
        if (object instanceof DataByteArray) {
            return Py.java2py((Object)((DataByteArray)object).get());
        }
        return Py.java2py((Object)object);
    }

    public static PyTuple pigTupleToPyTuple(Tuple tuple) {
        PyObject[] pyTuple = new PyObject[tuple.size()];
        int i = 0;
        for (Object object : tuple.getAll()) {
            pyTuple[i++] = JythonUtils.pigToPython(object);
        }
        return new PyTuple(pyTuple);
    }
}

