/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.DefaultReportDesignerContext;
import org.pentaho.reporting.designer.core.InternalZoomAction;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerDocumentContext;
import org.pentaho.reporting.designer.core.ReportDesignerView;
import org.pentaho.reporting.designer.core.TreeSidePanel;
import org.pentaho.reporting.designer.core.actions.elements.InsertElementAction;
import org.pentaho.reporting.designer.core.actions.elements.MorphAction;
import org.pentaho.reporting.designer.core.actions.elements.barcode.BarcodeTypeAction;
import org.pentaho.reporting.designer.core.actions.global.AboutAction;
import org.pentaho.reporting.designer.core.actions.global.OpenReportAction;
import org.pentaho.reporting.designer.core.actions.global.OpenSampleReportAction;
import org.pentaho.reporting.designer.core.actions.global.QuitAction;
import org.pentaho.reporting.designer.core.actions.global.SelectTabAction;
import org.pentaho.reporting.designer.core.actions.global.SettingsAction;
import org.pentaho.reporting.designer.core.actions.report.CloseAllReportsAction;
import org.pentaho.reporting.designer.core.actions.report.CloseChildReportsAction;
import org.pentaho.reporting.designer.core.actions.report.CloseOtherReportsAction;
import org.pentaho.reporting.designer.core.actions.report.CloseReportAction;
import org.pentaho.reporting.designer.core.actions.report.CloseUnmodifiedReportsAction;
import org.pentaho.reporting.designer.core.editor.ContextMenuUtility;
import org.pentaho.reporting.designer.core.editor.ElementPropertiesPanel;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.ReportRendererComponent;
import org.pentaho.reporting.designer.core.editor.fieldselector.FieldSelectorPaletteDialog;
import org.pentaho.reporting.designer.core.editor.palette.PaletteButton;
import org.pentaho.reporting.designer.core.frame.RecentFilesUpdateHandler;
import org.pentaho.reporting.designer.core.inspections.InspectionSidePanePanel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.status.StatusBar;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.docking.Category;
import org.pentaho.reporting.designer.core.util.docking.GlobalPane;
import org.pentaho.reporting.designer.core.util.docking.InternalWindow;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.welcome.SamplesTreeBuilder;
import org.pentaho.reporting.designer.core.welcome.WelcomePane;
import org.pentaho.reporting.designer.core.widgets.FancyTabbedPane;
import org.pentaho.reporting.designer.core.widgets.TabRenderer;
import org.pentaho.reporting.designer.core.xul.ActionSwingMenuitem;
import org.pentaho.reporting.designer.core.xul.XulDesignerFrame;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes.BarcodeTypePropertyEditor;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.tags.SwingMenuseparator;

public class ReportDesignerFrame
extends JFrame {
    private static final Log logger = LogFactory.getLog(ReportDesignerFrame.class);
    private final VisibleElementsUpdateHandler visibleElementsUpdateHandler;
    private JTabbedPane reportEditorPane;
    private GlobalPane dockingPane;
    private StatusBar statusBar;
    private DefaultReportDesignerContext context;
    private Category attributeToolWindow;
    private Category reportTreeToolWindow;
    private Category inspectionsToolWindow;
    private FrameViewController viewController;
    private ElementPropertiesPanel attributeEditorPanel;
    private WelcomePane welcomePane;
    private FieldSelectorPaletteDialog fieldSelectorPaletteDialog;
    private TreeSidePanel treePanel;
    private JComponent paletteToolBar;

    public ReportDesignerFrame() throws XulException {
        this.setDefaultCloseOperation(0);
        ImageIcon icon = IconLoader.getInstance().getProductIcon();
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setTitle(Messages.getString("ReportDesignerFrame.Title", new Object[0]));
        this.addWindowListener(new WindowCloseHandler());
        this.viewController = new FrameViewController(this);
        this.context = new DefaultReportDesignerContext(this.viewController);
        this.viewController.initializeXulDesignerFrame(this.context);
        this.welcomePane = new WelcomePane(this, (ReportDesignerContext)this.getContext());
        this.fieldSelectorPaletteDialog = new FieldSelectorPaletteDialog((Frame)this, this.getContext());
        this.statusBar = new StatusBar(this.context);
        this.reportEditorPane = new FancyTabbedPane();
        this.reportEditorPane.setTabLayoutPolicy(1);
        this.reportEditorPane.getModel().addChangeListener(new ReportTabActivationHandler());
        this.reportEditorPane.addMouseListener(new ReportTabPanePopupHandler());
        this.dockingPane = new GlobalPane(false);
        this.dockingPane.setMainComponent(this.reportEditorPane);
        this.attributeEditorPanel = new ElementPropertiesPanel();
        this.attributeEditorPanel.setAllowAttributeCard(true);
        this.attributeEditorPanel.setReportDesignerContext(this.context);
        this.treePanel = new TreeSidePanel(this.context, this.attributeEditorPanel);
        this.initializeToolWindows();
        this.paletteToolBar = this.createPaletteToolBar();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.context.getToolBar("main-toolbar"), "North");
        contentPane.add((Component)this.dockingPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        contentPane.add((Component)this.paletteToolBar, "West");
        this.setContentPane(contentPane);
        this.setJMenuBar(this.createMenuBar());
        this.setDropTarget(new DropTarget(this, 3, new DefaultDropTargetListener()));
        this.context.addPropertyChangeListener("activeContext", new ReportTabActivationHandler());
        this.context.addPropertyChangeListener("statusText", new StatusTextHandler());
        this.context.addPropertyChangeListener("page", new PageTextHandler());
        this.context.addPropertyChangeListener("reportRenderContext", new ReportEditorContextHandler());
        Toolkit.getDefaultToolkit().addAWTEventListener(new DragSelectionToggleHandler(), 8L);
        if (MacOSXIntegration.MAC_OS_X) {
            try {
                AboutAction aboutAction = new AboutAction();
                aboutAction.setReportDesignerContext(this.context);
                SettingsAction settingsAction = new SettingsAction();
                settingsAction.setReportDesignerContext(this.context);
                QuitAction quitAction = new QuitAction();
                quitAction.setReportDesignerContext(this.context);
                OpenReportAction openReportAction = new OpenReportAction();
                openReportAction.setReportDesignerContext(this.context);
                MacOSXIntegration.setOpenFileAction((Action)openReportAction);
                MacOSXIntegration.setAboutAction((Action)aboutAction);
                MacOSXIntegration.setPreferencesAction((Action)settingsAction);
                MacOSXIntegration.setQuitAction((Action)quitAction);
            }
            catch (Throwable e) {
                DebugLog.log((Object)"Failed to activate MacOS-X integration", (Throwable)e);
            }
        }
        this.visibleElementsUpdateHandler = new VisibleElementsUpdateHandler();
        WorkspaceSettings.getInstance().addSettingsListener(this.visibleElementsUpdateHandler);
    }

    public void initWindowLocations(File[] filesToOpen) {
        this.fieldSelectorPaletteDialog.initWindowLocation();
        this.viewController.setFieldSelectorVisible(WorkspaceSettings.getInstance().isFieldSelectorVisible());
        this.welcomePane.setLocationRelativeTo(this);
        if (filesToOpen == null || filesToOpen.length == 0) {
            File[] recentFiles;
            if (WorkspaceSettings.getInstance().isReopenLastReport() && (recentFiles = this.context.getRecentFilesModel().getRecentFiles()).length > 0) {
                SwingUtilities.invokeLater(new OpenReportAction.OpenReportTask(recentFiles[0], this.context));
                return;
            }
            SwingUtilities.invokeLater(new ShowWelcomeScreenTask());
        } else {
            for (int i = 0; i < filesToOpen.length; ++i) {
                File file = filesToOpen[i];
                SwingUtilities.invokeLater(new OpenReportAction.OpenReportTask(file, this.context));
            }
        }
    }

    protected Category getAttributeToolWindow() {
        return this.attributeToolWindow;
    }

    protected Category getReportTreeToolWindow() {
        return this.reportTreeToolWindow;
    }

    protected Category getInspectionsToolWindow() {
        return this.inspectionsToolWindow;
    }

    protected ElementPropertiesPanel getAttributeEditorPanel() {
        return this.attributeEditorPanel;
    }

    protected JTabbedPane getReportEditorPane() {
        return this.reportEditorPane;
    }

    protected DefaultReportDesignerContext getContext() {
        return this.context;
    }

    protected StatusBar getStatusBar() {
        return this.statusBar;
    }

    private JMenuBar createMenuBar() {
        this.createRecentFilesMenu();
        this.createZoomMenu();
        this.createMorphMenu();
        this.createInsertElementsMenu();
        this.createInsertDataSourcesMenu();
        this.createSamplesMenu();
        return this.context.getView().getComponent("main-menubar", JMenuBar.class);
    }

    private void createInsertDataSourcesMenu() {
        JMenu insertDataSourcesMenu = this.context.getView().getComponent("insert-datasources-menu", JMenu.class);
        if (insertDataSourcesMenu != null) {
            ContextMenuUtility.createDataSourceMenu(this.context, insertDataSourcesMenu);
        }
    }

    private void createInsertElementsMenu() {
        XulMenupopup insertElementsMenu = this.context.getView().getXulComponent("insert-elements-popup", XulMenupopup.class);
        if (insertElementsMenu == null) {
            return;
        }
        ElementMetaData[] datas = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            ElementMetaData data = datas[i];
            if (data.isHidden()) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, (Object)grouping)) {
                    grouping = currentGrouping;
                    SwingMenuseparator separator = new SwingMenuseparator(null, null, null, "menuseparator");
                    insertElementsMenu.addChild((Element)separator);
                }
            } else {
                grouping = currentGrouping;
                firstElement = false;
            }
            InsertElementAction action = new InsertElementAction(data);
            action.setReportDesignerContext(this.context);
            ActionSwingMenuitem menuItem = new ActionSwingMenuitem("menuitem");
            menuItem.setAction(action);
            insertElementsMenu.addChild((Element)menuItem);
        }
    }

    private void createRecentFilesMenu() {
        XulMenupopup reopenMenu = this.context.getView().getXulComponent("file-reopen-popup", XulMenupopup.class);
        XulMenuitem clearMenuitem = this.context.getView().getXulComponent("file-clear-recent", XulMenuitem.class);
        if (reopenMenu != null && clearMenuitem != null) {
            RecentFilesUpdateHandler updateHandler = new RecentFilesUpdateHandler(this.context, reopenMenu, clearMenuitem);
            updateHandler.settingsChanged();
            this.context.getRecentFilesModel().addSettingsListener(updateHandler);
        }
    }

    private void createZoomMenu() {
        XulMenupopup zoomMenu = this.context.getView().getXulComponent("view-zoom-selection-popup", XulMenupopup.class);
        if (zoomMenu == null) {
            return;
        }
        InternalZoomAction zoom50action = new InternalZoomAction(50);
        InternalZoomAction zoom100action = new InternalZoomAction(100);
        InternalZoomAction zoom200action = new InternalZoomAction(200);
        InternalZoomAction zoom400action = new InternalZoomAction(400);
        zoom50action.setReportDesignerContext(this.context);
        zoom100action.setReportDesignerContext(this.context);
        zoom200action.setReportDesignerContext(this.context);
        zoom400action.setReportDesignerContext(this.context);
        zoomMenu.addChild((Element)this.context.getView().createMenuItem(zoom50action));
        zoomMenu.addChild((Element)this.context.getView().createMenuItem(zoom100action));
        zoomMenu.addChild((Element)this.context.getView().createMenuItem(zoom200action));
        zoomMenu.addChild((Element)this.context.getView().createMenuItem(zoom400action));
    }

    private void createSamplesMenu() {
        XulMenupopup samplesPopup = this.context.getView().getXulComponent("help-samples-popup", XulMenupopup.class);
        if (samplesPopup == null) {
            return;
        }
        for (XulComponent childNode : new ArrayList(samplesPopup.getChildNodes())) {
            samplesPopup.removeChild((Element)childNode);
        }
        TreeModel treeModel = SamplesTreeBuilder.getSampleTreeModel();
        Object root = treeModel.getRoot();
        try {
            this.insertReports(treeModel, root, samplesPopup);
        }
        catch (XulException e) {
            logger.warn((Object)"Failed to initialize sample menu", (Throwable)e);
        }
    }

    private void insertReports(TreeModel model, Object currentLevel, XulMenupopup popup) throws XulException {
        int childCount = model.getChildCount(currentLevel);
        for (int i = 0; i < childCount; ++i) {
            ReportDesignerView frame = this.context.getView();
            Object child = model.getChild(currentLevel, i);
            if (model.isLeaf(child)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)child;
                File file = new File(String.valueOf(node.getUserObject()));
                OpenSampleReportAction action = new OpenSampleReportAction(file, node.toString());
                action.setReportDesignerContext(this.context);
                popup.addChild((Element)frame.createMenuItem(action));
                continue;
            }
            XulMenupopup childPopup = frame.createPopupMenu(String.valueOf(child), (XulComponent)popup);
            this.insertReports(model, child, childPopup);
        }
    }

    private void createMorphMenu() {
        JMenu morphMenu = this.context.getView().getComponent("format-morph-menu", JMenu.class);
        if (morphMenu == null) {
            return;
        }
        ElementMetaData[] datas = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            ElementMetaData data = datas[i];
            if (data.isHidden()) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, (Object)grouping)) {
                    grouping = currentGrouping;
                    morphMenu.addSeparator();
                }
            } else {
                grouping = currentGrouping;
                firstElement = false;
            }
            try {
                MorphAction action = new MorphAction(data.create());
                action.setReportDesignerContext(this.context);
                morphMenu.add(new JMenuItem(action));
                continue;
            }
            catch (InstantiationException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    private void initializeToolWindows() {
        this.reportTreeToolWindow = this.createStructureTreeToolWindow();
        this.attributeToolWindow = this.createAttributesToolWindow();
        this.inspectionsToolWindow = this.createInspectionsToolWindow();
        this.dockingPane.add(GlobalPane.Alignment.RIGHT, this.reportTreeToolWindow);
        this.dockingPane.add(GlobalPane.Alignment.RIGHT, this.attributeToolWindow);
        this.dockingPane.add(GlobalPane.Alignment.BOTTOM, this.inspectionsToolWindow);
        this.dockingPane.setPreferredContentSize(GlobalPane.Alignment.BOTTOM, 100);
        this.dockingPane.setPreferredContentSize(GlobalPane.Alignment.RIGHT, 300);
        this.initAddElements("popup-Band.add-element-menu");
        this.initAddElements("popup-RootLevelBand.add-element-menu");
        this.initSetBarcodeTypeElements("popup-Barcode.type");
    }

    private Category createAttributesToolWindow() {
        ImageIcon propertyTableIcon = IconLoader.getInstance().getPropertyTableIcon();
        return new Category(propertyTableIcon, Messages.getString("Attribute.Title", new Object[0]), this.attributeEditorPanel);
    }

    private Category createInspectionsToolWindow() {
        InspectionSidePanePanel inspectionsMessagePanel = new InspectionSidePanePanel();
        inspectionsMessagePanel.setReportDesignerContext(this.context);
        InternalWindow inspectionGadgetInternalWindow = new InternalWindow(Messages.getString("InspectionGadget.Title", new Object[0]));
        inspectionGadgetInternalWindow.add((Component)inspectionsMessagePanel, "Center");
        Category category = new Category(IconLoader.getInstance().getMessagesIcon(), Messages.getString("Messages.Title", new Object[0]), inspectionGadgetInternalWindow);
        category.setMinimized(true);
        return category;
    }

    private Category createStructureTreeToolWindow() {
        return new Category(IconLoader.getInstance().getReportTreeIcon(), Messages.getString("StructureView.Title", new Object[0]), this.treePanel);
    }

    private void initSetBarcodeTypeElements(String id) {
        JMenu menu = this.context.getView().getComponent(id, JMenu.class);
        if (menu == null) {
            return;
        }
        BarcodeTypePropertyEditor editor = new BarcodeTypePropertyEditor();
        String[] tags = editor.getTags();
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            BarcodeTypeAction action = new BarcodeTypeAction(tag);
            action.setReportDesignerContext(this.context);
            menu.add(new JRadioButtonMenuItem(action));
        }
    }

    private void initAddElements(String id) {
        JMenu menu = this.context.getView().getComponent(id, JMenu.class);
        if (menu == null) {
            return;
        }
        ElementMetaData[] datas = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            ElementMetaData data = datas[i];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, (Object)grouping)) {
                    grouping = currentGrouping;
                    menu.addSeparator();
                }
            } else {
                grouping = currentGrouping;
                firstElement = false;
            }
            InsertElementAction action = new InsertElementAction(data);
            action.setReportDesignerContext(this.context);
            menu.add(new JMenuItem(action));
        }
    }

    private JComponent createPaletteToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        ElementMetaData[] datas = ElementTypeRegistry.getInstance().getAllElementTypes();
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            ElementMetaData data = datas[i];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data)) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, (Object)grouping)) {
                    grouping = currentGrouping;
                    toolBar.addSeparator();
                }
            } else {
                grouping = currentGrouping;
                firstElement = false;
            }
            InsertElementAction action = new InsertElementAction(data);
            action.setReportDesignerContext(this.context);
            toolBar.add(new PaletteButton(data, this.context));
        }
        JScrollPane paletteScrollpane = new JScrollPane(toolBar);
        paletteScrollpane.setHorizontalScrollBarPolicy(31);
        paletteScrollpane.addComponentListener(new ScrollbarSyncHandler(paletteScrollpane.getVerticalScrollBar(), toolBar));
        return paletteScrollpane;
    }

    private void rebuildReportMenu() {
        XulComponent reopenMenu = this.context.getView().getXulComponent("window.reports-area", XulComponent.class);
        if (reopenMenu == null) {
            return;
        }
        List xulComponents = reopenMenu.getChildNodes();
        XulComponent[] objects = xulComponents.toArray(new XulComponent[xulComponents.size()]);
        for (int i = 0; i < objects.length; ++i) {
            XulComponent object = objects[i];
            reopenMenu.removeChild((Element)object);
        }
        JTabbedPane tabbedPane = this.getReportEditorPane();
        int count = tabbedPane.getTabCount();
        if (count > 0) {
            reopenMenu.addChild((Element)new SwingMenuseparator(null, null, null, "menu-separator"));
            for (int i = 0; i < count; ++i) {
                String tabName;
                Component at = tabbedPane.getTabComponentAt(i);
                if (at instanceof TabRenderer) {
                    TabRenderer renderer = (TabRenderer)at;
                    tabName = renderer.getTitle();
                } else {
                    tabName = tabbedPane.getTitleAt(i);
                }
                SelectTabAction action = new SelectTabAction(i, tabName);
                ActionSwingMenuitem actionSwingMenuitem = this.context.getView().createMenuItem(action);
                actionSwingMenuitem.setReportDesignerContext(this.context);
                reopenMenu.addChild((Element)actionSwingMenuitem);
            }
        }
    }

    protected void updateFrameTitle() {
        String report;
        String reportName;
        int i = this.getReportEditorPane().getSelectedIndex();
        if (this.getContext() != null && this.getContext().getActiveContext() != null) {
            if (i == -1) {
                reportName = null;
            } else {
                Component at = this.getReportEditorPane().getTabComponentAt(i);
                if (at instanceof TabRenderer) {
                    TabRenderer renderer = (TabRenderer)at;
                    reportName = renderer.getTitle();
                } else {
                    reportName = this.getReportEditorPane().getTitleAt(i);
                }
            }
            report = this.getContext().getActiveContext().getDocumentFile();
        } else {
            report = null;
            reportName = null;
        }
        this.setTitle(this.computeFrameTitle(reportName, report));
    }

    private String computeFrameTitle(String tabName, String path) {
        if (tabName == null || path == null) {
            return Messages.getString("ReportDesignerFrame.Title", new Object[0]);
        }
        if (StringUtils.isEmpty((String)path)) {
            return Messages.getString("ReportDesignerFrame.TitleWithName", tabName);
        }
        return Messages.getString("ReportDesignerFrame.TitleWithNameAndPath", tabName, path);
    }

    private void recomputeAllTabTitles() {
        JTabbedPane editorPane = this.getReportEditorPane();
        int count = editorPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component at = editorPane.getTabComponentAt(i);
            if (!(at instanceof TabRenderer)) continue;
            TabRenderer renderer = (TabRenderer)at;
            renderer.setTitle(renderer.recomputeTabName());
        }
        this.updateFrameTitle();
    }

    private class VisibleElementsUpdateHandler
    implements SettingsListener {
        private boolean deprecated = WorkspaceSettings.getInstance().isShowDeprecatedItems();
        private boolean expert = WorkspaceSettings.getInstance().isShowExpertItems();
        private MaturityLevel maturityLevel = WorkspaceSettings.getInstance().getMaturityLevel();

        private VisibleElementsUpdateHandler() {
        }

        @Override
        public void settingsChanged() {
            if (this.isChanged()) {
                try {
                    ReportDesignerFrame.this.viewController.initializeXulDesignerFrame(ReportDesignerFrame.this.context);
                    ReportDesignerFrame.this.getContentPane().remove(ReportDesignerFrame.this.paletteToolBar);
                    ReportDesignerFrame.this.paletteToolBar = ReportDesignerFrame.this.createPaletteToolBar();
                    ReportDesignerFrame.this.getContentPane().add((Component)ReportDesignerFrame.this.paletteToolBar, "West");
                    ReportDesignerFrame.this.setJMenuBar(ReportDesignerFrame.this.createMenuBar());
                    ReportDesignerFrame.this.revalidate();
                    ReportDesignerFrame.this.repaint();
                }
                catch (XulException e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                }
                this.deprecated = WorkspaceSettings.getInstance().isShowDeprecatedItems();
                this.expert = WorkspaceSettings.getInstance().isShowExpertItems();
                this.maturityLevel = WorkspaceSettings.getInstance().getMaturityLevel();
            }
        }

        private boolean isChanged() {
            if (WorkspaceSettings.getInstance().isShowDeprecatedItems() != this.deprecated) {
                return true;
            }
            if (WorkspaceSettings.getInstance().isShowExpertItems() != this.expert) {
                return true;
            }
            return WorkspaceSettings.getInstance().getMaturityLevel() != this.maturityLevel;
        }
    }

    private class DocumentNameChangeHandler
    implements PropertyChangeListener {
        private ReportDesignerDocumentContext documentContext;
        private TabRenderer tabRenderer;
        private int tabIndex;

        private DocumentNameChangeHandler(ReportDesignerDocumentContext documentContext, TabRenderer tabRenderer, int tabIndex) {
            this.documentContext = documentContext;
            this.tabRenderer = tabRenderer;
            this.tabIndex = tabIndex;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String tabName = this.documentContext.getTabName();
            this.tabRenderer.setRawTabName(tabName);
            ReportDesignerFrame.this.getReportEditorPane().setTitleAt(this.tabIndex, tabName);
            ReportDesignerFrame.this.recomputeAllTabTitles();
            ReportDesignerFrame.this.rebuildReportMenu();
        }
    }

    private class PageTextHandler
    implements PropertyChangeListener {
        private PageTextHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportDesignerFrame.this.statusBar.setPages(ReportDesignerFrame.this.context.getPage(), ReportDesignerFrame.this.context.getPageTotal());
        }
    }

    private class DragSelectionToggleHandler
    implements AWTEventListener {
        private DragSelectionToggleHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (!(event instanceof KeyEvent)) {
                return;
            }
            KeyEvent keyevent = (KeyEvent)event;
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() == ReportDesignerFrame.this) {
                ReportDesignerFrame.this.context.setSelectionWaiting(keyevent.isShiftDown());
            }
        }
    }

    private class ShowWelcomeScreenTask
    implements Runnable {
        private ShowWelcomeScreenTask() {
        }

        @Override
        public void run() {
            ReportDesignerFrame.this.viewController.setWelcomeVisible(WorkspaceSettings.getInstance().isShowLauncher());
        }
    }

    private class FrameViewController
    implements ReportDesignerView {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private XulDesignerFrame xulDesignerFrame;
        private Component parent;

        private FrameViewController(Component parent) {
            this.parent = parent;
        }

        private void initializeXulDesignerFrame(ReportDesignerContext context) throws XulException {
            this.xulDesignerFrame = new XulDesignerFrame();
            this.xulDesignerFrame.setReportDesignerContext(context);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        @Override
        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        @Override
        public boolean isStructureVisible() {
            Category reportTreeToolWindow = ReportDesignerFrame.this.getReportTreeToolWindow();
            return reportTreeToolWindow != null && !reportTreeToolWindow.isMinimized();
        }

        @Override
        public void setStructureVisible(boolean visible) {
            Category reportTreeToolWindow = ReportDesignerFrame.this.getReportTreeToolWindow();
            boolean oldValue = !reportTreeToolWindow.isMinimized();
            reportTreeToolWindow.setMinimized(!visible);
            this.propertyChangeSupport.firePropertyChange("structureVisible", oldValue, visible);
        }

        @Override
        public boolean isPropertiesEditorVisible() {
            Category attributeToolWindow = ReportDesignerFrame.this.getAttributeToolWindow();
            if (attributeToolWindow == null) {
                return false;
            }
            return !attributeToolWindow.isMinimized();
        }

        @Override
        public void setPropertiesEditorVisible(boolean visible) {
            Category attributeToolWindow = ReportDesignerFrame.this.getAttributeToolWindow();
            boolean oldValue = !attributeToolWindow.isMinimized();
            attributeToolWindow.setMinimized(!visible);
            this.propertyChangeSupport.firePropertyChange("propertiesEditorVisible", oldValue, visible);
        }

        @Override
        public boolean isMessagesVisible() {
            Category inspectionsToolWindow = ReportDesignerFrame.this.getInspectionsToolWindow();
            return inspectionsToolWindow != null && !inspectionsToolWindow.isMinimized();
        }

        @Override
        public void setMessagesVisible(boolean visible) {
            Category inspectionsToolWindow = ReportDesignerFrame.this.getInspectionsToolWindow();
            boolean oldValue = !inspectionsToolWindow.isMinimized();
            inspectionsToolWindow.setMinimized(!visible);
            this.propertyChangeSupport.firePropertyChange("messagesVisible", oldValue, visible);
        }

        @Override
        public boolean isPreviewVisible() {
            JTabbedPane reportEditorPane = ReportDesignerFrame.this.getReportEditorPane();
            if (reportEditorPane == null || reportEditorPane.getTabCount() == 0) {
                return false;
            }
            if (reportEditorPane.getSelectedComponent() instanceof ReportRendererComponent) {
                ReportRendererComponent rendererComponent = (ReportRendererComponent)reportEditorPane.getSelectedComponent();
                return !rendererComponent.isDesignVisible();
            }
            return false;
        }

        @Override
        public void setPreviewVisible(boolean visible) {
            boolean oldValue = this.isPreviewVisible();
            JTabbedPane reportEditorPane = ReportDesignerFrame.this.getReportEditorPane();
            if (reportEditorPane != null && reportEditorPane.getTabCount() > 0 && reportEditorPane.getSelectedComponent() instanceof ReportRendererComponent) {
                ReportRendererComponent rendererComponent = (ReportRendererComponent)reportEditorPane.getSelectedComponent();
                if (visible) {
                    rendererComponent.showPreview();
                } else {
                    rendererComponent.showDesign();
                }
            }
            this.propertyChangeSupport.firePropertyChange("previewVisible", oldValue, visible);
        }

        @Override
        public boolean isWelcomeVisible() {
            if (ReportDesignerFrame.this.welcomePane == null) {
                return false;
            }
            return ReportDesignerFrame.this.welcomePane.isVisible();
        }

        @Override
        public void setWelcomeVisible(boolean visible) {
            if (ReportDesignerFrame.this.welcomePane == null) {
                return;
            }
            ReportDesignerFrame.this.welcomePane.setVisible(visible);
            ReportDesignerFrame.this.welcomePane.toFront();
        }

        @Override
        public boolean isFieldSelectorVisible() {
            if (ReportDesignerFrame.this.fieldSelectorPaletteDialog == null) {
                return false;
            }
            return ReportDesignerFrame.this.fieldSelectorPaletteDialog.isVisible();
        }

        @Override
        public void setFieldSelectorVisible(boolean visible) {
            if (ReportDesignerFrame.this.fieldSelectorPaletteDialog == null) {
                return;
            }
            ReportDesignerFrame.this.fieldSelectorPaletteDialog.setVisible(visible);
            ReportDesignerFrame.this.fieldSelectorPaletteDialog.toFront();
        }

        @Override
        public void redrawAll() {
            ReportDesignerFrame.this.getReportEditorPane().invalidate();
            ReportDesignerFrame.this.getReportEditorPane().revalidate();
            ReportDesignerFrame.this.getReportEditorPane().repaint();
        }

        @Override
        public void showDataTree() {
            ReportDesignerFrame.this.treePanel.refreshTabPanel(ReportDesignerFrame.this.getAttributeEditorPanel());
            ReportDesignerFrame.this.treePanel.showDataTab();
        }

        @Override
        public JPopupMenu getPopupMenu(String id) {
            return this.xulDesignerFrame.getComponent(id, JPopupMenu.class);
        }

        @Override
        public JComponent getToolBar(String id) {
            JComponent toolBar = this.xulDesignerFrame.getComponent(id, JComponent.class);
            if (toolBar instanceof JToolBar) {
                JToolBar realToolBar = (JToolBar)toolBar;
                realToolBar.setFloatable(false);
            }
            return toolBar;
        }

        @Override
        public Component getParent() {
            return this.parent;
        }

        @Override
        public <T extends JComponent> T getComponent(String id, Class<T> type) {
            T xulComponentById = this.xulDesignerFrame.getComponent(id, type);
            if (type.isInstance(xulComponentById)) {
                return xulComponentById;
            }
            return null;
        }

        @Override
        public <T extends XulComponent> T getXulComponent(String id, Class<T> type) {
            T xulComponentById = this.xulDesignerFrame.getXulComponent(id, type);
            if (type.isInstance(xulComponentById)) {
                return xulComponentById;
            }
            return null;
        }

        @Override
        public ActionSwingMenuitem createMenuItem(Action action) {
            return this.xulDesignerFrame.createMenu(action);
        }

        @Override
        public XulMenupopup createPopupMenu(String label, XulComponent parent) throws XulException {
            return this.xulDesignerFrame.createPopupMenu(label, parent);
        }
    }

    private class ReportTabPanePopupHandler
    extends MouseAdapter {
        private ReportTabPanePopupHandler() {
        }

        private void handlePopup(MouseEvent e) {
            JTabbedPane reportEditorPane = ReportDesignerFrame.this.getReportEditorPane();
            TabbedPaneUI ui = reportEditorPane.getUI();
            int tabIndex = ui.tabForCoordinate(reportEditorPane, e.getX(), e.getY());
            JPopupMenu popupMenu = new JPopupMenu();
            CloseReportAction closeThisAction = new CloseReportAction(tabIndex);
            closeThisAction.setReportDesignerContext(ReportDesignerFrame.this.getContext());
            CloseChildReportsAction closeChildsAction = new CloseChildReportsAction(tabIndex);
            closeChildsAction.setReportDesignerContext(ReportDesignerFrame.this.getContext());
            CloseOtherReportsAction closeOthersAction = new CloseOtherReportsAction(tabIndex);
            closeOthersAction.setReportDesignerContext(ReportDesignerFrame.this.getContext());
            CloseAllReportsAction closeAllAction = new CloseAllReportsAction();
            closeAllAction.setReportDesignerContext(ReportDesignerFrame.this.getContext());
            CloseUnmodifiedReportsAction closeUnmodifiedReportsAction = new CloseUnmodifiedReportsAction();
            closeUnmodifiedReportsAction.setReportDesignerContext(ReportDesignerFrame.this.getContext());
            popupMenu.add(new JMenuItem(closeThisAction));
            popupMenu.addSeparator();
            popupMenu.add(new JMenuItem(closeChildsAction));
            popupMenu.add(new JMenuItem(closeUnmodifiedReportsAction));
            popupMenu.add(new JMenuItem(closeOthersAction));
            popupMenu.add(new JMenuItem(closeAllAction));
            popupMenu.show(reportEditorPane, e.getX(), e.getY());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopup(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopup(e);
            }
        }
    }

    private class ReportEditorContextHandler
    implements PropertyChangeListener {
        private ReportEditorContextHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"reportRenderContext".equals(evt.getPropertyName())) {
                return;
            }
            if (!(evt instanceof IndexedPropertyChangeEvent)) {
                throw new UnsupportedOperationException();
            }
            JTabbedPane editorPanes = ReportDesignerFrame.this.getReportEditorPane();
            IndexedPropertyChangeEvent ievt = (IndexedPropertyChangeEvent)evt;
            if (ievt.getNewValue() != null) {
                ReportRenderContext renderContext = (ReportRenderContext)ievt.getNewValue();
                DefaultReportDesignerContext reportDesignerContext = ReportDesignerFrame.this.getContext();
                ReportRendererComponent rendererComponent = new ReportRendererComponent(reportDesignerContext, renderContext);
                String title = renderContext.getTabName();
                Icon icon = renderContext.getIcon();
                TabRenderer tabRenderer = new TabRenderer(icon, title, reportDesignerContext, editorPanes);
                editorPanes.addTab(title, null, rendererComponent);
                editorPanes.setTabComponentAt(editorPanes.getTabCount() - 1, tabRenderer);
                editorPanes.setSelectedComponent(rendererComponent);
                renderContext.addPropertyChangeListener("tabName", new DocumentNameChangeHandler(renderContext, tabRenderer, editorPanes.getTabCount() - 1));
            } else if (ievt.getOldValue() != null) {
                if (editorPanes.getTabCount() <= 0) {
                    return;
                }
                int index = ievt.getIndex();
                ReportRenderContext reportRenderContext = (ReportRenderContext)ievt.getOldValue();
                boolean removedTab = false;
                for (int i = 0; i < editorPanes.getTabCount(); ++i) {
                    ReportRendererComponent myReportRenderer;
                    Component tabContent = editorPanes.getComponentAt(i);
                    if (!(tabContent instanceof ReportRendererComponent) || (myReportRenderer = (ReportRendererComponent)tabContent).getRenderContext() != reportRenderContext) continue;
                    index = i;
                    editorPanes.removeTabAt(index);
                    removedTab = true;
                    myReportRenderer.dispose();
                    break;
                }
                if (!removedTab) {
                    editorPanes.removeTabAt(index);
                }
                if (editorPanes.getTabCount() > 0) {
                    if (index < editorPanes.getTabCount()) {
                        editorPanes.setSelectedIndex(index);
                    } else {
                        editorPanes.setSelectedIndex(editorPanes.getTabCount() - 1);
                    }
                }
            }
            ReportDesignerFrame.this.recomputeAllTabTitles();
            ReportDesignerFrame.this.rebuildReportMenu();
        }
    }

    private class StatusTextHandler
    implements PropertyChangeListener {
        private StatusTextHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportDesignerFrame.this.getStatusBar().setGeneralInfoText(ReportDesignerFrame.this.getContext().getStatusText());
        }
    }

    private class ReportTabActivationHandler
    implements ChangeListener,
    PropertyChangeListener {
        private ReportTabActivationHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportDesignerDocumentContext activeContext = ReportDesignerFrame.this.getContext().getActiveDocument();
            JTabbedPane editorPanes = ReportDesignerFrame.this.getReportEditorPane();
            int i = this.findTabForContext(activeContext);
            if (i != -1 && editorPanes.getSelectedIndex() != i) {
                editorPanes.setSelectedIndex(i);
            }
            ReportDesignerFrame.this.updateFrameTitle();
        }

        private int findTabForContext(ReportDesignerDocumentContext activeContext) {
            JTabbedPane editorPanes = ReportDesignerFrame.this.getReportEditorPane();
            int count = editorPanes.getTabCount();
            for (int i = 0; i < count; ++i) {
                ReportRendererComponent rrc;
                Component c = editorPanes.getComponentAt(i);
                if (!(c instanceof ReportRendererComponent) || (rrc = (ReportRendererComponent)c).getRenderContext() != activeContext) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane editorPanes = ReportDesignerFrame.this.getReportEditorPane();
            DefaultReportDesignerContext context = ReportDesignerFrame.this.getContext();
            if (editorPanes.getTabCount() == 0) {
                context.setActiveDocument((ReportDesignerDocumentContext)null);
                return;
            }
            int index = editorPanes.getSelectedIndex();
            if (index == -1 || !(editorPanes.getComponentAt(index) instanceof ReportRendererComponent)) {
                context.setActiveDocument((ReportDesignerDocumentContext)null);
            } else {
                ReportRendererComponent rendererComponent = (ReportRendererComponent)editorPanes.getComponentAt(index);
                ReportDocumentContext rendererContext = rendererComponent.getRenderContext();
                for (int i = 0; i < context.getReportRenderContextCount(); ++i) {
                    ReportRenderContext context1 = context.getReportRenderContext(i);
                    if (context1 != rendererContext) continue;
                    context.setActiveDocument((ReportDesignerDocumentContext)rendererContext);
                    rendererContext.onDocumentActivated();
                    return;
                }
                if (context.getReportRenderContextCount() > 0) {
                    context.setActiveDocument((ReportDesignerDocumentContext)context.getReportRenderContext(context.getReportRenderContextCount() - 1));
                } else {
                    context.setActiveDocument((ReportDesignerDocumentContext)null);
                }
            }
        }
    }

    private class WindowCloseHandler
    extends WindowAdapter {
        private WindowCloseHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            QuitAction quitAction = new QuitAction();
            quitAction.setReportDesignerContext(ReportDesignerFrame.this.context);
            quitAction.actionPerformed(new ActionEvent(this, 0, "quit", 0));
        }
    }

    private static class ScrollbarSyncHandler
    extends ComponentAdapter {
        private final JScrollBar theVerticalScrollBar;
        private final JToolBar toolBar;

        public ScrollbarSyncHandler(JScrollBar theVerticalScrollBar, JToolBar toolBar) {
            this.theVerticalScrollBar = theVerticalScrollBar;
            this.toolBar = toolBar;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.theVerticalScrollBar.isShowing()) {
                this.toolBar.setBorder(BorderFactory.createEmptyBorder(25, 0, 0, 19));
            } else {
                this.toolBar.setBorder(BorderFactory.createEmptyBorder(25, 0, 0, 4));
            }
        }
    }

    public class DefaultDropTargetListener
    extends DropTargetAdapter {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            DropTarget dropTarget = (DropTarget)dtde.getSource();
            dropTarget.getComponent().setCursor(DragSource.DefaultCopyNoDrop);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DropTarget dropTarget = (DropTarget)dte.getSource();
            dropTarget.getComponent().setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropTarget dropTarget = (DropTarget)dtde.getSource();
            dropTarget.getComponent().setCursor(Cursor.getDefaultCursor());
            dtde.rejectDrop();
        }
    }
}

