/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.dnd.InsertationUtil;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;

public class CutAction
extends AbstractElementSelectionAction {
    public CutAction() {
        this.putValue("Name", ActionMessages.getString("CutAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("CutAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("CutAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getCutIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("CutAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        ReportDocumentContext activeContext = this.getActiveContext();
        Object[] selectedElements = selectionModel1.getSelectedElements();
        if (selectedElements.length == 0) {
            return;
        }
        ArrayList<Object> preparedElements = new ArrayList<Object>(selectedElements.length);
        ArrayList<UndoEntry> undoEntries = new ArrayList<UndoEntry>(selectedElements.length);
        try {
            for (int i = 0; i < selectedElements.length; ++i) {
                UndoEntry undoEntry;
                Object selectedElement = selectedElements[i];
                Object preparedElement = InsertationUtil.prepareForCopy(activeContext, selectedElement);
                if (preparedElement == null || (undoEntry = InsertationUtil.delete(activeContext, selectedElement)) == null) continue;
                preparedElements.add(preparedElement);
                undoEntries.add(undoEntry);
            }
            ClipboardManager.getManager().setContents(preparedElements.toArray());
        }
        finally {
            activeContext.getUndo().addChange(ActionMessages.getString("CutAction.Text", new Object[0]), new CompoundUndoEntry(undoEntries.toArray(new UndoEntry[undoEntries.size()])));
        }
    }
}

