/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import org.apache.log4j.LogManager;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.report.CloseReportAction;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.libraries.designtime.swing.ConsumableActionEvent;

public class QuitAction
extends AbstractDesignerContextAction {
    public QuitAction() {
        this.putValue("Name", ActionMessages.getString("QuitAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("QuitAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("QuitAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("QuitAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext context = this.getReportDesignerContext();
        WorkspaceSettings theWorkspaceSettings = WorkspaceSettings.getInstance();
        theWorkspaceSettings.setBounds(context.getView().getParent().getBounds());
        int contextCount = context.getReportRenderContextCount();
        ReportRenderContext[] contextArray = new ReportRenderContext[contextCount];
        for (int i = 0; i < contextCount; ++i) {
            contextArray[i] = context.getReportRenderContext(i);
        }
        ReportRenderContext[] filteredArray = CloseReportAction.filterSubreports(this.getReportDesignerContext(), contextArray);
        for (int i = 0; i < filteredArray.length; ++i) {
            ReportRenderContext reportRenderContext = filteredArray[i];
            if (CloseReportAction.performCloseReport(this.getReportDesignerContext(), reportRenderContext)) continue;
            return;
        }
        if (e instanceof ConsumableActionEvent) {
            ConsumableActionEvent ce = (ConsumableActionEvent)e;
            ce.consume();
        }
        LogManager.shutdown();
        System.exit(0);
    }
}

