/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.bundle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.bundle.CreateBundleFileDialog;
import org.pentaho.reporting.designer.core.editor.bundle.ImportBundleFileDialog;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.TextAreaPropertyEditorDialog;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringBufferWriter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;

public class BundledResourceEditor
extends JDialog {
    private ReportDesignerContext designerContext;
    private CreateFileAction createFileAction;
    private ImportFileAction importFileAction;
    private EditFileAction editFileAction;
    private RemoveFileAction removeFileAction;
    private DefaultListModel fileModel;
    private ExportFileAction exportFileAction;
    private JList resourceList;
    private boolean changed;
    private WriteableDocumentBundle bundle;

    public BundledResourceEditor(ReportDesignerContext designerContext) throws HeadlessException {
        this.init(designerContext);
    }

    public BundledResourceEditor(Frame owner, ReportDesignerContext designerContext) throws HeadlessException {
        super(owner);
        this.init(designerContext);
    }

    public BundledResourceEditor(Dialog owner, ReportDesignerContext designerContext) throws HeadlessException {
        super(owner);
        this.init(designerContext);
    }

    private void init(ReportDesignerContext designerContext) {
        if (designerContext == null) {
            throw new NullPointerException();
        }
        this.designerContext = designerContext;
        this.setModal(true);
        this.setTitle(Messages.getString("BundledResourceEditor.ResourceEditor", new Object[0]));
        this.setDefaultCloseOperation(2);
        this.createFileAction = new CreateFileAction();
        this.importFileAction = new ImportFileAction();
        this.editFileAction = new EditFileAction();
        this.editFileAction.setEnabled(false);
        this.removeFileAction = new RemoveFileAction();
        this.removeFileAction.setEnabled(false);
        this.exportFileAction = new ExportFileAction();
        this.exportFileAction.setEnabled(false);
        this.fileModel = new DefaultListModel();
        this.resourceList = new JList(this.fileModel);
        this.resourceList.setSelectionMode(0);
        this.resourceList.setVisibleRowCount(10);
        this.resourceList.addListSelectionListener(new FileSelectionHandler());
        JPanel editorButtonsPanel = new JPanel();
        editorButtonsPanel.setLayout(new GridLayout(5, 1, 5, 5));
        editorButtonsPanel.add(new JButton(this.createFileAction));
        editorButtonsPanel.add(new JButton(this.importFileAction));
        editorButtonsPanel.add(new JButton(this.editFileAction));
        editorButtonsPanel.add(new JButton(this.removeFileAction));
        editorButtonsPanel.add(new JButton(this.exportFileAction));
        JPanel editorButtonCarrier = new JPanel();
        editorButtonCarrier.setLayout(new BorderLayout());
        editorButtonCarrier.add((Component)editorButtonsPanel, "North");
        JPanel bottomButtonCarrier = new JPanel();
        bottomButtonCarrier.setLayout(new FlowLayout(4));
        bottomButtonCarrier.add(new JButton(new CloseAction()));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)new JScrollPane(this.resourceList), "Center");
        contentPane.add((Component)editorButtonCarrier, "East");
        contentPane.add((Component)bottomButtonCarrier, "South");
        this.setContentPane(contentPane);
        this.pack();
        LibSwingUtil.centerDialogInParent((Dialog)this);
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", new CloseAction());
    }

    public String getSelectedEntry() {
        return (String)this.resourceList.getSelectedValue();
    }

    public boolean editResources() {
        ReportDocumentContext activeContext = this.designerContext.getActiveContext();
        if (activeContext == null) {
            throw new IllegalStateException();
        }
        this.bundle = (WriteableDocumentBundle)((MasterReport)activeContext.getContextRoot()).getBundle();
        this.refreshBundleList();
        this.changed = false;
        this.setModal(true);
        this.setVisible(true);
        return this.changed;
    }

    private void refreshBundleList() {
        WriteableDocumentMetaData metaData = this.bundle.getWriteableDocumentMetaData();
        ArrayList<String> entries = new ArrayList<String>();
        String[] manifestEntryNames = metaData.getManifestEntryNames();
        for (int i = 0; i < manifestEntryNames.length; ++i) {
            String manifestEntryName = manifestEntryNames[i];
            String stickyFlag = metaData.getEntryAttribute(manifestEntryName, "sticky");
            String hiddenFlag = metaData.getEntryAttribute(manifestEntryName, "hidden");
            if (!"true".equals(stickyFlag) || "true".equals(hiddenFlag)) continue;
            entries.add(manifestEntryName);
        }
        Collections.sort(entries);
        this.fileModel.clear();
        int length = entries.size();
        for (int i = 0; i < length; ++i) {
            this.fileModel.addElement(entries.get(i));
        }
    }

    private class FileSelectionHandler
    implements ListSelectionListener {
        private FileSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean enable = !BundledResourceEditor.this.resourceList.isSelectionEmpty();
            BundledResourceEditor.this.removeFileAction.setEnabled(enable);
            BundledResourceEditor.this.exportFileAction.setEnabled(enable);
            if (!enable) {
                BundledResourceEditor.this.editFileAction.setEnabled(enable);
            } else {
                String s = BundledResourceEditor.this.getSelectedEntry();
                if (s == null) {
                    return;
                }
                if ("text/plain".equals(BundledResourceEditor.this.bundle.getEntryMimeType(s)) || s.endsWith(".properties")) {
                    BundledResourceEditor.this.editFileAction.setEnabled(true);
                } else {
                    BundledResourceEditor.this.editFileAction.setEnabled(false);
                }
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
            this.putValue("Name", Messages.getString("BundledResourceEditor.Close", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BundledResourceEditor.this.dispose();
        }
    }

    private class CreateFileAction
    extends AbstractAction {
        private CreateFileAction() {
            this.putValue("Name", "Create");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CreateBundleFileDialog dialog = new CreateBundleFileDialog(BundledResourceEditor.this);
            if (!dialog.performCreateEntry((DocumentBundle)BundledResourceEditor.this.bundle)) {
                return;
            }
            String fileEntryName = dialog.getFileName();
            if (StringUtils.isEmpty((String)fileEntryName)) {
                return;
            }
            try {
                OutputStream outputStream = BundledResourceEditor.this.bundle.createEntry(fileEntryName, dialog.getMimeType());
                outputStream.close();
                BundledResourceEditor.this.bundle.getWriteableDocumentMetaData().setEntryAttribute(fileEntryName, "sticky", "true");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            BundledResourceEditor.this.changed = true;
            BundledResourceEditor.this.refreshBundleList();
        }
    }

    private class EditFileAction
    extends AbstractAction {
        private EditFileAction() {
            this.putValue("Name", Messages.getString("BundledResourceEditor.Edit", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedEntry = BundledResourceEditor.this.getSelectedEntry();
            if (selectedEntry == null) {
                return;
            }
            String mimeType = BundledResourceEditor.this.bundle.getEntryMimeType(selectedEntry);
            StringBufferWriter w = new StringBufferWriter(new StringBuffer());
            try {
                InputStream stream = BundledResourceEditor.this.bundle.getEntryAsStream(selectedEntry);
                try {
                    InputStreamReader r = new InputStreamReader(stream, "ISO-8859-1");
                    IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            TextAreaPropertyEditorDialog editorDialog = new TextAreaPropertyEditorDialog(BundledResourceEditor.this);
            String originalValue = w.getBuffer().toString();
            String editedValue = editorDialog.performEdit(originalValue);
            if (ObjectUtilities.equal((Object)originalValue, (Object)editedValue)) {
                return;
            }
            try {
                BundledResourceEditor.this.bundle.removeEntry(selectedEntry);
                OutputStream outputStream = BundledResourceEditor.this.bundle.createEntry(selectedEntry, mimeType);
                try {
                    outputStream.write(editedValue.getBytes("ISO-8859-1"));
                }
                finally {
                    outputStream.close();
                }
                BundledResourceEditor.this.bundle.getWriteableDocumentMetaData().setEntryAttribute(selectedEntry, "sticky", "true");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            BundledResourceEditor.this.changed = true;
        }
    }

    private class RemoveFileAction
    extends AbstractAction {
        private RemoveFileAction() {
            this.putValue("Name", Messages.getString("BundledResourceEditor.Remove", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedEntry = BundledResourceEditor.this.getSelectedEntry();
            if (selectedEntry == null) {
                return;
            }
            try {
                BundledResourceEditor.this.bundle.removeEntry(selectedEntry);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            BundledResourceEditor.this.changed = true;
            BundledResourceEditor.this.refreshBundleList();
        }
    }

    private class ExportFileAction
    extends AbstractAction {
        private ExportFileAction() {
            this.putValue("Name", Messages.getString("BundledResourceEditor.Export", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String entryName = BundledResourceEditor.this.getSelectedEntry();
            FileFilter[] filters = new FileFilter[]{new FilesystemFilter(".properties", Messages.getString("BundledResourceEditor.PropertiesTranslations", new Object[0])), new FilesystemFilter(new String[]{".xml", ".report", ".prpt", ".prpti", ".prptstyle"}, Messages.getString("BundledResourceEditor.Resources", new Object[0]), true), new FilesystemFilter(new String[]{".gif", ".jpg", ".jpeg", ".png", ".svg", ".wmf"}, Messages.getString("BundledResourceEditor.Images", new Object[0]), true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("resources");
            fileChooser.setFilters(filters);
            if (!fileChooser.showDialog((Component)BundledResourceEditor.this, 0)) {
                return;
            }
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            try {
                FileOutputStream fout = new FileOutputStream(selectedFile);
                try {
                    InputStream inputStream = BundledResourceEditor.this.bundle.getEntryAsStream(entryName);
                    try {
                        IOUtils.getInstance().copyStreams(inputStream, (OutputStream)fout);
                    }
                    finally {
                        inputStream.close();
                    }
                    BundledResourceEditor.this.bundle.getWriteableDocumentMetaData().setEntryAttribute(entryName, "sticky", "true");
                }
                finally {
                    fout.close();
                }
            }
            catch (IOException ioe) {
                UncaughtExceptionsModel.getInstance().addException(ioe);
            }
            BundledResourceEditor.this.changed = true;
        }
    }

    private class ImportFileAction
    extends AbstractAction {
        private ImportFileAction() {
            this.putValue("Name", Messages.getString("BundledResourceEditor.Import", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            ImportBundleFileDialog dialog = new ImportBundleFileDialog(BundledResourceEditor.this);
            if (!dialog.performCreateEntry((DocumentBundle)BundledResourceEditor.this.bundle)) {
                return;
            }
            String entryName = dialog.getEntryName();
            String fileName = dialog.getFileName();
            String mimeType = dialog.getMimeType();
            try {
                FileInputStream fin = new FileInputStream(fileName);
                try {
                    OutputStream outputStream = BundledResourceEditor.this.bundle.createEntry(entryName, mimeType);
                    try {
                        IOUtils.getInstance().copyStreams((InputStream)fin, outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                    BundledResourceEditor.this.bundle.getWriteableDocumentMetaData().setEntryAttribute(entryName, "sticky", "true");
                }
                finally {
                    fin.close();
                }
            }
            catch (IOException ioe) {
                UncaughtExceptionsModel.getInstance().addException(ioe);
            }
            BundledResourceEditor.this.changed = true;
            BundledResourceEditor.this.refreshBundleList();
        }
    }
}

