/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.DropMode;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDialogTransferHandler;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabDimensionTableModel;
import org.pentaho.reporting.designer.core.editor.crosstab.FieldDragSupport;
import org.pentaho.reporting.designer.core.editor.crosstab.IndexedTransferable;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTable;

public class DraggableCrosstabDimensionTable
extends PropertyTable
implements FieldDragSupport {
    private UUID dragId;
    private CrosstabDimensionTableModel dataModel;

    public DraggableCrosstabDimensionTable(CrosstabDimensionTableModel dm) {
        super((TableModel)dm);
        this.dataModel = dm;
        this.dragId = UUID.randomUUID();
        this.setTransferHandler(new CrosstabDialogTransferHandler(this));
        this.setDragEnabled(true);
        this.setFillsViewportHeight(true);
        this.setDropMode(DropMode.INSERT_ROWS);
    }

    @Override
    public UUID getDragId() {
        return this.dragId;
    }

    @Override
    public void removeValues(List<IndexedTransferable.FieldTuple> fields) {
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (IndexedTransferable.FieldTuple field : fields) {
            indexes.add(field.getIndex());
        }
        ArrayList l = new ArrayList(indexes);
        Collections.reverse(l);
        for (Integer index : indexes) {
            this.dataModel.remove(index);
        }
    }

    @Override
    public List<IndexedTransferable.FieldTuple> getSelectedFields() {
        int[] selectedValues = this.getSelectedRows();
        ArrayList<IndexedTransferable.FieldTuple> retval = new ArrayList<IndexedTransferable.FieldTuple>();
        for (int idx : selectedValues) {
            CrosstabDimension dimension = this.dataModel.get(idx);
            retval.add(new IndexedTransferable.FieldTuple(idx, dimension.getField(), dimension.getTitle(), dimension));
        }
        return retval;
    }

    private boolean containsField(String field) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!field.equals(this.dataModel.get(i).getField())) continue;
            return true;
        }
        return false;
    }

    private CrosstabDimension toDimension(IndexedTransferable.FieldTuple tuple) {
        Object raw = tuple.getRaw();
        if (raw instanceof CrosstabDimension) {
            CrosstabDimension rawDimension = (CrosstabDimension)raw;
            return rawDimension.clone();
        }
        return new CrosstabDimension(tuple.getValue(), tuple.getTitle());
    }

    @Override
    public void insert(TransferHandler.DropLocation dropLocation, List<IndexedTransferable.FieldTuple> items, boolean preventDuplicates) {
        int idx = this.findInsertIndex(dropLocation);
        if (idx == -1) {
            for (int i = 0; i < items.size(); ++i) {
                IndexedTransferable.FieldTuple tuple = items.get(i);
                String value = tuple.getValue();
                if (preventDuplicates && this.containsField(value)) continue;
                this.dataModel.add(this.toDimension(tuple));
            }
        } else {
            for (int i = items.size() - 1; i >= 0; --i) {
                IndexedTransferable.FieldTuple tuple = items.get(i);
                String value = tuple.getValue();
                if (preventDuplicates && this.containsField(value)) continue;
                this.dataModel.add(idx, this.toDimension(tuple));
            }
        }
    }

    private int findInsertIndex(TransferHandler.DropLocation dropLocation) {
        if (dropLocation instanceof JTable.DropLocation) {
            JTable.DropLocation dl = (JTable.DropLocation)dropLocation;
            return dl.getRow();
        }
        return this.rowAtPoint(dropLocation.getDropPoint());
    }
}

