/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.designer.core.ReportDesignerBoot;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownEditor;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DrillDownUiProfileRegistry {
    private static DrillDownUiProfileRegistry instance;
    private HashMap<String, DrillDownUiProfile> registry = new HashMap();
    private static final String PREFIX = "org.pentaho.reporting.designer.core.editor.drilldown.profiles.";

    public static synchronized DrillDownUiProfileRegistry getInstance() {
        if (instance == null) {
            instance = new DrillDownUiProfileRegistry();
            instance.initialize();
        }
        return instance;
    }

    private DrillDownUiProfileRegistry() {
    }

    public void addProfile(String name, DrillDownUiProfile profile) {
        if (profile == null) {
            throw new NullPointerException();
        }
        this.registry.put(name, profile);
    }

    public void initialize() {
        Configuration configuration = ReportDesignerBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys(PREFIX);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String name = key.substring(PREFIX.length());
            String className = configuration.getConfigProperty(key);
            if (className == null) {
                DebugLog.log((Object)("No such profile: " + key));
                continue;
            }
            DrillDownUiProfile profile = (DrillDownUiProfile)ObjectUtilities.loadAndInstantiate((String)className, DrillDownEditor.class, DrillDownUiProfile.class);
            if (profile == null) {
                DebugLog.log((Object)("Invalid profile: " + key));
                continue;
            }
            this.addProfile(name, profile);
        }
    }

    public DrillDownUiProfile getProfile(String name) {
        return this.registry.get(name);
    }

    public DrillDownUiProfile[] getProfiles() {
        return this.registry.values().toArray(new DrillDownUiProfile[this.registry.size()]);
    }

    public int getProfileCount() {
        return this.registry.size();
    }
}

