/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.expressions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionPropertiesTableModel;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellRenderer;
import org.pentaho.reporting.designer.core.util.table.SortHeaderPanel;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class ExpressionPropertiesEditorPanel
extends SidePanel {
    private ExpressionPropertiesTableModel dataModel;
    private ElementMetaDataTable table;
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private SortHeaderPanel headerPanel;

    public ExpressionPropertiesEditorPanel() {
        this.setLayout(new BorderLayout());
        this.dataModel = new ExpressionPropertiesTableModel();
        this.table = new ElementMetaDataTable();
        this.table.setModel(new GroupedMetaTableModel(this.dataModel));
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GroupedNameCellRenderer());
        this.headerPanel = new SortHeaderPanel(this.dataModel);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public Expression[] getData() {
        return this.dataModel.getData();
    }

    public void setData(Expression[] elements) {
        this.stopEditing();
        this.dataModel.setData(elements);
    }

    public void stopEditing() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        this.table.setReportDesignerContext(newContext);
    }

    @Override
    protected void updateSelection(DocumentContextSelectionModel model) {
        if (model == null) {
            this.setData(EMPTY_EXPRESSIONS);
        } else {
            List<Expression> filter = model.getSelectedElementsOfType(Expression.class);
            this.setData(filter.toArray(new Expression[filter.size()]));
        }
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        this.stopEditing();
        super.updateActiveContext(oldContext, newContext);
        this.dataModel.setActiveContext(newContext);
        if (newContext == null) {
            this.setData(EMPTY_EXPRESSIONS);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.headerPanel.setEnabled(enabled);
    }
}

