/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.OverlayRenderer;
import org.pentaho.reporting.designer.core.editor.report.SelectionOverlayInformation;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;

public class SelectionOverlayRenderer
implements OverlayRenderer {
    private Section rootElement;
    private ReportDocumentContext context;
    private double zoomFactor;
    private double offset;

    public SelectionOverlayRenderer(Element defaultElement) {
        if (defaultElement instanceof Section) {
            this.rootElement = (Section)defaultElement;
        }
    }

    @Override
    public void validate(ReportDocumentContext context, double zoomFactor, Point2D sectionOffset) {
        this.offset = sectionOffset.getY();
        this.context = context;
        this.zoomFactor = zoomFactor;
    }

    @Override
    public void draw(Graphics2D graphics, Rectangle2D bounds, ImageObserver obs) {
        if (this.context == null || this.rootElement == null) {
            return;
        }
        graphics.translate(bounds.getX(), -(this.offset * this.zoomFactor));
        for (Element visualElement : this.context.getSelectionModel().getSelectedElementsOfType(Element.class)) {
            Object o;
            if (!ModelUtility.isDescendant(this.rootElement, (ReportElement)visualElement) || !((o = visualElement.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "selection-overlay-information")) instanceof SelectionOverlayInformation)) continue;
            SelectionOverlayInformation information = (SelectionOverlayInformation)o;
            information.validate(this.zoomFactor);
            information.draw(graphics, obs);
        }
    }
}

