/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.lineal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.report.lineal.AddHorizontalGuidelinesUndoEntry;
import org.pentaho.reporting.designer.core.editor.report.lineal.RemoveHorizontalGuidelineUndoEntry;
import org.pentaho.reporting.designer.core.editor.report.lineal.UpdateHorizontalGuidelineUndoEntry;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.lineal.GuideLine;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelEvent;
import org.pentaho.reporting.designer.core.model.lineal.LinealModelListener;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.CanvasImageLoader;
import org.pentaho.reporting.designer.core.util.GuideLineDialog;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class HorizontalLinealComponent
extends JPanel {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0##");
    public static final DecimalFormat DECIMAL_FORMAT_NUMBERS_ONE_DIGIT = new DecimalFormat("0.0");
    public static final DecimalFormat DECIMAL_FORMAT_NUMBERS_INTEGER = new DecimalFormat("0");
    private LinealModel linealModel;
    private int activeGuideLineIndex;
    private boolean showLeftBorder;
    private PageDefinition pageDefinition;
    private ReportDocumentContext renderContext;
    private LinealUpdateHandler linealModelListener;

    public HorizontalLinealComponent(ReportRenderContext renderContext, boolean showLeftBorder) {
        if (renderContext == null) {
            throw new NullPointerException();
        }
        this.renderContext = renderContext;
        ((MasterReport)this.renderContext.getContextRoot()).addReportModelListener((ReportModelListener)new PageFormatUpdateHandler());
        this.linealModelListener = new LinealUpdateHandler();
        this.showLeftBorder = showLeftBorder;
        DragnDropHandler dndHandler = new DragnDropHandler();
        this.addMouseListener(dndHandler);
        this.addMouseMotionListener(dndHandler);
        this.addMouseListener(new GuideLinePopupHandler());
        WorkspaceSettings.getInstance().addSettingsListener(new UnitSettingsListener());
        this.refresh();
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    protected void refresh() {
        if (this.linealModel != null) {
            this.linealModel.removeLinealModelListener(this.linealModelListener);
        }
        this.pageDefinition = ((MasterReport)this.renderContext.getContextRoot()).getPageDefinition();
        AbstractReportDefinition abstractReportDefinition = this.renderContext.getReportDefinition();
        this.linealModel = ModelUtility.getHorizontalLinealModel(abstractReportDefinition);
        this.linealModel.addLinealModelListener(this.linealModelListener);
        this.revalidate();
        this.repaint();
    }

    protected void tryShowPopup(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        double start = 0.0;
        if (this.pageDefinition == null) {
            return;
        }
        if (this.showLeftBorder) {
            start = this.getLeftBorder();
        }
        GuideLine[] guideLines = this.linealModel.getGuideLines();
        for (int i = 0; i < guideLines.length; ++i) {
            GuideLine guideLine = guideLines[i];
            int x = (int)((guideLine.getPosition() + start) * (double)this.getZoomAsMicropoints());
            if (x > me.getX() + 2 || x < me.getX() - 2) continue;
            JPopupMenu popupMenu = this.createPopupMenu(guideLine, i);
            popupMenu.show(this, me.getX(), me.getY());
            break;
        }
    }

    private JPopupMenu createPopupMenu(GuideLine guideLine, int index) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new LinealPropertiesAction(guideLine, index));
        if (guideLine.isActive()) {
            popupMenu.add(new DeactivateGuidelineAction(guideLine, index));
        } else {
            popupMenu.add(new ActivateGuidelineAction(guideLine, index));
        }
        popupMenu.add(new DeleteGuidelineAction(guideLine));
        return popupMenu;
    }

    protected int getActiveGuideIndex(MouseEvent e) {
        if (this.pageDefinition == null) {
            this.setToolTipText(null);
            return -1;
        }
        GuideLine[] lines = this.linealModel.getGuideLines();
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        for (int i = 0; i < lines.length; ++i) {
            int x;
            GuideLine guideLine = lines[i];
            double start = 0.0;
            if (this.showLeftBorder) {
                start = this.getLeftBorder();
            }
            if ((x = (int)((guideLine.getPosition() + start) * (double)this.getZoomAsMicropoints())) > e.getX() + 2 || x < e.getX() - 2) continue;
            double unitValue = unit.convertFromPoints(guideLine.getPosition());
            this.setToolTipText(DECIMAL_FORMAT.format(unitValue));
            return i;
        }
        this.setToolTipText(null);
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.pageDefinition != null) {
            double end = this.pageDefinition.getWidth();
            end += this.getLeftBorder();
            return new Dimension((int)((end += this.getRightBorder()) * (double)this.getZoomAsMicropoints()), 15);
        }
        return new Dimension(0, 15);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.pageDefinition == null) {
            return;
        }
        double start = this.getLeftBorder();
        float scaleFactor = this.getZoomAsMicropoints();
        double end = this.pageDefinition.getWidth();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, (int)(((end += this.getLeftBorder()) - start) * (double)scaleFactor), this.getHeight());
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(0, 0, 0, this.getHeight() - 1);
        g.drawLine(0, this.getHeight() - 1, (int)((end - start) * (double)scaleFactor), this.getHeight() - 1);
        ImageIcon rightBorder = CanvasImageLoader.getInstance().getRightShadowImage();
        g.drawImage(rightBorder.getImage(), (int)((end - start) * (double)scaleFactor), 0, rightBorder.getIconWidth(), this.getHeight(), null);
        this.drawGuideLines(g);
        this.drawDots(g, start, end);
        this.drawNumbers(g, start, end);
    }

    protected double getLeftBorder() {
        if (this.pageDefinition == null) {
            return 0.0;
        }
        if (!this.isShowLeftBorder()) {
            return 0.0;
        }
        PageFormat pageFormat = this.pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getLeftBorder(pageFormat.getPaper());
    }

    protected double getRightBorder() {
        if (this.pageDefinition == null) {
            return 0.0;
        }
        PageFormat pageFormat = this.pageDefinition.getPageFormat(0);
        PageFormatFactory pageFormatFactory = PageFormatFactory.getInstance();
        return pageFormatFactory.getRightBorder(pageFormat.getPaper());
    }

    private void drawGuideLines(Graphics g) {
        GuideLine[] guideLines = this.linealModel.getGuideLines();
        double startOffset = 0.0;
        if (this.showLeftBorder) {
            startOffset = this.getLeftBorder();
        }
        Color guideColor = WorkspaceSettings.getInstance().getGuideColor();
        Color guideFill = ColorUtility.convertToGray((Color)guideColor, (float)0.3f);
        Color guideHighlight = ColorUtility.convertToDarker((Color)guideFill);
        Color disabledGuideColor = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideColor, (float)0.0f));
        Color disabledGuideFill = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideFill, (float)0.0f));
        Color disabledHighlightGuide = ColorUtility.convertToDarker((Color)ColorUtility.convertToGray((Color)guideHighlight, (float)0.0f));
        float scaleFactor = this.getZoomAsMicropoints();
        int so = (int)(startOffset * (double)scaleFactor);
        for (GuideLine guideLine : guideLines) {
            int x = (int)(guideLine.getPosition() * (double)scaleFactor) + so;
            if (guideLine.isActive()) {
                g.setColor(guideFill);
            } else {
                g.setColor(disabledGuideFill);
            }
            g.fillRect(x - 2, 1, 4, 13);
            if (guideLine.isActive()) {
                g.setColor(guideColor);
            } else {
                g.setColor(disabledGuideColor);
            }
            g.drawRect(x - 2, 0, 4, 14);
        }
        g.setColor(Color.BLUE);
        GuideLine highlightGuideLine = this.getActiveGuidLine();
        if (highlightGuideLine != null) {
            int x = (int)(highlightGuideLine.getPosition() * (double)scaleFactor) + so;
            if (highlightGuideLine.isActive()) {
                g.setColor(guideFill);
            } else {
                g.setColor(disabledGuideFill);
            }
            g.fillRect(x - 2, 1, 4, 13);
            if (highlightGuideLine.isActive()) {
                g.setColor(guideHighlight);
            } else {
                g.setColor(disabledHighlightGuide);
            }
            g.drawRect(x - 2, 0, 4, 14);
        }
    }

    private void drawDots(Graphics g, double start, double end) {
        g.setColor(Color.GRAY);
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        float scaleFactor = this.getZoomAsMicropoints();
        double factorForUnitAndScale = unit.getTickSize(scaleFactor);
        double increment = unit.getDotsPerUnit() * factorForUnitAndScale;
        for (double i = start + increment / 2.0; i < end; i += increment) {
            int x = (int)(i * (double)scaleFactor);
            g.drawLine(x, 7, x, 9);
        }
    }

    private void drawNumbers(Graphics g, double start, double end) {
        float scaleFactor = this.getZoomAsMicropoints();
        Unit unit = WorkspaceSettings.getInstance().getUnit();
        double factorForUnitAndScale = unit.getTickSize(scaleFactor);
        double increment = unit.getDotsPerUnit() * factorForUnitAndScale;
        DecimalFormat df = DECIMAL_FORMAT_NUMBERS_INTEGER;
        if (factorForUnitAndScale < 1.0) {
            df = DECIMAL_FORMAT_NUMBERS_ONE_DIGIT;
        }
        g.setColor(Color.BLACK);
        double number = 0.0;
        for (double i = start; i < end - increment / 2.0; i += increment) {
            int x = (int)(i * (double)scaleFactor);
            if (number > 0.0) {
                String s = df.format(number);
                Rectangle2D sb = g.getFontMetrics().getStringBounds(s, g);
                g.drawString(s, (int)(sb.getX() - sb.getWidth() / 2.0 + (double)x), (int)(-sb.getY()));
            }
            number += factorForUnitAndScale;
        }
    }

    public LinealModel getLinealModel() {
        return this.linealModel;
    }

    public float getZoomAsMicropoints() {
        return this.renderContext.getZoomModel().getZoomAsPercentage();
    }

    protected void updateGuidelineHighlight(MouseEvent e) {
        int agIndex = this.getActiveGuideIndex(e);
        int oldIndex = this.activeGuideLineIndex;
        this.activeGuideLineIndex = agIndex == -1 ? -1 : agIndex;
        if (this.activeGuideLineIndex != oldIndex) {
            this.repaint();
        }
    }

    protected GuideLine getActiveGuidLine() {
        int lineCount = this.linealModel.getGuideLineCount();
        if (this.activeGuideLineIndex != -1 && this.activeGuideLineIndex < lineCount) {
            return this.linealModel.getGuideLine(this.activeGuideLineIndex);
        }
        return null;
    }

    protected int getActiveGuideLineIndex() {
        return this.activeGuideLineIndex;
    }

    protected void setActiveGuideLineIndex(int activeGuideLineIndex) {
        this.activeGuideLineIndex = activeGuideLineIndex;
    }

    protected ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    protected boolean isShowLeftBorder() {
        return this.showLeftBorder;
    }

    public void setShowLeftBorder(boolean showLeftBorder) {
        this.showLeftBorder = showLeftBorder;
        this.refresh();
    }

    private class UnitSettingsListener
    implements SettingsListener {
        private UnitSettingsListener() {
        }

        @Override
        public void settingsChanged() {
            HorizontalLinealComponent.this.refresh();
        }
    }

    private class PageFormatUpdateHandler
    implements ReportModelListener {
        private PageFormatUpdateHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (event.getElement() == event.getReport()) {
                HorizontalLinealComponent.this.refresh();
            }
        }
    }

    private class GuideLinePopupHandler
    extends MouseAdapter {
        private GuideLinePopupHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            HorizontalLinealComponent.this.updateGuidelineHighlight(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (HorizontalLinealComponent.this.getActiveGuidLine() != null) {
                HorizontalLinealComponent.this.setActiveGuideLineIndex(-1);
                HorizontalLinealComponent.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            HorizontalLinealComponent.this.updateGuidelineHighlight(e);
            HorizontalLinealComponent.this.tryShowPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            HorizontalLinealComponent.this.updateGuidelineHighlight(e);
            HorizontalLinealComponent.this.tryShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            HorizontalLinealComponent.this.updateGuidelineHighlight(e);
            HorizontalLinealComponent.this.tryShowPopup(e);
        }
    }

    private class DeleteGuidelineAction
    extends AbstractAction {
        private final GuideLine guideLine;

        private DeleteGuidelineAction(GuideLine guideLine) {
            super(Messages.getString("LinealComponent.Delete", new Object[0]));
            this.guideLine = guideLine;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            UndoManager undo = HorizontalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.DeleteGuideUndoName", new Object[0]), new RemoveHorizontalGuidelineUndoEntry(this.guideLine));
            linealModel.removeGuideLine(this.guideLine);
        }
    }

    private class ActivateGuidelineAction
    extends AbstractAction {
        private final GuideLine oldGuideLine;
        private int index;

        private ActivateGuidelineAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Activate", new Object[0]));
            this.oldGuideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuideLine newGuideLine = new GuideLine(this.oldGuideLine.getPosition(), true);
            UndoManager undo = HorizontalLinealComponent.this.getRenderContext().getUndo();
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            undo.addChange(Messages.getString("LinealComponent.ActivateGuideUndoEntry", new Object[0]), new UpdateHorizontalGuidelineUndoEntry(this.index, newGuideLine, this.oldGuideLine));
            linealModel.updateGuideLine(this.index, newGuideLine);
        }
    }

    private class DeactivateGuidelineAction
    extends AbstractAction {
        private final GuideLine guideLine;
        private int index;

        private DeactivateGuidelineAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Deactivate", new Object[0]));
            this.guideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuideLine newGuideLine = new GuideLine(this.guideLine.getPosition(), false);
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            UndoManager undo = HorizontalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.DeactivateGuideUndoEntry", new Object[0]), new UpdateHorizontalGuidelineUndoEntry(this.index, newGuideLine, this.guideLine));
            linealModel.updateGuideLine(this.index, newGuideLine);
        }
    }

    private class LinealPropertiesAction
    extends AbstractAction {
        private GuideLine guideLine;
        private int index;

        private LinealPropertiesAction(GuideLine guideLine, int index) {
            super(Messages.getString("LinealComponent.Properties", new Object[0]));
            this.guideLine = guideLine;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            if (linealModel == null) {
                return;
            }
            HorizontalLinealComponent parent = HorizontalLinealComponent.this;
            Window window = LibSwingUtil.getWindowAncestor((Component)parent);
            GuideLineDialog spinnerDialog = window instanceof JDialog ? new GuideLineDialog((JDialog)window) : (window instanceof JFrame ? new GuideLineDialog((JFrame)window) : new GuideLineDialog());
            spinnerDialog.setUnit(WorkspaceSettings.getInstance().getUnit());
            spinnerDialog.setPosition(this.guideLine.getPosition());
            if (spinnerDialog.showDialog()) {
                GuideLine newGuideLine = new GuideLine(spinnerDialog.getPosition(), this.guideLine.isActive());
                linealModel.updateGuideLine(this.index, newGuideLine);
                this.guideLine = newGuideLine;
            }
        }
    }

    private class DragnDropHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int draggedGuideLineIndex;

        private DragnDropHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            PageDefinition pageDefinition = HorizontalLinealComponent.this.getPageDefinition();
            if (pageDefinition == null) {
                return;
            }
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            if (this.draggedGuideLineIndex == -1 || linealModel.getGuideLineCount() - 1 < this.draggedGuideLineIndex) {
                return;
            }
            if (this.draggedGuideLineIndex != HorizontalLinealComponent.this.getActiveGuideLineIndex()) {
                HorizontalLinealComponent.this.setActiveGuideLineIndex(this.draggedGuideLineIndex);
            }
            GuideLine dragged = linealModel.getGuideLine(this.draggedGuideLineIndex);
            double start = 0.0;
            if (HorizontalLinealComponent.this.isShowLeftBorder()) {
                start = HorizontalLinealComponent.this.getLeftBorder();
            }
            double width = pageDefinition.getWidth();
            float scaleFactor = HorizontalLinealComponent.this.getZoomAsMicropoints();
            double scaledPosition = (double)((float)e.getX() / scaleFactor) - start;
            double position = Math.min(width, Math.max(0.0, scaledPosition));
            GuideLine newGuideLine = new GuideLine(position, dragged.isActive());
            UndoManager undo = HorizontalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.ChangeGuideUndoName", new Object[0]), new UpdateHorizontalGuidelineUndoEntry(this.draggedGuideLineIndex, newGuideLine, dragged));
            linealModel.updateGuideLine(this.draggedGuideLineIndex, newGuideLine);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            HorizontalLinealComponent.this.updateGuidelineHighlight(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int activeGuideIndex;
            PageDefinition pageDefinition = HorizontalLinealComponent.this.getPageDefinition();
            if (pageDefinition == null) {
                return;
            }
            double start = 0.0;
            if (HorizontalLinealComponent.this.isShowLeftBorder()) {
                start = HorizontalLinealComponent.this.getLeftBorder();
            }
            if ((activeGuideIndex = HorizontalLinealComponent.this.getActiveGuideIndex(e)) != -1) {
                return;
            }
            LinealModel linealModel = HorizontalLinealComponent.this.getLinealModel();
            float scaleFactor = HorizontalLinealComponent.this.getZoomAsMicropoints();
            double width = pageDefinition.getWidth();
            double scaledPosition = (double)((float)e.getX() / scaleFactor) - start;
            double position = Math.min(width, Math.max(0.0, scaledPosition));
            GuideLine guideLine = new GuideLine(position, e.getButton() == 1);
            UndoManager undo = HorizontalLinealComponent.this.getRenderContext().getUndo();
            undo.addChange(Messages.getString("LinealComponent.AddGuideUndoName", new Object[0]), new AddHorizontalGuidelinesUndoEntry(guideLine));
            linealModel.addGuidLine(guideLine);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.draggedGuideLineIndex = HorizontalLinealComponent.this.getActiveGuideIndex(e);
                if (this.draggedGuideLineIndex == -1) {
                    HorizontalLinealComponent.this.setActiveGuideLineIndex(-1);
                } else {
                    HorizontalLinealComponent.this.setActiveGuideLineIndex(this.draggedGuideLineIndex);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            HorizontalLinealComponent.this.setActiveGuideLineIndex(-1);
        }
    }

    private class LinealUpdateHandler
    implements LinealModelListener {
        private LinealUpdateHandler() {
        }

        @Override
        public void modelChanged(LinealModelEvent event) {
            HorizontalLinealComponent.this.repaint();
        }
    }
}

