/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.awt.Component;
import java.awt.Image;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.structuretree.InheritedDataFactoryWrapper;
import org.pentaho.reporting.designer.core.editor.structuretree.ParentDataFactoryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFieldNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFunctionNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportParametersNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportParametersNode;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class StructureTreeCellRenderer
extends DefaultTreeCellRenderer {
    private String formatElement(Element element) {
        ElementMetaData data = element.getMetaData();
        String displayName = data.getDisplayName(Locale.getDefault());
        if (WorkspaceSettings.getInstance().isElementsDisplayNames()) {
            String name = element.getName();
            if (StringUtils.isEmpty((String)name)) {
                return displayName;
            }
            return Messages.getString("StructureTreeCellRenderer.NamedElementMessage", displayName, name);
        }
        Object field = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (field != null) {
            return Messages.getString("StructureTreeCellRenderer.NamedElementMessage", displayName, field);
        }
        Object value = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        if (value != null) {
            return Messages.getString("StructureTreeCellRenderer.NamedElementMessage", displayName, value);
        }
        Object translationKey = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier");
        if (translationKey != null) {
            return Messages.getString("StructureTreeCellRenderer.NamedElementMessage", displayName, translationKey);
        }
        Object fields = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        if (fields instanceof String[]) {
            String[] fieldsArray = (String[])fields;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < fieldsArray.length; ++i) {
                String f = fieldsArray[i];
                if (i != 0) {
                    b.append(", ");
                }
                b.append(f);
            }
            return Messages.getString("StructureTreeCellRenderer.NamedElementMessage", displayName, b.toString());
        }
        return displayName;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setToolTipText(null);
        if (value instanceof Element) {
            Element vr = (Element)value;
            ElementMetaData data = vr.getMetaData();
            this.setText(this.formatElement(vr));
            Image icon = data.getIcon(Locale.getDefault(), 2);
            if (icon != null) {
                this.setIcon(new ImageIcon(icon));
            }
            this.setToolTipText(data.getDescription(Locale.getDefault()));
        } else if (value instanceof CompoundDataFactory) {
            this.setText(Messages.getString("StructureTreeCellRenderer.DataSets", new Object[0]));
            this.setIcon(IconLoader.getInstance().getDataSetsIcon());
        } else if (value instanceof ReportEnvironmentDataRow) {
            this.setText(Messages.getString("StructureTreeCellRenderer.Environment", new Object[0]));
            this.setIcon(IconLoader.getInstance().getPropertiesDataSetIcon());
        } else if (value instanceof ReportFunctionNode) {
            this.setText(Messages.getString("StructureTreeCellRenderer.Functions", new Object[0]));
            this.setIcon(IconLoader.getInstance().getFunctionsIcon());
        } else if (value instanceof ReportParametersNode || value instanceof SubReportParametersNode) {
            this.setText(Messages.getString("StructureTreeCellRenderer.Parameters", new Object[0]));
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if (value instanceof SubReportParametersNode.ExportParametersNode) {
            this.setText(Messages.getString("StructureTreeCellRenderer.ExportParameters", new Object[0]));
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if (value instanceof SubReportParametersNode.ImportParametersNode) {
            this.setText(Messages.getString("StructureTreeCellRenderer.ImportParameters", new Object[0]));
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if (value instanceof ParameterMapping) {
            ParameterMapping mapping = (ParameterMapping)value;
            this.setText(Messages.getString("StructureTreeCellRenderer.ParameterMappingMessage", mapping.getAlias(), mapping.getName()));
            this.setIcon(IconLoader.getInstance().getParameterIcon());
        } else if (value instanceof ReportFieldNode) {
            ReportFieldNode fieldNode = (ReportFieldNode)value;
            ContextAwareDataSchemaModel model = fieldNode.getDataSchemaModel();
            DataAttributes attributes = model.getDataSchema().getAttributes(fieldNode.getFieldName());
            this.setToolTipText(fieldNode.getFieldClass().getSimpleName());
            if (attributes == null) {
                this.setText(fieldNode.toString());
            } else {
                String displayName = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", String.class, model.getDataAttributeContext());
                this.setText(this.formatFieldType(displayName, fieldNode.getFieldName(), fieldNode.getFieldClass()));
            }
        } else if (value instanceof ReportQueryNode) {
            ReportQueryNode queryNode = (ReportQueryNode)value;
            this.setText(queryNode.getQueryName());
            this.setToolTipText(queryNode.getDataFactory().getClass().getSimpleName());
        } else if (value instanceof Expression) {
            Expression expression = (Expression)value;
            if (!ExpressionRegistry.getInstance().isExpressionRegistered(expression.getClass().getName())) {
                this.setText(expression.getClass().getName());
            } else {
                ExpressionMetaData expressionMetaData = ExpressionRegistry.getInstance().getExpressionMetaData(expression.getClass().getName());
                if (expression.getName() == null) {
                    this.setText(expressionMetaData.getDisplayName(Locale.getDefault()));
                } else {
                    this.setText(Messages.getString("StructureTreeCellRenderer.NamedExpressionMessage", expressionMetaData.getDisplayName(Locale.getDefault()), expression.getName()));
                }
            }
        } else if (value instanceof ParameterDefinitionEntry) {
            ParameterDefinitionEntry params = (ParameterDefinitionEntry)value;
            this.setText(params.getName());
        } else if (value instanceof DataFactory) {
            String connectionName;
            DataFactory dfac = (DataFactory)value;
            DataFactoryMetaData data = dfac.getMetaData();
            Image image = data.getIcon(Locale.getDefault(), 2);
            if (image != null) {
                this.setIcon(new ImageIcon(image));
            }
            if ((connectionName = data.getDisplayConnectionName(dfac)) != null) {
                this.setText(Messages.getString("StructureTreeCellRenderer.NamedDataFactoryMessage", data.getDisplayName(Locale.getDefault()), connectionName));
            } else {
                this.setText(data.getDisplayName(Locale.getDefault()));
            }
        } else if (value instanceof ParentDataFactoryNode) {
            this.setText(Messages.getString("StructureTreeCellRenderer.InheritedDataFactories", new Object[0]));
        } else if (value instanceof InheritedDataFactoryWrapper) {
            InheritedDataFactoryWrapper wrapper = (InheritedDataFactoryWrapper)value;
            DataFactory dfac = wrapper.getDataFactory();
            if (!DataFactoryRegistry.getInstance().isRegistered(dfac.getClass().getName())) {
                this.setText(dfac.getClass().getSimpleName());
            } else {
                String connectionName;
                DataFactoryMetaData data = dfac.getMetaData();
                Image image = data.getIcon(Locale.getDefault(), 2);
                if (image != null) {
                    this.setIcon(new ImageIcon(image));
                }
                if ((connectionName = data.getDisplayConnectionName(dfac)) != null) {
                    this.setText(Messages.getString("StructureTreeCellRenderer.NamedDataFactoryMessage", data.getDisplayName(Locale.getDefault()), connectionName));
                } else {
                    this.setText(data.getDisplayName(Locale.getDefault()));
                }
            }
        }
        return this;
    }

    private String formatFieldType(String displayName, String fieldName, Class fieldClass) {
        if (displayName == null || ObjectUtilities.equal((Object)displayName, (Object)fieldName)) {
            if (fieldClass == null) {
                return fieldName;
            }
            return Messages.getString("StructureTreeCellRenderer.TypedElementMessage", fieldName, fieldClass.getSimpleName());
        }
        if (fieldClass == null) {
            return Messages.getString("StructureTreeCellRenderer.TypedElementMessage", displayName, fieldName);
        }
        return Messages.getString("StructureTreeCellRenderer.TypedElementMessage", displayName, fieldName, fieldClass.getSimpleName());
    }
}

