/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import java.util.Map;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.ReportDesignerDesignTimeContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ValidateableExpression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class ExpressionsParameterInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData)) continue;
                Object o = utility.getProperty(metaData.getName());
                if (!metaData.isMandatory() || o != null) continue;
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.MandatoryPropertyMissing", expression.getName(), metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
            }
            if (expression instanceof ValidateableExpression) {
                ValidateableExpression vae = (ValidateableExpression)expression;
                Map map = vae.validateParameter((DesignTimeContext)new ReportDesignerDesignTimeContext(designerContext), Locale.getDefault());
                for (Map.Entry entry : map.entrySet()) {
                    String property = (String)entry.getKey();
                    String warning = (String)entry.getValue();
                    if (property == null) {
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.ExpressionValidationError", expression.getName(), warning), new LocationInfo(expression)));
                        continue;
                    }
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.ExpressionValidationPropertyError", expression.getName(), property, warning), new PropertyLocationInfo(expression, property)));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        String expressionName = expression.getClass().getName();
        if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
            ExpressionPropertyMetaData[] datas = data.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData) || "name".equals(metaData.getName())) continue;
                Object o = utility.getProperty(metaData.getName());
                if (!metaData.isMandatory() || o != null) continue;
                AttributeMetaData attributeMetaData = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
                if (attributeMetaData == null) {
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionMandatoryPropertyMissingNoMetaData", element.getName(), attributeNamespace, attributeName, metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
                    continue;
                }
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionMandatoryPropertyMissing", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault()), metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
            }
            if (expression instanceof ValidateableExpression) {
                ValidateableExpression vae = (ValidateableExpression)expression;
                Map map = vae.validateParameter((DesignTimeContext)new ReportDesignerDesignTimeContext(designerContext), Locale.getDefault());
                for (Map.Entry entry : map.entrySet()) {
                    String property = (String)entry.getKey();
                    String warning = (String)entry.getValue();
                    AttributeMetaData attributeMetaData = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
                    if (attributeMetaData == null) {
                        if (property == null) {
                            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionValidationErrorNoMetaData", element.getName(), attributeNamespace, attributeName, warning), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
                            continue;
                        }
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionValidationPropertyErrorNoMetaData", element.getName(), attributeNamespace, attributeName, property, warning), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, property)));
                        continue;
                    }
                    if (property == null) {
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionValidationError", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault()), warning), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
                        continue;
                    }
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.AttributeExpressionValidationPropertyError", element.getName(), attributeMetaData.getDisplayName(Locale.getDefault()), property, warning), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, property)));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        String expressionName = expression.getClass().getName();
        if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
            ExpressionPropertyMetaData[] datas = data.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData) || "name".equals(metaData.getName())) continue;
                Object o = utility.getProperty(metaData.getName());
                if (!metaData.isMandatory() || o != null) continue;
                StyleMetaData description = element.getMetaData().getStyleDescription(styleKey);
                String displayName = description == null ? styleKey.getName() : description.getDisplayName(Locale.getDefault());
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("ExpressionsParameterInspection.StyleExpressionMandatoryPropertyMissing", element.getName(), displayName, metaData.getDisplayName(Locale.getDefault())), new StyleExpressionPropertyLocationInfo(element, styleKey, metaData.getName())));
            }
            if (expression instanceof ValidateableExpression) {
                ValidateableExpression vae = (ValidateableExpression)expression;
                Map map = vae.validateParameter((DesignTimeContext)new ReportDesignerDesignTimeContext(designerContext), Locale.getDefault());
                for (Map.Entry entry : map.entrySet()) {
                    String property = (String)entry.getKey();
                    String warning = (String)entry.getValue();
                    if (property == null) {
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, warning, new LocationInfo(expression)));
                        continue;
                    }
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, warning, new PropertyLocationInfo(expression, property)));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }
}

