/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class AlignmentUtilities {
    private final UndoManager undo;
    private PageDefinition originalPageDefinition;
    private PageDefinition currentPageDefinition;
    private List<Element> visualElements;
    private MassElementStyleUndoEntryBuilder builder;

    public AlignmentUtilities(ReportDocumentContext reportRenderContext, PageDefinition pageDefinition) {
        this.undo = reportRenderContext.getUndo();
        MasterReport masterReport = (MasterReport)reportRenderContext.getContextRoot();
        this.currentPageDefinition = masterReport.getPageDefinition();
        this.originalPageDefinition = pageDefinition;
        ArrayList<Element> elementArrayList = new ArrayList<Element>();
        this.collectAlignableElements((Section)masterReport, elementArrayList);
        this.visualElements = Collections.unmodifiableList(elementArrayList);
        this.builder = new MassElementStyleUndoEntryBuilder(this.visualElements);
    }

    public void alignRight() {
        double theCurrentPageWidth = this.currentPageDefinition.getWidth();
        int theShiftRight = (int)(theCurrentPageWidth - StrictGeomUtility.toExternalValue((long)this.computeFarRightPostion()));
        this.align(theShiftRight, this.visualElements);
        this.registerChanges();
    }

    public void alignLeft() {
        int theShiftLeft = (int)(0.0 - StrictGeomUtility.toExternalValue((long)this.computeFarLeftPosition()));
        this.align(theShiftLeft, this.visualElements);
        this.registerChanges();
    }

    public void resizeProportional() {
        float originalPageWidth = this.originalPageDefinition.getWidth();
        float currentPageWidth = this.currentPageDefinition.getWidth();
        float scaleFactor = currentPageWidth / originalPageWidth;
        for (Element element : this.visualElements) {
            CachedLayoutData cachedLayoutData = ModelUtility.getCachedLayoutData(element);
            double elementWidth = StrictGeomUtility.toExternalValue((long)cachedLayoutData.getWidth());
            ElementStyleSheet styleSheet = element.getStyle();
            styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(elementWidth * (double)scaleFactor));
            double origin = StrictGeomUtility.toExternalValue((long)cachedLayoutData.getX());
            double destination = (double)scaleFactor * origin;
            int theShift = (int)(destination - origin);
            ArrayList<Element> elementsCarrier = new ArrayList<Element>(1);
            elementsCarrier.add(element);
            this.align(theShift, elementsCarrier);
        }
        this.registerChanges();
    }

    public void alignCenter() {
        long farLeftPostion = this.computeFarLeftPosition();
        long farRightPostion = this.computeFarRightPostion();
        long currentPageWidth = StrictGeomUtility.toInternalValue((double)this.currentPageDefinition.getWidth());
        long remainingRightSpace = currentPageWidth - farRightPostion;
        long normalizedSpace = (farLeftPostion + remainingRightSpace) / 2L;
        long requiredShift = normalizedSpace - farLeftPostion;
        requiredShift = remainingRightSpace > farLeftPostion ? Math.abs(requiredShift) : 0L - Math.abs(requiredShift);
        int shiftInPoints = (int)StrictGeomUtility.toExternalValue((long)requiredShift);
        this.align(shiftInPoints, this.visualElements);
        this.registerChanges();
    }

    private void align(int theShiftValue, List<Element> elements) {
        MoveDragOperation mop = new MoveDragOperation(elements, new Point(), EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
        mop.update(new Point(theShiftValue, 0), 1.0);
        mop.finish();
    }

    private void registerChanges() {
        MassElementStyleUndoEntry massElementStyleUndoEntry = this.builder.finish();
        this.undo.addChange(Messages.getString("AlignmentUtilities.Undo", new Object[0]), massElementStyleUndoEntry);
    }

    private long computeFarRightPostion() {
        boolean first = true;
        long theFarRightPostion = 0L;
        for (Element visualElement : this.visualElements) {
            CachedLayoutData theElementData = ModelUtility.getCachedLayoutData(visualElement);
            long theCurrentPosition = theElementData.getX() + theElementData.getWidth();
            if (first) {
                theFarRightPostion = theCurrentPosition;
            } else if (theCurrentPosition > theFarRightPostion) {
                theFarRightPostion = theCurrentPosition;
            }
            first = false;
        }
        return theFarRightPostion;
    }

    private long computeFarLeftPosition() {
        boolean first = true;
        long theFarLeftPostion = 0L;
        for (Element visualElement : this.visualElements) {
            CachedLayoutData theElementData = ModelUtility.getCachedLayoutData(visualElement);
            long theCurrentPosition = theElementData.getX();
            theFarLeftPostion = first ? theCurrentPosition : (theCurrentPosition < theFarLeftPostion ? theCurrentPosition : theFarLeftPostion);
            first = false;
        }
        return theFarLeftPostion;
    }

    private void collectAlignableElements(Section section, List<Element> collectedElements) {
        if (section instanceof CrosstabGroup) {
            return;
        }
        int theElementCount = section.getElementCount();
        for (int i = 0; i < theElementCount; ++i) {
            CachedLayoutData cachedLayoutData;
            long layoutAge;
            Element reportElement = section.getElement(i);
            if (reportElement instanceof Section) {
                this.collectAlignableElements((Section)reportElement, collectedElements);
            }
            if ((layoutAge = (cachedLayoutData = ModelUtility.getCachedLayoutData(reportElement)).getLayoutAge()) == -1L || reportElement instanceof RootLevelBand || !(reportElement instanceof Band) && reportElement instanceof Section) continue;
            collectedElements.add(reportElement);
        }
    }
}

