/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.model.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionEvent;
import org.pentaho.reporting.designer.core.model.selection.ReportSelectionListener;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.libraries.designtime.swing.WeakEventListenerList;

public class DefaultReportSelectionModel
implements DocumentContextSelectionModel {
    private WeakEventListenerList listenerList = new WeakEventListenerList();
    private LinkedHashMap<Object, Object> backend = new LinkedHashMap();
    private Object[] valuesCached;

    @Override
    public void addReportSelectionListener(ReportSelectionListener listener) {
        this.listenerList.add(ReportSelectionListener.class, (EventListener)listener);
    }

    @Override
    public void removeReportSelectionListener(ReportSelectionListener listener) {
        this.listenerList.remove(ReportSelectionListener.class, (EventListener)listener);
    }

    @Override
    public int getSelectionCount() {
        return this.backend.size();
    }

    @Override
    public Object getSelectedElement(int index) {
        this.fillCaches();
        return this.valuesCached[index];
    }

    @Override
    public void clearSelection() {
        Object[] objects = this.valuesCached == null ? this.backend.values().toArray() : this.valuesCached;
        for (int i = 0; i < objects.length; ++i) {
            this.remove(objects[i]);
        }
    }

    private boolean contains(Object[] elements, Object o) {
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelectedElements(Object[] elements) {
        Iterator<Object> iterator = this.backend.values().iterator();
        while (iterator.hasNext()) {
            Object elementFromOldSelection = iterator.next();
            if (this.contains(elements, elementFromOldSelection)) continue;
            iterator.remove();
            this.valuesCached = null;
            this.fireSelectionRemoved(elementFromOldSelection);
        }
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            Object key = this.computeKey(element);
            if (this.backend.containsKey(key)) continue;
            this.backend.put(key, element);
            this.valuesCached = null;
            this.fireSelectionAdded(element);
        }
    }

    private Object computeKey(Object o) {
        if (o instanceof Element) {
            Element e = (Element)o;
            return e.getObjectID();
        }
        return System.identityHashCode(o);
    }

    protected void fireSelectionAdded(Object selection) {
        ReportSelectionEvent event = new ReportSelectionEvent(this, selection);
        ReportSelectionListener[] reportSelectionListeners = (ReportSelectionListener[])this.listenerList.getListeners(ReportSelectionListener.class);
        for (int i = 0; i < reportSelectionListeners.length; ++i) {
            ReportSelectionListener listener = reportSelectionListeners[i];
            listener.selectionAdded(event);
        }
        this.fireLeadSelectionChanged(this.getLeadSelection());
    }

    protected void fireSelectionRemoved(Object selection) {
        ReportSelectionEvent event = new ReportSelectionEvent(this, selection);
        ReportSelectionListener[] reportSelectionListeners = (ReportSelectionListener[])this.listenerList.getListeners(ReportSelectionListener.class);
        for (int i = 0; i < reportSelectionListeners.length; ++i) {
            ReportSelectionListener listener = reportSelectionListeners[i];
            listener.selectionRemoved(event);
        }
        this.fireLeadSelectionChanged(this.getLeadSelection());
    }

    protected void fireLeadSelectionChanged(Object selection) {
        ReportSelectionEvent event = new ReportSelectionEvent(this, selection);
        ReportSelectionListener[] reportSelectionListeners = (ReportSelectionListener[])this.listenerList.getListeners(ReportSelectionListener.class);
        for (int i = 0; i < reportSelectionListeners.length; ++i) {
            ReportSelectionListener listener = reportSelectionListeners[i];
            listener.leadSelectionChanged(event);
        }
    }

    @Override
    public boolean add(Object element) {
        Object key = this.computeKey(element);
        if (!this.backend.containsKey(key)) {
            this.backend.put(key, element);
            this.valuesCached = null;
            this.fireSelectionAdded(element);
            return true;
        }
        return false;
    }

    @Override
    public void remove(Object element) {
        Object key = this.computeKey(element);
        if (this.backend.containsKey(key)) {
            this.backend.remove(key);
            this.valuesCached = null;
            this.fireSelectionRemoved(element);
        }
    }

    @Override
    public boolean isSelected(Object o) {
        return this.backend.containsKey(this.computeKey(o));
    }

    @Override
    public Object[] getSelectedElements() {
        this.fillCaches();
        return (Object[])this.valuesCached.clone();
    }

    @Override
    public Object getLeadSelection() {
        if (this.backend.isEmpty()) {
            return null;
        }
        this.fillCaches();
        return this.valuesCached[this.valuesCached.length - 1];
    }

    private void fillCaches() {
        if (this.valuesCached == null) {
            this.valuesCached = this.backend.values().toArray();
        }
    }

    @Override
    public <T> List<T> getSelectedElementsOfType(Class<T> t) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : this.backend.values()) {
            if (!t.isInstance(o)) continue;
            list.add(o);
        }
        return Collections.unmodifiableList(list);
    }
}

